/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.authentication;

import com.cognos.xqe.authentication.AuthenticationType;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.IUsernamePasswordSignon;
import com.cognos.xqe.data.providers.relational.AbstractConnection;
import com.cognos.xqe.exception.XQERuntimeException;
import com.ibm.json.java.JSON;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import net.minidev.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.util.URIUtil;

public class AuthenticationHelper {
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String UTF_8 = "UTF-8";
    public static final String FILE = "file://";
    public static final String ENCODE = "ENCODE";
    private static final String AUTHORIZATION = "Authorization";
    private static final String S_S = "%s:%s";
    private static final String BASIC_S = "Basic %s";

    public static GetMethod createGetMethod(IDataSource dataSource, String targetURL) throws URIException {
        AuthenticationType authType = AuthenticationType.NONE;
        String userId = null;
        String password = null;
        IDataSourceConnection dsConnection = dataSource.getDataSourceConnection();
        IUsernamePasswordSignon signon = (IUsernamePasswordSignon)dsConnection.getSignon();
        if (signon != null) {
            authType = AuthenticationType.BASIC;
            userId = signon.getUserName();
            password = signon.getPassword().decrypt();
        }
        return AuthenticationHelper.createGetMethod(dataSource.getCMDataSourceName(), authType, userId, password, targetURL);
    }

    public static GetMethod createGetMethod(String dataSourceName, AuthenticationType authType, String userName, String password, String targetURL) throws URIException {
        String authHeader = null;
        switch (authType) {
            case NONE: 
            case APIKEY: {
                break;
            }
            case BASIC: {
                String uidPwd = String.format(S_S, userName, password);
                String encoding = new String(Base64.encodeBase64((byte[])uidPwd.getBytes()));
                authHeader = String.format(BASIC_S, encoding);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        GetMethod httpGet = new GetMethod(targetURL);
        if (authHeader != null) {
            httpGet.setRequestHeader(AUTHORIZATION, authHeader);
        }
        return httpGet;
    }

    public static HttpMethod createHttpMethod(String type, String dataSourceName, AuthenticationType authType, String userName, String password, String targetURL) throws URIException {
        String authHeader = null;
        switch (authType) {
            case NONE: 
            case APIKEY: {
                break;
            }
            case BASIC: {
                String uidPwd = String.format(S_S, userName, password);
                String encoding = new String(Base64.encodeBase64((byte[])uidPwd.getBytes()));
                authHeader = String.format(BASIC_S, encoding);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        HttpMethod httpMethod = AuthenticationHelper.createHttpMethod(type, targetURL);
        if (authHeader != null) {
            httpMethod.setRequestHeader(AUTHORIZATION, authHeader);
        }
        return httpMethod;
    }

    private static HttpMethod createHttpMethod(String type, String url) {
        if (type.equals("GET")) {
            return new GetMethod(url);
        }
        if (type.equals("POST")) {
            return new PostMethod(url);
        }
        throw new IllegalArgumentException();
    }

    public static URLConnection createURLConnection(AbstractConnection connection, Map<String, Object> properties) throws IOException {
        String userName = null;
        String password = null;
        String dataSourceName = null;
        AuthenticationType authType = AuthenticationType.NONE;
        if (connection != null) {
            IDataSource dataSource = connection.getDataSource();
            IDataSourceConnection dsConnection = dataSource.getDataSourceConnection();
            IUsernamePasswordSignon signon = (IUsernamePasswordSignon)dsConnection.getSignon();
            dataSourceName = dataSource.getCMDataSourceName();
            if (signon != null) {
                userName = signon.getUserName();
                password = signon.getPassword().decrypt();
                authType = connection.getAuthenticationType();
            }
        }
        return AuthenticationHelper.createURLConnection(dataSourceName, userName, password, authType, properties);
    }

    public static URLConnection createURLConnection(String dataSourceName, String userName, String password, AuthenticationType authType, Map<String, Object> properties) throws IOException {
        String targetURL = (String)properties.get("URL");
        if (targetURL.startsWith(FILE)) {
            return AuthenticationHelper.createSimpleURLConnection(targetURL);
        }
        String method = (String)properties.get("METHOD");
        String mimeType = (String)properties.get("MIME_TYPE");
        Object data = properties.get("DATA");
        String authHeader = null;
        switch (authType) {
            case NONE: {
                break;
            }
            case BASIC: {
                String uidPwd = String.format(S_S, userName, password);
                String encoding = new String(Base64.encodeBase64((byte[])uidPwd.getBytes()));
                authHeader = String.format(BASIC_S, encoding);
                break;
            }
            case APIKEY: {
                URL tmpURL = new URL(targetURL);
                String formatStr = tmpURL.getQuery() == null ? "%s?%s=%s" : "%s&%s=%s";
                targetURL = String.format(formatStr, targetURL, userName, password);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        Boolean doEncode = true;
        if (properties.containsKey(ENCODE)) {
            doEncode = (Boolean)properties.get(ENCODE);
        }
        if (method.equals("GET") && doEncode.booleanValue()) {
            targetURL = URIUtil.encodeQuery((String)targetURL, (String)UTF_8);
        }
        URL url = new URL(targetURL);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        if (authHeader != null) {
            connection.setRequestProperty(AUTHORIZATION, authHeader);
        }
        if (method.equals("POST")) {
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty(CONTENT_TYPE, mimeType);
            if (data != null) {
                String body;
                if (data instanceof JSONObject) {
                    body = ((JSONObject)data).toJSONString();
                } else {
                    body = (String)data;
                    if (mimeType.equals("application/json")) {
                        try {
                            JSON.parse((String)body);
                        }
                        catch (IOException e) {
                            throw new XQERuntimeException(e);
                        }
                    }
                }
                DataOutputStream oStream = new DataOutputStream(connection.getOutputStream());
                oStream.writeBytes(body);
                oStream.flush();
                oStream.close();
            }
        }
        return connection;
    }

    public static URLConnection createSimpleURLConnection(String targetURL) throws IOException {
        URL url = new URL(targetURL);
        URLConnection connection = url.openConnection();
        return connection;
    }
}

