/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler;

import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQueryExecuteMetrics;
import java.math.BigInteger;

public abstract class CubeRequestMetrics {
    private String cubeName = null;
    private int dataCacheNumberOfRequests = 0;
    private long dataCacheTotalTime = 0L;
    private BigInteger dataCacheCellsRequested = BigInteger.ZERO;
    private BigInteger dataCacheCellsNotFound = BigInteger.ZERO;
    private long dataCacheNonNullCellsSolved = 0L;
    private int exprCacheNumberOfRequests = 0;
    private long exprCacheTotalTime = 0L;
    private int exprCacheNumberOfHits = 0;
    private int resultSetCacheNumberOfRequests = 0;
    private long resultSetCacheTotalTime = 0L;
    private int resultSetCacheNumberOfHits = 0;
    private long totalPipelineWaitTime = 0L;

    public CubeRequestMetrics(String theCubeName) {
        this.cubeName = theCubeName;
    }

    public String getCubeName() {
        return this.cubeName;
    }

    public int getDataCacheNumberOfRequests() {
        return this.dataCacheNumberOfRequests;
    }

    public long getDataCacheTotalTime() {
        return this.dataCacheTotalTime;
    }

    public BigInteger getDataCacheCellsRequested() {
        return this.dataCacheCellsRequested;
    }

    public BigInteger getDataCacheCellsNotFound() {
        return this.dataCacheCellsNotFound;
    }

    public long getDataCacheNonNullCellsSolved() {
        return this.dataCacheNonNullCellsSolved;
    }

    public int getExprCacheNumberOfRequests() {
        return this.exprCacheNumberOfRequests;
    }

    public long getExprCacheTotalTime() {
        return this.exprCacheTotalTime;
    }

    public int getExprCacheNumberOfHits() {
        return this.exprCacheNumberOfHits;
    }

    public int getResultSetCacheNumberOfRequests() {
        return this.resultSetCacheNumberOfRequests;
    }

    public long getResultSetCacheTotalTime() {
        return this.resultSetCacheTotalTime;
    }

    public int getResultSetCacheNumberOfHits() {
        return this.resultSetCacheNumberOfHits;
    }

    public void addResultSetCacheRequest(long requestTime, boolean hit) {
        ++this.resultSetCacheNumberOfRequests;
        this.resultSetCacheTotalTime += requestTime;
        if (hit) {
            ++this.resultSetCacheNumberOfHits;
        }
    }

    public void addExpressionCacheRequest(long requestTime, boolean hit) {
        ++this.exprCacheNumberOfRequests;
        this.exprCacheTotalTime += requestTime;
        if (hit) {
            ++this.exprCacheNumberOfHits;
        }
    }

    public void update(ROLAPQueryExecuteMetrics qsMetrics) {
        if (qsMetrics.hadDataCacheRequest()) {
            this.dataCacheTotalTime += qsMetrics.getDataCacheTotalTime();
            this.dataCacheNonNullCellsSolved += (long)qsMetrics.getDataCacheHits();
            this.dataCacheCellsRequested = this.dataCacheCellsRequested.add(qsMetrics.getDataCacheRequestSetSize());
            this.dataCacheCellsNotFound = this.dataCacheCellsNotFound.add(qsMetrics.getDataCacheReturnSetSize());
            ++this.dataCacheNumberOfRequests;
        }
    }

    public long getTotalPipelineWaitTime() {
        return this.totalPipelineWaitTime;
    }

    public void incrementPipelineWaitTime(long waitTime) {
        this.totalPipelineWaitTime += waitTime;
    }
}

