/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.p2plb.model.NodeID;
import com.cognos.p2plb.model.NodeIdGuidMapper;
import com.cognos.pogo.bibus.SoapFaultException;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.xml.SAXReaderPool;
import com.cognos.xqe.ast.v5.utils.SimpleSaxParser;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.exception.XQESOAPFaultException;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqebifw.bibushandler.content.CMQuery;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.rmi.server.UID;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;

public final class DQWarmupEnvironment {
    private static final String ERROR = "Error";
    public static final String NAMESPACE_PREFIX_SOAP_ENV = "SOAP-ENV";
    public static final String SOAP_HEADER = "Header";
    public static final String SOAP_BODY = "Body";
    private static final String CONTENT_MGR_URI = "contentManagerURI";
    private static final String CONTENT_MGR_URI_VALUE;
    private static Element junitBiBusElement;
    private static String junitBiBusConversationContextID;
    private static final int INT_VALUE_10 = 10;
    private static final int INT_VALUE_1234 = 1234;
    private static final String TRUE = "true";

    private DQWarmupEnvironment() {
    }

    private static String getCCLProperty(String propertyName) throws XQERuntimeException {
        ICCLConfiguration configuration = CCLConfigurationFactory.getInstance();
        try {
            configuration.init();
            Element valueElement = configuration.getValueElement(propertyName, true);
            Element itemElement = valueElement.element("item");
            if (itemElement == null) {
                return valueElement.getText();
            }
            return itemElement.getText();
        }
        catch (CCLConfigurationException e) {
            throw new XQERuntimeException(e);
        }
    }

    public static String getTestContentManagerURL() throws XQERuntimeException {
        return DQWarmupEnvironment.getCCLProperty("contentManagers");
    }

    public static String getTestDispatcherURL() throws XQERuntimeException {
        return DQWarmupEnvironment.getCCLProperty("externalDispatcher");
    }

    private static Element setUpAndRetrieveConnectionElement(Element rootElement) {
        Element connectionElement = rootElement.element("connection");
        DQWarmupEnvironment.setUpConnectionElement(connectionElement);
        return connectionElement;
    }

    private static void setUpConnectionElement(Element connectionElement) {
        if (connectionElement == null) {
            throw new RuntimeException("the connection element is missing in test input");
        }
        Element cmElement = connectionElement.element(CONTENT_MGR_URI);
        if (cmElement != null) {
            cmElement.detach();
        }
        cmElement = connectionElement.addElement(CONTENT_MGR_URI);
        cmElement.addAttribute("value", CONTENT_MGR_URI_VALUE);
    }

    private static Element getDetachedCommand(Element rootElement) {
        Element commandElement = RequestEnvironment.getCommandElement(rootElement);
        if (commandElement == null) {
            throw new RuntimeException("the command element is missing in test input");
        }
        commandElement.detach();
        return commandElement;
    }

    public static Document getTestAsDOM(String fileName) {
        SimpleSaxParser saxParser = new SimpleSaxParser();
        try {
            BufferedInputStream fileInputStream = new BufferedInputStream(new FileInputStream(fileName));
            saxParser.parseStream(fileInputStream);
            ((InputStream)fileInputStream).close();
        }
        catch (Exception ex) {
            XQEDebugLog.err.println(ERROR + ex.getLocalizedMessage());
            XQEDebugLog.err.printStackTrace(ex);
        }
        return saxParser.getDocument();
    }

    public static void setUpRequest(RequestEnvironment reqEnv, Document requestDocument, boolean substituteCommandWithPrepare) {
        DQWarmupEnvironment.setUpRequest(reqEnv, requestDocument, substituteCommandWithPrepare, null);
    }

    public static void setUpRequest(RequestEnvironment reqEnv, Document requestDocument, boolean substituteCommandWithPrepare, String overrideOp) {
        MultiRequestContext multiRequestContext = ((ExecutionEnvironment)reqEnv.getExecutionEnvironment()).getMultiRequestContextNoThrow();
        if (null == multiRequestContext) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "null == multiRequestContext");
        }
        String requestID = reqEnv.getRequestID();
        if (null == requestID) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "null == requestID");
        }
        multiRequestContext.setRequestDocument(requestDocument);
        Element oldRootElement = requestDocument.getRootElement();
        DQWarmupEnvironment.setUpRequestID(oldRootElement, requestID);
        Element connectionElement = DQWarmupEnvironment.setUpAndRetrieveConnectionElement(oldRootElement);
        ((ExecutionEnvironment)reqEnv.getExecutionEnvironment()).setConnectionElement(connectionElement);
        String operationName = null;
        String oldRootElementName = oldRootElement.getName();
        if (oldRootElementName.equals("command")) {
            Attribute resolveConn;
            oldRootElement.detach();
            Element oldCommandElement = DQWarmupEnvironment.getDetachedCommand(oldRootElement);
            operationName = substituteCommandWithPrepare ? "prepare" : oldCommandElement.getName();
            if (operationName.equals("getParameters") && (resolveConn = oldCommandElement.attribute("resolveConnection")) != null && resolveConn.getText().equals(TRUE)) {
                reqEnv.setResolveConnection(true);
            }
            Element newCommandElement = requestDocument.addElement(operationName);
            DQWarmupEnvironment.relocateElements(oldRootElement, newCommandElement, "connection", true);
            DQWarmupEnvironment.relocateElements(oldCommandElement, newCommandElement);
            DQWarmupEnvironment.relocateElements(oldRootElement, newCommandElement, "connection", false);
        } else {
            operationName = overrideOp != null ? overrideOp : (oldRootElementName.equals("validate") ? oldRootElementName : "execute");
        }
        reqEnv.setOperationName(operationName);
        Element rootElement = requestDocument.getRootElement();
        reqEnv.extractParametersFromCommand(rootElement);
        reqEnv.setRequestID(requestID);
    }

    public static void setUpRequest(RequestEnvironment reqEnv, Document requestDocument) {
        DQWarmupEnvironment.setUpRequest(reqEnv, requestDocument, false);
    }

    private static void relocateElements(Element fromElement, Element toElement) {
        List elements = fromElement.elements();
        for (Element element : elements) {
            element.detach();
            toElement.add(element);
        }
    }

    private static void relocateElements(Element fromElement, Element toElement, String elementName, boolean include) {
        List elements = fromElement.elements();
        for (Element element : elements) {
            if (include) {
                if (!element.getName().equals(elementName)) continue;
                element.detach();
                toElement.add(element);
                break;
            }
            if (element.getName().equals(elementName)) continue;
            element.detach();
            toElement.add(element);
        }
    }

    private static String createFakeRequestID() {
        return new UID().toString();
    }

    public static String setUpRequestID(Element commandElement) {
        return DQWarmupEnvironment.setUpRequestID(commandElement, DQWarmupEnvironment.createFakeRequestID());
    }

    public static String setUpRequestID(Element commandElement, String requestID) {
        boolean foundRequestIDElementInCommand = DQWarmupEnvironment.setUpRequestIDValue(commandElement, requestID);
        if (!foundRequestIDElementInCommand) {
            Element requestIDElement = commandElement.addElement("requestID");
            requestIDElement.addAttribute("value", requestID);
        }
        for (Element element : commandElement.elements()) {
            DQWarmupEnvironment.removeRequestIDValue(element);
        }
        return requestID;
    }

    public static void createQueryServiceSessionContextSection(Element envelopeElement, String sessionContextID) {
        Element soapBodyElement = envelopeElement.element(SOAP_BODY);
        Element queryServiceSessionContextID = soapBodyElement.addElement("queryServiceSessionContext");
        queryServiceSessionContextID.addAttribute("id", sessionContextID);
        queryServiceSessionContextID.addAttribute("create", TRUE);
    }

    public static String extractQueryServiceSessionContextID(Element envelopeElement, boolean removeQueryServiceSessionContextID) {
        String result = null;
        Element soapBodyElement = envelopeElement.element(SOAP_BODY);
        Element queryServiceSessionContextID = soapBodyElement.element("queryServiceSessionContext");
        if (null != queryServiceSessionContextID) {
            result = queryServiceSessionContextID.attributeValue("id");
            if (removeQueryServiceSessionContextID) {
                soapBodyElement.remove(queryServiceSessionContextID);
            }
        }
        return result;
    }

    private static boolean setUpRequestIDValue(Element element, String requestID) {
        Element subrequestIDElement;
        DQWarmupEnvironment.removeDuplicateChildren(element, "requestID");
        DQWarmupEnvironment.removeDuplicateChildren(element, "subRequestID");
        Element requestIDElement = element.element("requestID");
        if (null != requestIDElement) {
            requestIDElement.addAttribute("value", requestID);
        }
        if (null != (subrequestIDElement = element.element("subRequestID"))) {
            subrequestIDElement.addAttribute("value", requestID);
        }
        return null != requestIDElement;
    }

    public static Element getOrCreateBiBusHeader() {
        if (junitBiBusElement != null) {
            return (Element)junitBiBusElement.clone();
        }
        return DQWarmupEnvironment.createBiBusHeader();
    }

    public static Element createBiBusHeader() {
        CMQuery queryCommand = new CMQuery("/");
        try {
            BIBusEnvelope queryEnvelope = new BIBusEnvelope();
            queryEnvelope.setCAMaction("logon");
            Element queryBIBusHeader = queryEnvelope.getBIBusHeader();
            queryBIBusHeader.detach();
            queryCommand.setBIBusHeader(queryBIBusHeader);
            queryCommand.execute();
            BIBusEnvelope responseEnvelope = queryCommand.getResponseEnvelope();
            junitBiBusConversationContextID = responseEnvelope.getRequestContext();
            responseEnvelope.setConversationContextID(junitBiBusConversationContextID);
            responseEnvelope.setConversationContextNodeID("TestEnvironment.getOrCreateBiBusHeader()FakeNodeId");
            responseEnvelope.setConversationContextProcessID(1234);
            junitBiBusElement = responseEnvelope.getBIBusHeader();
            junitBiBusElement.detach();
        }
        catch (SoapFaultException sfe) {
            BIBusEnvelope faultEnvelope = queryCommand.getResponseEnvelope();
            throw new XQESOAPFaultException(faultEnvelope);
        }
        catch (Exception ex) {
            XQELog.logConsole("TestEnvironment: CM is not running. Creating dummy BiBusHeader.");
            BIBusEnvelope env = new BIBusEnvelope();
            junitBiBusElement = env.getBIBusHeader();
            junitBiBusElement.detach();
        }
        return (Element)junitBiBusElement.clone();
    }

    public static String getOrCreateBiBusConversationContextID() {
        DQWarmupEnvironment.getOrCreateBiBusHeader();
        return junitBiBusConversationContextID;
    }

    private static void removeDuplicateChildren(Element element, String childName) {
        boolean first = true;
        for (Element child : element.elements(childName)) {
            if (first) {
                first = false;
                continue;
            }
            child.detach();
        }
    }

    private static void removeRequestIDValue(Element element) {
        Element subrequestIDElement;
        Element requestIDElement = element.element("requestID");
        if (null != requestIDElement) {
            requestIDElement.detach();
        }
        if (null != (subrequestIDElement = element.element("subRequestID"))) {
            subrequestIDElement.detach();
        }
        for (Element child : element.elements()) {
            DQWarmupEnvironment.removeRequestIDValue(child);
        }
    }

    static {
        junitBiBusElement = null;
        junitBiBusConversationContextID = null;
        CONTENT_MGR_URI_VALUE = DQWarmupEnvironment.getTestDispatcherURL();
        SAXReaderPool.prepare((boolean)true, (int)10);
        NodeIdGuidMapper.setContentManagerNID((NodeID)NodeID.getNodeID((String)CONTENT_MGR_URI_VALUE));
    }
}

