/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.AggregateAdvisorProgressPoint;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.AggregateAdvisorState;
import com.cognos.xqe.bibushandler.ROLAPCommandResponseUtility;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorRecommendations;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.Aggregate;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management.AdvisorCommandResult;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management.AdvisorGetCurrentWorkloadResult;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management.AdvisorGetRecommendationResult;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management.AdvisorRetrieveInitialRecommendationsResult;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management.AdvisorRetrieveSubsequentRecommendationsResult;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management.AdvisorStoreRecommendationResult;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.recommendation.RecommendationFileUtility;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMeasure;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class ROLAPAdvisorCommandResponseUtility {
    private static final XQELogger LOGGER = ROLAPLog.getLogger("ROLAPAggregateAdvisor", LogLevel.TRACE);
    private static final QName QN_AGGREGATE_ADVISOR_RECOMMENDATIONS_REPLY = DocumentHelper.createQName((String)"aggregateAdvisorRecommendationsReply");
    private static final QName QN_OPTIONS = DocumentHelper.createQName((String)"options");
    private static final QName QN_OPTION = DocumentHelper.createQName((String)"option");
    private static final QName QN_PROPERTIES = DocumentHelper.createQName((String)"properties");
    private static final QName QN_PROPERTY = DocumentHelper.createQName((String)"property");
    private static final QName QN_VALUE = DocumentHelper.createQName((String)"value");
    private static final QName QN_STATE = DocumentHelper.createQName((String)"state");
    private static final QName QN_MESSAGES = DocumentHelper.createQName((String)"messages");
    private static final QName QN_MESSAGE = DocumentHelper.createQName((String)"message");
    private static final QName QN_PROGRESS = DocumentHelper.createQName((String)"progress");
    private static final QName QN_PROGRESS_POINT = DocumentHelper.createQName((String)"progressPoint");
    private static final QName QN_PROGRESS_TIME = DocumentHelper.createQName((String)"progressTime");
    private static final QName QN_PROGRESS_VALUE = DocumentHelper.createQName((String)"progressValue");
    private static final QName QN_RECOMMENDATIONS = DocumentHelper.createQName((String)"recommendations");
    private static final QName QN_RECOMMENDED_AGGREGATES_IN_DATABASE = DocumentHelper.createQName((String)"recommendedAggregatesInDatabase");
    private static final QName QN_RECOMMENDED_AGGREGATES_IN_MEMORY = DocumentHelper.createQName((String)"recommendedAggregatesInMemory");
    private static final QName QN_META_INFO_TEXT = DocumentHelper.createQName((String)"metaInfoText");
    private static final QName QN_META_INFO_XML = DocumentHelper.createQName((String)"metaInfoXML");
    private static final QName QN_COUNT = DocumentHelper.createQName((String)"count");
    private static final QName QN_COVERAGE = DocumentHelper.createQName((String)"coverage");
    private static final QName QN_SPACE_REQUIRED = DocumentHelper.createQName((String)"spaceRequired");
    private static final QName QN_RECOMMENDED_AGGREGATES = DocumentHelper.createQName((String)"recommendedAggregates");
    private static final QName QN_RECOMMENDED_AGGREGATE = DocumentHelper.createQName((String)"recommendedAggregate");
    private static final QName QN_NAME = DocumentHelper.createQName((String)"name");
    private static final QName QN_SIZE = DocumentHelper.createQName((String)"size");
    private static final QName QN_LEVELS = DocumentHelper.createQName((String)"levels");
    private static final QName QN_LEVEL = DocumentHelper.createQName((String)"level");
    private static final QName QN_MEASURES = DocumentHelper.createQName((String)"measures");
    private static final QName QN_MEASURE = DocumentHelper.createQName((String)"measure");
    private static final QName QN_AGGREGATE_ADVISOR_CURRENT_WORKLOAD_REPLY = DocumentHelper.createQName((String)"aggregateAdvisorCurrentWorkloadReply");
    private static final QName QN_TIME_FRAME = DocumentHelper.createQName((String)"timeFrame");
    private static final QName QN_START_TIME = DocumentHelper.createQName((String)"startTime");
    private static final QName QN_END_TIME = DocumentHelper.createQName((String)"endTime");
    private static final QName QN_PACKAGE_NAMES = DocumentHelper.createQName((String)"packageNames");
    private static final QName QN_PACKAGE_NAME = DocumentHelper.createQName((String)"packageName");
    private static final QName QN_REPORT_NAMES = DocumentHelper.createQName((String)"reportNames");
    private static final QName QN_REPORT_NAME = DocumentHelper.createQName((String)"reportName");
    private static final QName QN_USER_NAMES = DocumentHelper.createQName((String)"userNames");
    private static final QName QN_USER_NAME = DocumentHelper.createQName((String)"userName");
    private static final QName QN_AGGREGATE_ADVISOR_RETRIEVE_RECOMMENDATIONS_REPLY = DocumentHelper.createQName((String)"aggregateAdvisorRetrieveRecommendationsReply");
    private static final QName QN_AGGREGATE_ADVISOR_RECOMMENDATIONS_REPLIES = DocumentHelper.createQName((String)"aggregateAdvisorRecommendationsReplies");
    private static final QName QN_AGGREGATE_ADVISOR_STORE_RECOMMENDATION_REPLY = DocumentHelper.createQName((String)"aggregateAdvisorStoreRecommendationReply");
    private static final QName QN_AGGREGATE_ADVISOR_REPLY = DocumentHelper.createQName((String)"aggregateAdvisorReply");

    public static BIBusEnvelope createResponseEnvelope(BIBusEnvelope requestEnvelope, String commandName, AdvisorCommandResult result) {
        BIBusEnvelope responseEnvelope = new BIBusEnvelope();
        ROLAPAdvisorCommandResponseUtility.addCommandResponseElement(requestEnvelope, responseEnvelope, commandName, result);
        return responseEnvelope;
    }

    private static void addCommandResponseElement(BIBusEnvelope requestEnvelope, BIBusEnvelope responseEnvelope, String commandName, AdvisorCommandResult result) {
        Element commandResponseElement = ROLAPCommandResponseUtility.createCommandResponseElement(commandName);
        if (commandName.equals("getCurrentWorkloadForAggregateAdvisor")) {
            ROLAPAdvisorCommandResponseUtility.addAggregateAdvisorCurrentWorkloadReplyElement(commandResponseElement, result);
        } else if (commandName.equals("retrieveInitialAggregateAdvisorRecommendations") || commandName.equals("retrieveSubsequentAggregateAdvisorRecommendations")) {
            ROLAPAdvisorCommandResponseUtility.addAggregateAdvisorRetrieveRecommendationsReplyElement(commandResponseElement, result);
        } else if (commandName.equals("storeAggregateAdvisorRecommendation")) {
            ROLAPAdvisorCommandResponseUtility.addAggregateAdvisorStoreRecommendationReplyElement(commandResponseElement, result);
        } else if (commandName.equals("updateAggregateAdvisorRecommendationName") || commandName.equals("deleteAggregateAdvisorRecommendations") || commandName.equals("replaceAggregateAdvisorSession") || commandName.equals("migrateAggregateAdvisorRecommendation")) {
            ROLAPAdvisorCommandResponseUtility.addAggregateAdvisorReplyElement(commandResponseElement, result);
        } else {
            ROLAPAdvisorCommandResponseUtility.addAggregateAdvisorRecommendationsReplyElement(commandResponseElement, result);
        }
        responseEnvelope.getBody().add(commandResponseElement);
    }

    private static void addAggregateAdvisorRecommendationsReplyElement(Element commandResponseElement, AdvisorCommandResult result) {
        Element aggregateAdvisorRecommendationsReplyElement = commandResponseElement.addElement(QN_AGGREGATE_ADVISOR_RECOMMENDATIONS_REPLY);
        ROLAPAdvisorCommandResponseUtility.addResult(aggregateAdvisorRecommendationsReplyElement, result, true);
    }

    public static void addResult(Element parentElement, AdvisorCommandResult result, boolean addProgressPoints) {
        ROLAPAdvisorCommandResponseUtility.addStateElement(parentElement, result.getState());
        ROLAPAdvisorCommandResponseUtility.addMessagesElement(parentElement, result.getMessages());
        if (result instanceof AdvisorGetRecommendationResult) {
            ROLAPAdvisorCommandResponseUtility.addRecommendation(parentElement, (AdvisorGetRecommendationResult)result, addProgressPoints);
        }
    }

    public static void addStateElement(Element parentElement, AggregateAdvisorState state) {
        if (state != null) {
            Element stateElement = parentElement.addElement(QN_STATE);
            stateElement.setText(state.toString());
        }
    }

    public static void addMessagesElement(Element parentElement, List<String> messages) {
        if (messages != null && !messages.isEmpty()) {
            Element messagesElement = parentElement.addElement(QN_MESSAGES);
            for (String message : messages) {
                if (message == null) continue;
                Element messageElement = messagesElement.addElement(QN_MESSAGE);
                messageElement.setText(message);
            }
        }
    }

    private static void addRecommendation(Element parentElement, AdvisorGetRecommendationResult result, boolean addProgressPoints) {
        List<AggregateAdvisorProgressPoint> progress;
        ROLAPAdvisorCommandResponseUtility.addOptionsElement(parentElement, result.getOptions());
        ROLAPAdvisorCommandResponseUtility.addPropertiesElement(parentElement, result.getProperties());
        if (addProgressPoints && (progress = result.getProgress()) != null && !progress.isEmpty()) {
            Element progressElement = parentElement.addElement(QN_PROGRESS);
            for (AggregateAdvisorProgressPoint point : progress) {
                Element pointElement = progressElement.addElement(QN_PROGRESS_POINT);
                Element timeElement = pointElement.addElement(QN_PROGRESS_TIME);
                timeElement.addText(String.valueOf(point.getProgressTime()));
                Element valueElement = pointElement.addElement(QN_PROGRESS_VALUE);
                valueElement.addText(String.valueOf(point.getProgressValue()));
            }
        }
        if (result.getRecommendations() != null) {
            Element recommendationsElement = parentElement.addElement(QN_RECOMMENDATIONS);
            AdvisorRecommendations recommendations = result.getRecommendations();
            Element recommendedAggregatesInDatabaseElement = recommendationsElement.addElement(QN_RECOMMENDED_AGGREGATES_IN_DATABASE);
            ROLAPAdvisorCommandResponseUtility.populateAggregates(recommendedAggregatesInDatabaseElement, recommendations.getInDatabaseRecommendationsAsText(), recommendations.getInDatabaseRecommendationsAsXML(), recommendations.getInDatabaseAggregatesCoverage(), recommendations.getInDatabaseAggregatesEstimatedSize(), recommendations.getInDatabaseAggregates());
            Element recommendedAggregatesInMemoryElement = recommendationsElement.addElement(QN_RECOMMENDED_AGGREGATES_IN_MEMORY);
            try {
                StringWriter sw = new StringWriter();
                recommendations.getInMemoryRecommendationsAsXML(sw);
                ROLAPAdvisorCommandResponseUtility.populateAggregates(recommendedAggregatesInMemoryElement, null, sw.toString(), recommendations.getInMemoryAggregatesCoverage(), recommendations.getInMemoryAggregatesEstimatedSize(), recommendations.getInMemoryAggregates());
                sw.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void addOptionsElement(Element parentElement, Map<String, String> options) {
        if (options != null && !options.isEmpty()) {
            Element optionsElement = parentElement.addElement(QN_OPTIONS);
            Set<String> optionNames = options.keySet();
            for (String optionName : optionNames) {
                String optionValue = options.get(optionName);
                Element optionElement = optionsElement.addElement(QN_OPTION);
                Element nameElement = optionElement.addElement(QN_NAME);
                nameElement.setText(optionName);
                Element valueElement = optionElement.addElement(QN_VALUE);
                valueElement.setText(optionValue);
            }
        }
    }

    public static void addPropertiesElement(Element parentElement, Properties properties) {
        if (properties != null && !properties.isEmpty()) {
            Element propertiesElement = parentElement.addElement(QN_PROPERTIES);
            Set<String> propertyNames = properties.stringPropertyNames();
            for (String propertyName : propertyNames) {
                String propertyValue = properties.getProperty(propertyName);
                Element propertyElement = propertiesElement.addElement(QN_PROPERTY);
                Element nameElement = propertyElement.addElement(QN_NAME);
                nameElement.setText(propertyName);
                Element valueElement = propertyElement.addElement(QN_VALUE);
                valueElement.setText(propertyValue);
            }
        }
    }

    private static void populateAggregates(Element recommendedAggregatesInElement, String metaInfoText, String metaInfoXML, long coverage, long spaceRequired, List<Aggregate> aggregates) {
        if (metaInfoText != null) {
            Element metaInfoTextElement = recommendedAggregatesInElement.addElement(QN_META_INFO_TEXT);
            metaInfoTextElement.addCDATA(metaInfoText);
        }
        Element metaInfoXMLElement = recommendedAggregatesInElement.addElement(QN_META_INFO_XML);
        metaInfoXMLElement.setText(metaInfoXML);
        Element countElement = recommendedAggregatesInElement.addElement(QN_COUNT);
        countElement.addText(String.valueOf(aggregates.size()));
        Element coverageElement = recommendedAggregatesInElement.addElement(QN_COVERAGE);
        coverageElement.addText(String.valueOf(coverage));
        Element spaceRequiredElement = recommendedAggregatesInElement.addElement(QN_SPACE_REQUIRED);
        spaceRequiredElement.addText(String.valueOf(spaceRequired));
        Element recommendedAggregatesElement = recommendedAggregatesInElement.addElement(QN_RECOMMENDED_AGGREGATES);
        for (Aggregate aggr : aggregates) {
            Element recommendedAggregateElement = recommendedAggregatesElement.addElement(QN_RECOMMENDED_AGGREGATE);
            Element nameElement = recommendedAggregateElement.addElement(QN_NAME);
            nameElement.addText(aggr.getName());
            Element sizeElement = recommendedAggregateElement.addElement(QN_SIZE);
            sizeElement.addText(String.valueOf(aggr.getEstimatedSize()));
            Element levelsElement = recommendedAggregateElement.addElement(QN_LEVELS);
            List<ROLAPMetaLevel> levels = aggr.getLevels();
            for (ROLAPMetaLevel lvl : levels) {
                if (lvl == null) continue;
                Element levelElement = levelsElement.addElement(QN_LEVEL);
                levelElement.addText(lvl.getName());
            }
            Element measuresElement = recommendedAggregateElement.addElement(QN_MEASURES);
            List<ROLAPMetaMeasure> measures = aggr.getMeasures();
            for (ROLAPMetaMeasure measure : measures) {
                if (measure == null) continue;
                Element measureElement = measuresElement.addElement(QN_MEASURE);
                measureElement.addText(measure.getName());
            }
        }
    }

    private static void addAggregateAdvisorCurrentWorkloadReplyElement(Element commandResponseElement, AdvisorCommandResult result) {
        Element aggregateAdvisorCurrentWorkloadReplyElement = commandResponseElement.addElement(QN_AGGREGATE_ADVISOR_CURRENT_WORKLOAD_REPLY);
        if (result instanceof AdvisorGetCurrentWorkloadResult) {
            ROLAPAdvisorCommandResponseUtility.addCurrentWorkload(aggregateAdvisorCurrentWorkloadReplyElement, (AdvisorGetCurrentWorkloadResult)result);
        }
    }

    private static void addCurrentWorkload(Element aggregateAdvisorCurrentWorkloadReplyElement, AdvisorGetCurrentWorkloadResult result) {
        List<String> users;
        List<String> reports;
        Element timeFrameElement = aggregateAdvisorCurrentWorkloadReplyElement.addElement(QN_TIME_FRAME);
        Element startTimeElement = timeFrameElement.addElement(QN_START_TIME);
        startTimeElement.setText(String.valueOf(result.getStartTime()));
        Element endTimeElement = timeFrameElement.addElement(QN_END_TIME);
        endTimeElement.setText(String.valueOf(result.getEndTime()));
        List<String> packages = result.getPackageNames();
        if (packages != null && !packages.isEmpty()) {
            Element namesElement = aggregateAdvisorCurrentWorkloadReplyElement.addElement(QN_PACKAGE_NAMES);
            for (String string : packages) {
                if (string == null) continue;
                Element nameElement = namesElement.addElement(QN_PACKAGE_NAME);
                nameElement.setText(string);
            }
        }
        if ((reports = result.getReportNames()) != null && !reports.isEmpty()) {
            Element namesElement = aggregateAdvisorCurrentWorkloadReplyElement.addElement(QN_REPORT_NAMES);
            for (String reportName : reports) {
                if (reportName == null) continue;
                Element nameElement = namesElement.addElement(QN_REPORT_NAME);
                nameElement.setText(reportName);
            }
        }
        if ((users = result.getUserNames()) != null && !users.isEmpty()) {
            Element element = aggregateAdvisorCurrentWorkloadReplyElement.addElement(QN_USER_NAMES);
            for (String userName : users) {
                if (userName == null) continue;
                Element nameElement = element.addElement(QN_USER_NAME);
                nameElement.setText(userName);
            }
        }
    }

    private static void addAggregateAdvisorRetrieveRecommendationsReplyElement(Element commandResponseElement, AdvisorCommandResult result) {
        Element aggregateAdvisorRetrieveRecommendationsReplyElement = commandResponseElement.addElement(QN_AGGREGATE_ADVISOR_RETRIEVE_RECOMMENDATIONS_REPLY);
        ROLAPAdvisorCommandResponseUtility.addStateElement(aggregateAdvisorRetrieveRecommendationsReplyElement, result.getState());
        if (result instanceof AdvisorRetrieveInitialRecommendationsResult) {
            ROLAPAdvisorCommandResponseUtility.addAdvisorRetrieveInitialRecommendationsResult(aggregateAdvisorRetrieveRecommendationsReplyElement, (AdvisorRetrieveInitialRecommendationsResult)result);
        } else if (result instanceof AdvisorRetrieveSubsequentRecommendationsResult) {
            ROLAPAdvisorCommandResponseUtility.addAdvisorRetrieveSubsequentRecommendationsResult(aggregateAdvisorRetrieveRecommendationsReplyElement, (AdvisorRetrieveSubsequentRecommendationsResult)result);
        } else {
            ROLAPAdvisorCommandResponseUtility.addMessagesElement(aggregateAdvisorRetrieveRecommendationsReplyElement, result.getMessages());
        }
    }

    private static void addAdvisorRetrieveInitialRecommendationsResult(Element aggregateAdvisorRetrieveRecommendationsReplyElement, AdvisorRetrieveInitialRecommendationsResult result) {
        int recommendationResultsSize = 0;
        List<AdvisorGetRecommendationResult> recommendationResults = result.getRecommendationResults();
        if (recommendationResults != null) {
            recommendationResultsSize = recommendationResults.size();
        }
        LOGGER.log(String.format("Started adding %,d recommendation results to the response", recommendationResultsSize));
        Element aggregateAdvisorRecommendationsRepliesElement = DocumentHelper.createElement((QName)QN_AGGREGATE_ADVISOR_RECOMMENDATIONS_REPLIES);
        if (recommendationResultsSize > 0) {
            for (AdvisorGetRecommendationResult recommendationResult : recommendationResults) {
                ROLAPAdvisorCommandResponseUtility.addAggregateAdvisorRecommendationsReplyElement(aggregateAdvisorRecommendationsRepliesElement, recommendationResult);
            }
        }
        ROLAPAdvisorCommandResponseUtility.addMessagesElement(aggregateAdvisorRetrieveRecommendationsReplyElement, result.getMessages());
        if (aggregateAdvisorRecommendationsRepliesElement.nodeCount() > 0) {
            aggregateAdvisorRetrieveRecommendationsReplyElement.add(aggregateAdvisorRecommendationsRepliesElement);
        }
        LOGGER.log(String.format("Finished adding %,d recommendation results to the response", recommendationResultsSize));
    }

    private static void addAdvisorRetrieveSubsequentRecommendationsResult(Element aggregateAdvisorRetrieveRecommendationsReplyElement, AdvisorRetrieveSubsequentRecommendationsResult result) {
        int recommendationFilesSize = 0;
        List<File> recommendationFiles = result.getRecommendationFilesToReturn();
        if (recommendationFiles != null) {
            recommendationFilesSize = recommendationFiles.size();
        }
        LOGGER.log(String.format("Started adding %,d recommendation files to the response", recommendationFilesSize));
        ArrayList<String> messages = new ArrayList<String>();
        Element aggregateAdvisorRecommendationsRepliesElement = DocumentHelper.createElement((QName)QN_AGGREGATE_ADVISOR_RECOMMENDATIONS_REPLIES);
        if (recommendationFilesSize > 0) {
            for (File recommendationFile : recommendationFiles) {
                ROLAPAdvisorCommandResponseUtility.addAggregateAdvisorRecommendationsReplyElement(aggregateAdvisorRecommendationsRepliesElement, recommendationFile, messages);
            }
        }
        messages.addAll(result.getMessages());
        ROLAPAdvisorCommandResponseUtility.addMessagesElement(aggregateAdvisorRetrieveRecommendationsReplyElement, messages);
        if (aggregateAdvisorRecommendationsRepliesElement.nodeCount() > 0) {
            aggregateAdvisorRetrieveRecommendationsReplyElement.add(aggregateAdvisorRecommendationsRepliesElement);
        }
        LOGGER.log(String.format("Finished adding %,d recommendation files to the response", recommendationFilesSize));
    }

    private static void addAggregateAdvisorRecommendationsReplyElement(Element parentElement, File recommendationFile, List<String> messages) {
        if (recommendationFile == null) {
            return;
        }
        String recommendationFileName = recommendationFile.getAbsolutePath();
        LOGGER.log(String.format("Adding recommendation file %s with size %,d bytes to the response", recommendationFileName, recommendationFile.length()));
        try {
            List<Element> aggregateAdvisorRecommendationsReplyChildElements = RecommendationFileUtility.getRecommendationFileElements(recommendationFile);
            if (aggregateAdvisorRecommendationsReplyChildElements != null && !aggregateAdvisorRecommendationsReplyChildElements.isEmpty()) {
                Element aggregateAdvisorRecommendationsReplyElement = DocumentHelper.createElement((QName)QN_AGGREGATE_ADVISOR_RECOMMENDATIONS_REPLY);
                for (Element aggregateAdvisorRecommendationsReplyChildElement : aggregateAdvisorRecommendationsReplyChildElements) {
                    aggregateAdvisorRecommendationsReplyElement.add(aggregateAdvisorRecommendationsReplyChildElement);
                }
                parentElement.add(aggregateAdvisorRecommendationsReplyElement);
                LOGGER.log(String.format("Added recommendation file %s to the response", recommendationFileName));
            } else {
                LOGGER.log(String.format("Did not add recommendation file %s to the response", recommendationFileName));
            }
        }
        catch (Exception ex) {
            LOGGER.log(LogLevel.ERROR, String.format("Could not add recommendation file %s to the response.", recommendationFileName), (Throwable)ex);
            XQERuntimeException xqeRuntimeException = new XQERuntimeException(XQEMessageKeys.ROL_RecommendationCouldNotBeRetrieved, (Throwable)ex, (Object)recommendationFileName, (Object)ex);
            messages.add(xqeRuntimeException.getLocalizedMessage());
        }
    }

    private static void addAggregateAdvisorStoreRecommendationReplyElement(Element commandResponseElement, AdvisorCommandResult result) {
        Element aggregateAdvisorStoreRecommendationReplyElement = commandResponseElement.addElement(QN_AGGREGATE_ADVISOR_STORE_RECOMMENDATION_REPLY);
        ROLAPAdvisorCommandResponseUtility.addStateElement(aggregateAdvisorStoreRecommendationReplyElement, result.getState());
        if (result instanceof AdvisorStoreRecommendationResult) {
            AdvisorStoreRecommendationResult storeRecommendationResult = (AdvisorStoreRecommendationResult)result;
            File recommendationFile = storeRecommendationResult.getRecommendationFile();
            ArrayList<String> messages = new ArrayList<String>(result.getMessages());
            Element tempParentElement = DocumentHelper.createElement((String)"tempParentElement");
            ROLAPAdvisorCommandResponseUtility.addAggregateAdvisorRecommendationsReplyElement(tempParentElement, recommendationFile, messages);
            ROLAPAdvisorCommandResponseUtility.addMessagesElement(aggregateAdvisorStoreRecommendationReplyElement, messages);
            if (tempParentElement.nodeCount() > 0) {
                aggregateAdvisorStoreRecommendationReplyElement.add(tempParentElement.node(0).detach());
            }
        } else {
            ROLAPAdvisorCommandResponseUtility.addMessagesElement(aggregateAdvisorStoreRecommendationReplyElement, result.getMessages());
        }
    }

    private static void addAggregateAdvisorReplyElement(Element commandResponseElement, AdvisorCommandResult result) {
        Element aggregateAdvisorReplyElement = commandResponseElement.addElement(QN_AGGREGATE_ADVISOR_REPLY);
        ROLAPAdvisorCommandResponseUtility.addStateElement(aggregateAdvisorReplyElement, result.getState());
        ROLAPAdvisorCommandResponseUtility.addMessagesElement(aggregateAdvisorReplyElement, result.getMessages());
    }
}

