/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler;

import com.cognos.xqe.bibushandler.IRequestMetricsListener;
import com.cognos.xqe.bibushandler.RequestMetrics;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.SingletonHelper;
import java.util.ArrayList;
import java.util.List;

public class RequestMetricsManager {
    private List<IRequestMetricsListener> listeners = new ArrayList<IRequestMetricsListener>();
    private static SingletonHelper<RequestMetricsManager> singletonHelper = new SingletonHelper<RequestMetricsManager>(){

        @Override
        protected RequestMetricsManager newInstance() {
            return new RequestMetricsManager();
        }

        @Override
        protected void initializeImpl(RequestMetricsManager theInstance) {
            theInstance.initialize();
        }

        @Override
        protected void releaseImpl(RequestMetricsManager theInstance) {
            theInstance.release();
        }
    };

    public static RequestMetricsManager getInstance() {
        return singletonHelper.getInstance();
    }

    private void initialize() {
        this.addListener(new XQELogWriter());
    }

    private void release() {
        this.listeners.clear();
    }

    public void addListener(IRequestMetricsListener l) {
        this.listeners.add(l);
    }

    public void removeListener(IRequestMetricsListener l) {
        this.listeners.remove(l);
    }

    public void requestFinished(RequestMetrics metrics) {
        if (metrics != null) {
            for (IRequestMetricsListener l : this.listeners) {
                l.requestFinished(metrics);
            }
        }
    }

    private class XQELogWriter
    implements IRequestMetricsListener {
        private XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Timing", LogLevel.INFO);

        XQELogWriter() {
        }

        @Override
        public void requestFinished(RequestMetrics metrics) {
            if (this.logger.isOn(LogLevel.INFO)) {
                this.logger.log(LogLevel.INFO, metrics.toString());
            }
        }
    }
}

