/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler.datasource;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSourceConnectionCommandBlock;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.Map;

public class DataSourceConnectionCommandBlock
implements IDataSourceConnectionCommandBlock {
    public static final String USERNAME = "userName";
    public static final String PASSWORD = "password";
    public static final String SQL_COMMAND = "sql";
    private static final int NUMBER_31 = 31;
    private IDataSourceConnectionCommandBlock.CommandBlockType commandBlockType;
    private final Map<String, Object> properties;
    private static final XQELogger TRACE_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "CommandBlockCache", LogLevel.INFO);

    public DataSourceConnectionCommandBlock(IDataSourceConnectionCommandBlock.CommandBlockType type, Map<String, Object> props) {
        this.commandBlockType = type;
        this.properties = props;
    }

    @Override
    public final IDataSourceConnectionCommandBlock.CommandBlockType getType() {
        return this.commandBlockType;
    }

    @Override
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public boolean compareTo(IDataSourceConnectionCommandBlock commandBlock) {
        TRACE_LOGGER.log(LogLevel.INFO, "Calling DataSourceConnectionCommandBlock.compareTo");
        if (commandBlock == null) {
            return false;
        }
        if (this.commandBlockType != commandBlock.getType()) {
            return false;
        }
        if (this.commandBlockType == IDataSourceConnectionCommandBlock.CommandBlockType.SESSION_START_COMMAND) {
            if (!this.getProperty(USERNAME).equals(commandBlock.getProperty(USERNAME))) {
                return false;
            }
            String pass1 = (String)this.getProperty(PASSWORD);
            String pass2 = (String)commandBlock.getProperty(PASSWORD);
            if (pass1 == null && pass2 == null) {
                TRACE_LOGGER.log(LogLevel.INFO, "pass1 and pass2 were both null");
                return true;
            }
            if (pass1 != null && pass2 != null) {
                TRACE_LOGGER.log(LogLevel.INFO, "pass1: " + pass1 + "pass2: " + pass2);
                return pass1.equals(pass2);
            }
        } else {
            if (this.commandBlockType == IDataSourceConnectionCommandBlock.CommandBlockType.SESSION_END_COMMAND) {
                TRACE_LOGGER.log(LogLevel.INFO, "CommandBlockType is SESSION_END_COMMAND");
                return true;
            }
            if (this.commandBlockType == IDataSourceConnectionCommandBlock.CommandBlockType.SQL_COMMAND) {
                TRACE_LOGGER.log(LogLevel.INFO, "LHS: " + this.getProperty(SQL_COMMAND));
                TRACE_LOGGER.log(LogLevel.INFO, "RHS: " + commandBlock.getProperty(SQL_COMMAND));
                if (this.getProperty(SQL_COMMAND).equals(commandBlock.getProperty(SQL_COMMAND))) {
                    return true;
                }
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = 31 + this.getType().hashCode();
        if (this.commandBlockType == IDataSourceConnectionCommandBlock.CommandBlockType.SESSION_START_COMMAND || this.commandBlockType == IDataSourceConnectionCommandBlock.CommandBlockType.SESSION_END_COMMAND) {
            if ((String)this.getProperty(USERNAME) != null) {
                hash = hash * 31 + ((String)this.getProperty(USERNAME)).hashCode();
            }
            if ((String)this.getProperty(PASSWORD) != null) {
                hash = hash * 31 + ((String)this.getProperty(PASSWORD)).hashCode();
            }
        } else if (this.commandBlockType == IDataSourceConnectionCommandBlock.CommandBlockType.SQL_COMMAND) {
            hash = hash * 31 + ((String)this.getProperty(SQL_COMMAND)).hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IDataSourceConnectionCommandBlock) {
            return this.compareTo((IDataSourceConnectionCommandBlock)obj);
        }
        return super.equals(obj);
    }
}

