/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler.datasource;

import com.cognos.xqe.bibushandler.content.ICryptoHandle;
import com.cognos.xqe.bibushandler.datasource.ApiTokenSignon;
import com.cognos.xqe.bibushandler.datasource.CamCryptoSignon;
import com.cognos.xqe.bibushandler.datasource.CombinedSignon;
import com.cognos.xqe.bibushandler.datasource.CubePasswordSignon;
import com.cognos.xqe.bibushandler.datasource.DataSourceConnection;
import com.cognos.xqe.bibushandler.datasource.DelegatedCredentialSignon;
import com.cognos.xqe.bibushandler.datasource.OIDCCredentialsSignon;
import com.cognos.xqe.bibushandler.datasource.TicketSignon;
import com.cognos.xqe.bibushandler.datasource.UserClassIDSignon;
import com.cognos.xqe.bibushandler.datasource.UsernamePasswordSignon;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.connection.ConnectionStringParser;
import com.cognos.xqe.security.IEncryptedObject;
import com.cognos.xqe.util.reference.IResourceHolder;
import com.cognos.xqebifw.bibushandler.datasource.JCAMImpersonator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public abstract class DataSourceConnectionSignon
implements IDataSourceConnectionSignon {
    private static final String NAME = "name";
    private static final String SEARCH_PATH = "searchPath";
    private static final String INTEGRATED_SECURITY = "integratedSecurity";
    public static final String[] CONN_STRIGN_PARAMETERS = new String[]{"integratedSecurity"};
    public static final Set<String> ALLOWED_CONN_STRIGN_PARAMETERS = new HashSet<String>(Arrays.asList(CONN_STRIGN_PARAMETERS));
    private String name;
    private String searchPath;
    private IDataSourceConnectionSignon.SignonType signonType;

    DataSourceConnectionSignon(IDataSourceConnectionSignon.SignonType theSignonType, String theName, String theSearchPath) {
        this.signonType = theSignonType;
        this.name = theName;
        this.searchPath = theSearchPath;
    }

    public static IDataSourceConnectionSignon createSignon(String providerType, String signonName, String searchPath, String username, IEncryptedObject<String> password, String ssoTicket, IEncryptedObject<String> cubePassword) {
        return DataSourceConnectionSignon.createSignon(providerType, signonName, searchPath, username, password, ssoTicket, null, cubePassword, null, null, null);
    }

    public static IDataSourceConnectionSignon createSignon(String providerType, String signonName, String searchPath, String username, IEncryptedObject<String> password, String ssoTicket, String cmUserName, IEncryptedObject<String> cubePassword, IResourceHolder<? extends ICryptoHandle> cryptoHandleRef, String connectionString, JCAMImpersonator.DelegatedCredential jaasSubject) {
        return DataSourceConnectionSignon.createSignon(providerType, signonName, searchPath, username, password, ssoTicket, cmUserName, cubePassword, null, cryptoHandleRef, connectionString, jaasSubject, null, null, null, null);
    }

    public static IDataSourceConnectionSignon createSignon(String providerType, String signonName, String searchPath, DataSourceConnection.Credentials credentials, String cmUserName, IResourceHolder<? extends ICryptoHandle> cryptoHandleRef, String connectionString, JCAMImpersonator.DelegatedCredential jaasSubject) {
        if (null == credentials) {
            return DataSourceConnectionSignon.createSignon(providerType, signonName, searchPath, null, null, null, cmUserName, null, null, cryptoHandleRef, connectionString, jaasSubject, null, null, null, null);
        }
        return DataSourceConnectionSignon.createSignon(providerType, signonName, searchPath, credentials.getUsername(), credentials.getPassword(), credentials.getSapTicket(), cmUserName, credentials.getCubePassword(), null, cryptoHandleRef, connectionString, jaasSubject, credentials.getIdToken(), credentials.getAccessToken(), null, null);
    }

    public static IDataSourceConnectionSignon createSignon(String providerType, String signonName, String searchPath, String username, IEncryptedObject<String> password, String ssoTicket, String cmUserName, IEncryptedObject<String> cubePassword, String userClassIds, IResourceHolder<? extends ICryptoHandle> cryptoHandleRef, String connectionString, JCAMImpersonator.DelegatedCredential credential, IEncryptedObject<String> oidcIdToken, IEncryptedObject<String> oidcAccessToken, IEncryptedObject<String> authKey, IEncryptedObject<String> secretKey) {
        DataSourceConnectionSignon signon = null;
        UserClassIDSignon userClassIdSignon = null;
        if (userClassIds != null && userClassIds.length() > 0) {
            userClassIdSignon = new UserClassIDSignon(userClassIds);
        }
        boolean integratedSecurity = false;
        if (connectionString != null) {
            Map<String, String> connectionParams = ConnectionStringParser.parse(connectionString, ALLOWED_CONN_STRIGN_PARAMETERS);
            integratedSecurity = Boolean.parseBoolean(connectionParams.get(INTEGRATED_SECURITY));
        }
        if (DataSourceTypeEnum.isPowerCube(providerType)) {
            boolean cubepswd = false;
            if (cubePassword != null && cubePassword.hasValue()) {
                cubepswd = true;
            }
            if (cubepswd && userClassIdSignon != null) {
                signon = new CombinedSignon(new CubePasswordSignon(signonName, searchPath, cubePassword), userClassIdSignon);
            } else if (cubepswd) {
                signon = new CubePasswordSignon(signonName, searchPath, cubePassword);
            } else if (userClassIdSignon != null) {
                signon = userClassIdSignon;
            }
        } else if (DataSourceTypeEnum.isTM1(providerType)) {
            if (cryptoHandleRef != null) {
                signon = new CamCryptoSignon(signonName, searchPath, cryptoHandleRef);
            } else if (username != null && username.length() > 0 && userClassIdSignon != null) {
                signon = new CombinedSignon(new UsernamePasswordSignon(signonName, searchPath, username, password), userClassIdSignon);
            } else if (username != null && username.length() > 0) {
                signon = new UsernamePasswordSignon(signonName, searchPath, username, password);
            } else if (userClassIdSignon != null) {
                signon = userClassIdSignon;
            }
        } else if (DataSourceTypeEnum.isTMR(providerType)) {
            if (cryptoHandleRef != null) {
                signon = new CamCryptoSignon(signonName, searchPath, cryptoHandleRef);
            } else if (username != null && username.length() > 0 && userClassIdSignon != null) {
                signon = new CombinedSignon(new UsernamePasswordSignon(signonName, searchPath, username, password), userClassIdSignon);
            } else if (username != null && username.length() > 0) {
                signon = new UsernamePasswordSignon(signonName, searchPath, username, password);
            } else if (userClassIdSignon != null) {
                signon = userClassIdSignon;
            } else if (oidcIdToken != null && oidcAccessToken != null) {
                signon = new OIDCCredentialsSignon(oidcIdToken, oidcAccessToken);
            }
        } else if (DataSourceTypeEnum.isSAPBW(providerType) && (credential != null || ssoTicket != null)) {
            if (ssoTicket != null) {
                signon = username == null && cmUserName != null && cmUserName.length() > 0 ? new CombinedSignon(new UsernamePasswordSignon(signonName, searchPath, cmUserName, password), new TicketSignon(signonName, searchPath, ssoTicket)) : new TicketSignon(signonName, searchPath, ssoTicket);
            } else if (credential != null) {
                signon = new DelegatedCredentialSignon(signonName, searchPath, credential);
            }
        } else if (DataSourceTypeEnum.isMicrosoft(providerType) && cryptoHandleRef != null) {
            signon = new CamCryptoSignon(signonName, searchPath, cryptoHandleRef);
        } else if (DataSourceTypeEnum.supportsJavaKerberos(providerType, connectionString) && (cryptoHandleRef != null || credential != null && connectionString != null && connectionString.contains("ibmcognos.authentication=java_krb5"))) {
            signon = credential != null && connectionString != null && connectionString.contains("ibmcognos.authentication=java_krb5") ? new DelegatedCredentialSignon(signonName, searchPath, credential) : new CamCryptoSignon(signonName, searchPath, cryptoHandleRef);
        } else if (DataSourceTypeEnum.isOIDCSupported(providerType) && oidcIdToken != null && oidcAccessToken != null) {
            signon = new OIDCCredentialsSignon(oidcIdToken, oidcAccessToken);
        } else if (authKey != null || secretKey != null) {
            signon = new ApiTokenSignon(authKey, secretKey);
        } else if (username != null && username.length() > 0) {
            signon = new UsernamePasswordSignon(signonName, searchPath, username, password);
        }
        return signon;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSearchPath() {
        return this.searchPath;
    }

    @Override
    public Element asXML() {
        Element signonElement = DocumentHelper.createElement((String)"signon");
        if (this.name != null) {
            Element nameElement = signonElement.addElement(NAME);
            nameElement.addAttribute("value", this.name);
        }
        if (this.searchPath != null) {
            Element searchPathElement = signonElement.addElement(SEARCH_PATH);
            searchPathElement.addAttribute("value", this.searchPath);
        }
        return signonElement;
    }

    @Override
    public final IDataSourceConnectionSignon.SignonType getType() {
        return this.signonType;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();
}

