/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler.recorder;

import com.cognos.xqe.bibushandler.recorder.Event;
import com.cognos.xqe.bibushandler.recorder.EventLog;
import com.cognos.xqe.bibushandler.recorder.Session;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public abstract class AbstractV5RequestPlayer {
    private Session mSession = null;
    private final Map<String, PlaybackThread> mRunners = new HashMap<String, PlaybackThread>();
    private final AtomicInteger mCountDown = new AtomicInteger(0);
    private volatile boolean mRunning = false;
    private volatile long mStartTime = 0L;

    public synchronized boolean isRunning() {
        return this.mRunning;
    }

    public synchronized void loadSession(File sessionFile) {
        XQERuntimeException exception;
        block10: {
            this.closeSession();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(sessionFile);
            }
            catch (IOException ex) {
                throw new XQERuntimeException(ex);
            }
            exception = null;
            try {
                XMLStreamReader xmlReader = StaxUtil.createXMLStreamReader(fis);
                if (!StaxUtil.moveToElement(xmlReader)) {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "No root element found.");
                }
                this.mSession = Session.deserialize(xmlReader);
                xmlReader.close();
            }
            catch (XMLStreamException ex) {
                exception = new XQERuntimeException(ex);
            }
            try {
                fis.close();
            }
            catch (IOException ex) {
                if (exception != null) break block10;
                exception = new XQERuntimeException(ex);
            }
        }
        if (exception != null) {
            throw exception;
        }
        EventLog eventLog = this.mSession.getEventLog();
        while (eventLog.hasNext()) {
            Event e = eventLog.next();
            PlaybackThread runner = this.mRunners.get(e.getRequestId());
            if (null == runner) {
                XQEDebugLog.out.println("Creating playback thread for requestId=" + e.getRequestId());
                runner = new PlaybackThread(e.getRequestId());
                this.mRunners.put(e.getRequestId(), runner);
            }
            runner.getEventSet().add(e);
        }
    }

    public synchronized void closeSession() {
        if (null == this.mSession) {
            return;
        }
        if (this.isRunning()) {
            this.stop();
        }
        this.mRunners.clear();
        this.mSession = null;
    }

    public synchronized void start() {
        if (null == this.mSession) {
            throw new IllegalStateException("Cannot start - session was not loaded.");
        }
        if (this.mRunning) {
            throw new IllegalStateException("Player was already running.");
        }
        this.mCountDown.set(this.mRunners.size());
        this.mStartTime = System.currentTimeMillis();
        this.mRunning = true;
        for (PlaybackThread runner : this.mRunners.values()) {
            runner.start();
        }
    }

    public synchronized void stop() {
        if (!this.mRunning) {
            return;
        }
        this.mRunning = false;
        for (PlaybackThread thread : this.mRunners.values()) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.mSession = null;
    }

    protected abstract void runEvent(Event var1);

    private long getElapsedPlaybackTime() {
        return System.currentTimeMillis() - this.mStartTime;
    }

    private static final class EventComparator
    implements Comparator<Event> {
        private EventComparator() {
        }

        @Override
        public int compare(Event o1, Event o2) {
            return o1.getStartTime().compareTo(o2.getStartTime());
        }
    }

    private final class PlaybackThread
    extends Thread {
        private final String mRequestId;
        private final Set<Event> mEventSet = new TreeSet<Event>(new EventComparator());

        private PlaybackThread(String requestId) {
            this.mRequestId = requestId;
        }

        public String getRequestId() {
            return this.mRequestId;
        }

        public Set<Event> getEventSet() {
            return this.mEventSet;
        }

        @Override
        public void run() {
            for (Event e : this.mEventSet) {
                long elapsedRecordedTime = e.getStartTime().getTime() - AbstractV5RequestPlayer.this.mSession.getStartDate().getTime();
                XQEDebugLog.out.println(e.getRequestId() + ": Elapsed recorded time is " + elapsedRecordedTime);
                while (true) {
                    if (!AbstractV5RequestPlayer.this.isRunning()) {
                        return;
                    }
                    long elapsedPlaybackTime = AbstractV5RequestPlayer.this.getElapsedPlaybackTime();
                    XQEDebugLog.out.println(e.getRequestId() + ": Elapsed playback time is " + elapsedPlaybackTime);
                    if (elapsedPlaybackTime >= elapsedRecordedTime) break;
                    try {
                        Thread.sleep(elapsedRecordedTime - elapsedPlaybackTime);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace(XQEDebugLog.err);
                    }
                }
                XQEDebugLog.out.println(e.getRequestId() + ": Playing event starting at time " + e.getStartTime().toString());
                try {
                    AbstractV5RequestPlayer.this.runEvent(e);
                }
                catch (Throwable ex) {
                    ex.printStackTrace(XQEDebugLog.err);
                }
            }
            if (AbstractV5RequestPlayer.this.mCountDown.decrementAndGet() == 0) {
                AbstractV5RequestPlayer.this.mRunning = false;
            }
        }
    }
}

