/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler.recorder;

import com.cognos.xqe.bibushandler.recorder.DatasetIdentifier;
import com.cognos.xqe.bibushandler.recorder.PartialDatasetIdentifier;
import com.cognos.xqe.bibushandler.recorder.Session;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.xml.stax.ChildElementIterator;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.io.File;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public final class Event
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String XML_ELEM_EVENT = "event";
    private static final String XML_ELEM_ATTACHMENT_DUMP = "attachmentDump";
    private static final String XML_ELEM_DATASETS_CREATED = "datasetsCreated";
    private static final String XML_ELEM_DATASETS_RELEASED = "datasetsReleased";
    private static final String XML_ELEM_DATASET = "dataset";
    private static final String XML_ELEM_PARTIAL_DATASET = "partialDataset";
    private static final String XML_ATTR_ELAPSED_TIME = "elapsedTime";
    private static final String XML_ATTR_END_TIME = "endTime";
    private static final String XML_ATTR_FAULT = "fault";
    private static final String XML_ELEM_REQUEST_DUMP = "requestDump";
    private static final String XML_ATTR_REQUEST_ID = "requestId";
    private static final String XML_ATTR_REQUEST_TYPE = "requestType";
    private static final String XML_ELEM_RESPONSE_DUMP = "responseDump";
    private static final String XML_ATTR_START_TIME = "startTime";
    private static final String XML_ATTR_THREAD_ID = "threadId";
    private long mThreadId;
    private Date mStartTime;
    private Date mEndTime;
    private String mRequestId;
    private String mRequestType;
    private File mRequestDump;
    private File mResponseDump;
    private final List<DatasetIdentifier> mDatasetsCreated = new LinkedList<DatasetIdentifier>();
    private final List<DatasetIdentifier> mDatasetsReleased = new LinkedList<DatasetIdentifier>();
    private final List<PartialDatasetIdentifier> mPartialDatasetsCreated = new LinkedList<PartialDatasetIdentifier>();
    private final List<PartialDatasetIdentifier> mPartialDatasetsReleased = new LinkedList<PartialDatasetIdentifier>();
    private final List<File> mAttachmentDumps = new LinkedList<File>();
    private boolean mFault;

    public long getThreadId() {
        return this.mThreadId;
    }

    public void setThreadId(long threadId) {
        this.mThreadId = threadId;
    }

    public Date getStartTime() {
        return this.mStartTime;
    }

    public void setStartTime(Date startTime) {
        this.mStartTime = startTime;
    }

    public Date getEndTime() {
        return this.mEndTime;
    }

    public void setEndTime(Date endTime) {
        this.mEndTime = endTime;
    }

    public long getElapsedTime() {
        return this.mEndTime.getTime() - this.mStartTime.getTime();
    }

    public String getRequestId() {
        return this.mRequestId;
    }

    public void setRequestId(String requestId) {
        this.mRequestId = requestId;
    }

    public String getRequestType() {
        return this.mRequestType;
    }

    public void setRequestType(String requestType) {
        this.mRequestType = requestType;
    }

    public File getRequestDump() {
        return this.mRequestDump;
    }

    public void setRequestDump(File requestDump) {
        this.mRequestDump = requestDump;
    }

    public File getResponseDump() {
        return this.mResponseDump;
    }

    public void setResponseDump(File responseDump) {
        this.mResponseDump = responseDump;
    }

    public List<File> getAttachmentDumps() {
        return this.mAttachmentDumps;
    }

    public boolean isFault() {
        return this.mFault;
    }

    public void setFault(boolean fault) {
        this.mFault = fault;
    }

    public List<DatasetIdentifier> getDatasetsCreated() {
        return this.mDatasetsCreated;
    }

    public List<DatasetIdentifier> getDatasetsReleased() {
        return this.mDatasetsReleased;
    }

    public List<PartialDatasetIdentifier> getPartialDatasetsCreated() {
        return this.mPartialDatasetsCreated;
    }

    public List<PartialDatasetIdentifier> getPartialDatasetsReleased() {
        return this.mPartialDatasetsReleased;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(XML_ELEM_EVENT);
        writer.writeAttribute(XML_ATTR_REQUEST_TYPE, this.getRequestType());
        writer.writeAttribute(XML_ATTR_REQUEST_ID, this.getRequestId());
        writer.writeAttribute(XML_ATTR_THREAD_ID, Long.toString(this.getThreadId()));
        writer.writeAttribute(XML_ATTR_START_TIME, Session.DATE_FORMATTER.format(this.getStartTime()));
        writer.writeAttribute(XML_ATTR_END_TIME, Session.DATE_FORMATTER.format(this.getEndTime()));
        writer.writeAttribute(XML_ATTR_ELAPSED_TIME, Long.toString(this.getElapsedTime()));
        writer.writeAttribute(XML_ATTR_FAULT, Boolean.toString(this.isFault()));
        writer.writeStartElement(XML_ELEM_REQUEST_DUMP);
        writer.writeCharacters(this.getRequestDump().getAbsolutePath());
        writer.writeEndElement();
        writer.writeStartElement(XML_ELEM_RESPONSE_DUMP);
        writer.writeCharacters(this.getResponseDump().getAbsolutePath());
        writer.writeEndElement();
        for (File attachment : this.mAttachmentDumps) {
            writer.writeStartElement(XML_ELEM_ATTACHMENT_DUMP);
            writer.writeCharacters(attachment.getAbsolutePath());
            writer.writeEndElement();
        }
        if (!this.mDatasetsReleased.isEmpty() || !this.mPartialDatasetsReleased.isEmpty()) {
            writer.writeStartElement(XML_ELEM_DATASETS_RELEASED);
            for (DatasetIdentifier ds : this.mDatasetsReleased) {
                ds.serialize(writer);
            }
            for (PartialDatasetIdentifier pds : this.mPartialDatasetsReleased) {
                pds.serialize(writer);
            }
            writer.writeEndElement();
        }
        if (!this.mDatasetsCreated.isEmpty() || !this.mPartialDatasetsCreated.isEmpty()) {
            writer.writeStartElement(XML_ELEM_DATASETS_CREATED);
            for (DatasetIdentifier ds : this.mDatasetsCreated) {
                ds.serialize(writer);
            }
            for (PartialDatasetIdentifier pds : this.mPartialDatasetsCreated) {
                pds.serialize(writer);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public static Event deserialize(XMLStreamReader reader) throws XMLStreamException {
        reader.require(1, null, XML_ELEM_EVENT);
        Event event = new Event();
        String tmp = null;
        try {
            tmp = reader.getAttributeValue(null, XML_ATTR_END_TIME);
            event.setEndTime(Session.DATE_FORMATTER.parse(tmp));
            tmp = reader.getAttributeValue(null, XML_ATTR_FAULT);
            event.setFault(Boolean.parseBoolean(tmp));
            tmp = reader.getAttributeValue(null, XML_ATTR_REQUEST_ID);
            event.setRequestId(tmp);
            tmp = reader.getAttributeValue(null, XML_ATTR_REQUEST_TYPE);
            event.setRequestType(tmp);
            tmp = reader.getAttributeValue(null, XML_ATTR_START_TIME);
            event.setStartTime(Session.DATE_FORMATTER.parse(tmp));
            tmp = reader.getAttributeValue(null, XML_ATTR_THREAD_ID);
            event.setThreadId(Long.parseLong(tmp));
            List<File> attatchmentDumps = event.getAttachmentDumps();
            ChildElementIterator childIter = new ChildElementIterator(reader);
            while (childIter.next()) {
                if (StaxUtil.testOnStartElement(reader, XML_ELEM_REQUEST_DUMP)) {
                    event.setRequestDump(new File(reader.getElementText()));
                    continue;
                }
                if (StaxUtil.testOnStartElement(reader, XML_ELEM_RESPONSE_DUMP)) {
                    event.setResponseDump(new File(reader.getElementText()));
                    continue;
                }
                if (StaxUtil.testOnStartElement(reader, XML_ELEM_ATTACHMENT_DUMP)) {
                    attatchmentDumps.add(new File(reader.getElementText()));
                    continue;
                }
                if (StaxUtil.testOnStartElement(reader, XML_ELEM_DATASETS_RELEASED)) {
                    Event.deserializeDatasetsReleased(reader, event);
                    continue;
                }
                if (StaxUtil.testOnStartElement(reader, XML_ELEM_DATASETS_CREATED)) {
                    Event.deserializeDatasetsCreated(reader, event);
                    continue;
                }
                throw new XQERuntimeException(XQEMessageKeys.XML_UnexpectedXMLElementWithLoc, (Object)reader.getLocalName(), (Object)reader.getLocation().getLineNumber(), (Object)reader.getLocation().getColumnNumber());
            }
        }
        catch (ParseException ex) {
            throw new XQERuntimeException(ex);
        }
        return event;
    }

    private static void deserializeDatasetsReleased(XMLStreamReader reader, Event event) throws XMLStreamException {
        reader.require(1, null, XML_ELEM_DATASETS_RELEASED);
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            if (StaxUtil.testOnStartElement(reader, XML_ELEM_DATASET)) {
                event.getDatasetsReleased().add(DatasetIdentifier.deserialize(reader));
                continue;
            }
            if (StaxUtil.testOnStartElement(reader, XML_ELEM_PARTIAL_DATASET)) {
                event.getPartialDatasetsReleased().add(PartialDatasetIdentifier.deserialize(reader));
                continue;
            }
            throw new XQERuntimeException(XQEMessageKeys.XML_UnexpectedXMLElementWithLoc, (Object)reader.getLocalName(), (Object)reader.getLocation().getLineNumber(), (Object)reader.getLocation().getColumnNumber());
        }
    }

    private static void deserializeDatasetsCreated(XMLStreamReader reader, Event event) throws XMLStreamException {
        reader.require(1, null, XML_ELEM_DATASETS_CREATED);
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            if (StaxUtil.testOnStartElement(reader, XML_ELEM_DATASET)) {
                event.getDatasetsCreated().add(DatasetIdentifier.deserialize(reader));
                continue;
            }
            if (StaxUtil.testOnStartElement(reader, XML_ELEM_PARTIAL_DATASET)) {
                event.getPartialDatasetsCreated().add(PartialDatasetIdentifier.deserialize(reader));
                continue;
            }
            throw new XQERuntimeException(XQEMessageKeys.XML_UnexpectedXMLElementWithLoc, (Object)reader.getLocalName(), (Object)reader.getLocation().getLineNumber(), (Object)reader.getLocation().getColumnNumber());
        }
    }
}

