/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler.recorder;

import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.xqe.bibushandler.ResponseAdapter;
import com.cognos.xqe.bibushandler.recorder.Event;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.io.ForwardingInputStream;
import com.cognos.xqe.util.resource.AutoReleaseInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class RecordingResponseAdapter
extends ResponseAdapter {
    private static final String DOT_XML = ".xml";
    private final ResponseAdapter mAdapter;
    private final Event mEvent;
    private final String mBaseFileName;
    private final List<InputStream> mWrappedAttachments = new ArrayList<InputStream>();
    private final List<AutoReleaseInputStream> mTrackedStreams = new ArrayList<AutoReleaseInputStream>();

    public RecordingResponseAdapter(ResponseAdapter adapter, Event event) {
        this.mAdapter = adapter;
        this.mEvent = event;
        String tmp = event.getResponseDump().getAbsolutePath();
        this.mBaseFileName = tmp.substring(0, tmp.length() - DOT_XML.length());
        this.wrapAttachmentsForRecording();
    }

    @Override
    public Iterator<? extends InputStream> getAttachmentIterator() {
        return this.mWrappedAttachments.iterator();
    }

    @Override
    public SOAPEnvelope getSOAPResponse() {
        return this.mAdapter.getSOAPResponse();
    }

    public void clean(MessageContext arg0) {
        this.mAdapter.clean(arg0);
        for (InputStream stream : this.mWrappedAttachments) {
            try {
                stream.close();
            }
            catch (IOException ex) {
                ex.printStackTrace(XQEDebugLog.err);
            }
        }
    }

    private void wrapAttachmentsForRecording() {
        Iterator<? extends InputStream> iter = this.mAdapter.getAttachmentIterator();
        int attachmentNo = 1;
        while (iter.hasNext()) {
            try {
                OutputStream dumpStream = this.createAttachmentDumpStream(attachmentNo++);
                ForwardingInputStream recordingStream = new ForwardingInputStream(iter.next(), dumpStream);
                this.mWrappedAttachments.add(recordingStream);
                this.mTrackedStreams.add(new AutoReleaseInputStream(recordingStream, this));
            }
            catch (IOException ex) {
                ex.printStackTrace(XQEDebugLog.err);
            }
        }
    }

    private OutputStream createAttachmentDumpStream(int attachmentNo) throws IOException {
        StringBuilder pathBuilder = new StringBuilder(this.mBaseFileName);
        pathBuilder.append("_attachment_").append(Integer.toString(attachmentNo)).append(DOT_XML);
        File dumpFile = new File(pathBuilder.toString());
        this.mEvent.getAttachmentDumps().add(dumpFile);
        return new FileOutputStream(dumpFile);
    }
}

