/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler.recorder;

import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.xqe.bibushandler.ResponseAdapter;
import com.cognos.xqe.bibushandler.recorder.DatasetIdentifier;
import com.cognos.xqe.bibushandler.recorder.Event;
import com.cognos.xqe.bibushandler.recorder.PartialDatasetIdentifier;
import com.cognos.xqe.bibushandler.recorder.RecordingResponseAdapter;
import com.cognos.xqe.bibushandler.recorder.Session;
import com.cognos.xqe.bibushandler.recorder.V5RequestRecorderMBean;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.management.XqeMBeanServer;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIPartialDataset;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Calendar;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanNotificationInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public final class V5RequestRecorder
extends NotificationBroadcasterSupport
implements V5RequestRecorderMBean {
    private static final String DOT_XML = ".xml";
    private static final String MBEAN_NAME = "com.cognos.xqe:type=V5RequestRecorder";
    private static final String BOOLEAN = "boolean";
    private static final String SESSION_STARTED = "SessionStarted";
    private static final String ERRMSG_NO_REQUEST_IN_PROGRESS = "No request was in progress.";
    private final AtomicLong mSessionCounter = new AtomicLong(0L);
    private final AtomicLong mNotificationSequenceNumber = new AtomicLong(0L);
    private final File mRootDirectory;
    private Session mCurrentSession = null;
    private File mCurrentSessionDirectory = null;
    private final ThreadLocal<Event> mCurrentEvent = new ThreadLocal();
    private final Calendar mCalendar = Calendar.getInstance();
    private ExecutorService mDumpService = null;

    public V5RequestRecorder() {
        XQEConfiguration xqeConfig = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        StringBuilder dirBuilder = new StringBuilder(xqeConfig.getXqeLogsDirectory());
        dirBuilder.append(File.separatorChar).append("requestDumps");
        this.mRootDirectory = new File(dirBuilder.toString());
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] types = new String[]{"jmx.attribute.change"};
        String name = AttributeChangeNotification.class.getName();
        String description = "The session state has changed";
        MBeanNotificationInfo info = new MBeanNotificationInfo(types, name, description);
        return new MBeanNotificationInfo[]{info};
    }

    public synchronized void initialize() {
        V5RequestRecorder.mkdirs(this.mRootDirectory);
        this.mDumpService = Executors.newCachedThreadPool();
        try {
            ObjectName name = new ObjectName(MBEAN_NAME);
            XqeMBeanServer.getInstance().registerMBean(this, name);
        }
        catch (Exception ex) {
            throw XQERuntimeException.wrap(ex);
        }
    }

    public synchronized void terminate() {
        try {
            XqeMBeanServer mbs = XqeMBeanServer.getInstance();
            ObjectName name = new ObjectName(MBEAN_NAME);
            mbs.unregisterMBean(name);
        }
        catch (Throwable ex) {
            ex.printStackTrace(XQEDebugLog.err);
        }
        if (this.isSessionStarted()) {
            this.endSession();
        }
        if (null != this.mDumpService) {
            this.mDumpService.shutdown();
        }
    }

    @Override
    public synchronized boolean isSessionStarted() {
        return null != this.mCurrentSession;
    }

    @Override
    public synchronized long getSessionId() {
        if (null == this.mCurrentSession) {
            return -1L;
        }
        return this.mSessionCounter.get();
    }

    @Override
    public synchronized void startSession() {
        if (null != this.mCurrentSession) {
            throw new IllegalStateException("A session was already in progress.");
        }
        long sessionId = this.mSessionCounter.incrementAndGet();
        XQELog.logConsole("Starting a V5 recording session with id=" + sessionId);
        this.mCurrentSession = new Session(sessionId);
        this.mCurrentSession.setStartDate(this.mCalendar.getTime());
        StringBuilder pathBuilder = new StringBuilder(this.mRootDirectory.getAbsolutePath());
        pathBuilder.append(File.separatorChar).append("session_").append(Long.toString(sessionId));
        this.mCurrentSessionDirectory = new File(pathBuilder.toString());
        V5RequestRecorder.mkdirs(this.mCurrentSessionDirectory);
        AttributeChangeNotification n = new AttributeChangeNotification(this, this.mNotificationSequenceNumber.incrementAndGet(), System.currentTimeMillis(), "A new session was started.", SESSION_STARTED, BOOLEAN, false, true);
        this.sendNotification(n);
    }

    @Override
    public synchronized void endSession() {
        if (null == this.mCurrentSession) {
            throw new IllegalStateException("No session was in progress.");
        }
        XQELog.logConsole("Ending the V5 recording session with id=" + this.getSessionId());
        try {
            this.mCalendar.setTimeInMillis(System.currentTimeMillis());
            this.mCurrentSession.setEndDate(this.mCalendar.getTime());
            this.saveSession();
        }
        finally {
            this.mCurrentSession = null;
            this.mCurrentSessionDirectory = null;
            AttributeChangeNotification n = new AttributeChangeNotification(this, this.mNotificationSequenceNumber.incrementAndGet(), System.currentTimeMillis(), "The current session was ended.", SESSION_STARTED, BOOLEAN, true, false);
            this.sendNotification(n);
        }
    }

    public synchronized void startRequest(String requestType, String requestId, SOAPEnvelope requestEnvelope) {
        if (null == this.mCurrentSession) {
            return;
        }
        if (this.mCurrentEvent.get() != null) {
            throw new IllegalStateException("A request was already in progress.");
        }
        long requestNum = this.mCurrentSession.incrementAndGetRequestCount();
        StringBuilder pathBuilder = new StringBuilder(this.mCurrentSessionDirectory.getAbsolutePath());
        pathBuilder.append(File.separatorChar).append(requestType).append(File.separatorChar).append("Request_").append(Long.toString(requestNum)).append(DOT_XML);
        File requestDumpFile = new File(pathBuilder.toString());
        V5RequestRecorder.mkdirs(requestDumpFile.getParentFile());
        pathBuilder.delete(0, pathBuilder.length()).append(this.mCurrentSessionDirectory.getAbsolutePath()).append(File.separatorChar).append(requestType).append(File.separatorChar).append("Response_").append(Long.toString(requestNum)).append(DOT_XML);
        File responseDumpFile = new File(pathBuilder.toString());
        Event event = new Event();
        event.setRequestType(requestType);
        event.setRequestDump(requestDumpFile);
        event.setResponseDump(responseDumpFile);
        event.setRequestId(requestId);
        event.setThreadId(Thread.currentThread().getId());
        this.mCalendar.setTimeInMillis(System.currentTimeMillis());
        event.setStartTime(this.mCalendar.getTime());
        this.startAsyncDump(requestDumpFile, requestEnvelope);
        this.mCurrentEvent.set(event);
    }

    public synchronized ResponseAdapter endRequest(ResponseAdapter responseAdapter, boolean isFault) {
        if (null == this.mCurrentSession) {
            this.mCurrentEvent.set(null);
            return responseAdapter;
        }
        Event event = this.mCurrentEvent.get();
        this.mCurrentEvent.set(null);
        if (event == null) {
            throw new IllegalStateException(ERRMSG_NO_REQUEST_IN_PROGRESS);
        }
        if (isFault) {
            event.setFault(true);
            this.mCurrentSession.incrementAndGetFaultCount();
        } else {
            event.setFault(false);
        }
        this.mCalendar.setTimeInMillis(System.currentTimeMillis());
        event.setEndTime(this.mCalendar.getTime());
        this.mCurrentSession.getEventLog().add(event);
        this.startAsyncDump(event.getResponseDump(), responseAdapter.getSOAPResponse());
        return new RecordingResponseAdapter(responseAdapter, event);
    }

    public synchronized void addDatasetCreated(RSAPIDataset dataset) {
        if (null == this.mCurrentSession) {
            this.mCurrentEvent.set(null);
            return;
        }
        Event event = this.mCurrentEvent.get();
        if (event == null) {
            throw new IllegalStateException(ERRMSG_NO_REQUEST_IN_PROGRESS);
        }
        DatasetIdentifier info = new DatasetIdentifier();
        info.setId(dataset.getUniqueID());
        info.setName(dataset.getName());
        info.setRefQuery(dataset.getRefQueryName());
        event.getDatasetsCreated().add(info);
    }

    public synchronized void addDatasetReleased(RSAPIDataset dataset) {
        if (null == this.mCurrentSession) {
            this.mCurrentEvent.set(null);
            return;
        }
        Event event = this.mCurrentEvent.get();
        if (event == null) {
            throw new IllegalStateException(ERRMSG_NO_REQUEST_IN_PROGRESS);
        }
        DatasetIdentifier info = new DatasetIdentifier();
        info.setId(dataset.getUniqueID());
        info.setName(dataset.getName());
        info.setRefQuery(dataset.getRefQueryName());
        event.getDatasetsReleased().add(info);
    }

    public synchronized void addPartialDatasetCreated(RSAPIPartialDataset partialDataset) {
        if (null == this.mCurrentSession) {
            this.mCurrentEvent.set(null);
            return;
        }
        Event event = this.mCurrentEvent.get();
        if (event == null) {
            throw new IllegalStateException(ERRMSG_NO_REQUEST_IN_PROGRESS);
        }
        PartialDatasetIdentifier info = new PartialDatasetIdentifier();
        info.setId(partialDataset.getUniqueID());
        info.setMasterId(partialDataset.getMasterDataset().getUniqueID());
        event.getPartialDatasetsCreated().add(info);
    }

    public synchronized void addPartialDatasetReleased(RSAPIPartialDataset partialDataset) {
        if (null == this.mCurrentSession) {
            this.mCurrentEvent.set(null);
            return;
        }
        Event event = this.mCurrentEvent.get();
        if (event == null) {
            throw new IllegalStateException(ERRMSG_NO_REQUEST_IN_PROGRESS);
        }
        PartialDatasetIdentifier info = new PartialDatasetIdentifier();
        info.setId(partialDataset.getUniqueID());
        info.setMasterId(partialDataset.getMasterDataset().getUniqueID());
        event.getPartialDatasetsReleased().add(info);
    }

    private void saveSession() {
        XQERuntimeException exception;
        block7: {
            StringBuilder pathBuilder = new StringBuilder(this.mCurrentSessionDirectory.getAbsolutePath());
            pathBuilder.append(File.separatorChar).append("session.xml");
            File sessionLogFile = new File(pathBuilder.toString());
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(sessionLogFile);
            }
            catch (IOException ex) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)ex);
            }
            XMLStreamWriter xmlWriter = null;
            exception = null;
            try {
                xmlWriter = StaxUtil.createXMLStreamWriter(fos);
                xmlWriter.writeStartDocument();
                this.mCurrentSession.serialize(xmlWriter);
                xmlWriter.writeEndDocument();
                xmlWriter.close();
            }
            catch (XMLStreamException ex) {
                exception = new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)ex);
            }
            try {
                fos.close();
            }
            catch (IOException ex) {
                if (exception != null) break block7;
                exception = new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)ex);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private void startAsyncDump(File dumpFile, SOAPEnvelope envelope) {
        if (null != envelope) {
            this.mDumpService.execute(new AsyncEnvelopeDump(dumpFile, envelope.toString()));
        }
    }

    private static void mkdirs(File directory) {
        if (!directory.exists() && !directory.mkdirs()) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Could not make directory: " + directory.getAbsolutePath());
        }
    }

    private static final class AsyncEnvelopeDump
    implements Runnable {
        private final File mDumpFile;
        private final String mEnvelope;

        private AsyncEnvelopeDump(File dumpFile, String envelope) {
            this.mDumpFile = dumpFile;
            this.mEnvelope = envelope;
        }

        @Override
        public void run() {
            BufferedOutputStream os = null;
            try {
                os = new BufferedOutputStream(new FileOutputStream(this.mDumpFile));
            }
            catch (IOException ex) {
                ex.printStackTrace(XQEDebugLog.err);
                return;
            }
            try {
                OutputStreamWriter writer = new OutputStreamWriter(os);
                writer.append(this.mEnvelope);
                writer.close();
            }
            catch (IOException ex) {
                ex.printStackTrace(XQEDebugLog.err);
            }
            finally {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException ex) {
                    ex.printStackTrace(XQEDebugLog.err);
                }
            }
        }
    }
}

