/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.cache.storage;

import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.cache.ICacheStorage;
import com.cognos.xqe.cache.ICacheableObject;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class ReferenceHashmapCacheStorage
implements ICacheStorage {
    int pinListSize;
    List<ICacheableObject> pinList = null;
    ReadWriteLock pinListLock = new ReentrantReadWriteLock();
    protected Map<ICacheKey, Reference<ICacheableObject>> storage;
    ReadWriteLock rwLock = new ReentrantReadWriteLock();
    ReferenceQueue<ICacheableObject> refQ = new ReferenceQueue();

    protected abstract void processRefQ();

    public ReferenceHashmapCacheStorage(int pinSize) {
        this.storage = new TreeMap<ICacheKey, Reference<ICacheableObject>>();
        this.pinList = new ArrayList<ICacheableObject>(pinSize);
        this.pinListSize = pinSize;
    }

    protected abstract Reference<ICacheableObject> createReference(ICacheKey var1, ICacheableObject var2);

    private void requeuePinList(ICacheableObject obj) {
        this.pinListLock.writeLock().lock();
        try {
            this.pinList.remove(obj);
            this.pinList.add(obj);
            if (this.pinList.size() > this.pinListSize) {
                this.pinList.remove(0);
            }
        }
        finally {
            this.pinListLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICacheableObject get(ICacheKey key) {
        Reference<ICacheableObject> ref;
        this.processRefQ();
        this.rwLock.readLock().lock();
        try {
            ref = this.storage.get(key);
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        if (ref != null) {
            ICacheableObject obj = ref.get();
            if (obj == null) {
                this.rwLock.writeLock().lock();
                try {
                    this.storage.remove(key);
                }
                finally {
                    this.rwLock.writeLock().unlock();
                }
            } else {
                this.requeuePinList(obj);
                return obj;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(ICacheKey key, ICacheableObject obj) {
        this.processRefQ();
        Reference<ICacheableObject> ref = this.createReference(key, obj);
        this.rwLock.writeLock().lock();
        try {
            this.storage.put(key, ref);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        this.requeuePinList(obj);
    }

    @Override
    public boolean contains(ICacheKey key) {
        this.rwLock.readLock().lock();
        try {
            boolean bl = this.storage.containsKey(key);
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public boolean localReferences() {
        return true;
    }

    @Override
    public ICacheableObject get(ICacheKey key, ICacheableObject shell) {
        return null;
    }

    @Override
    public void clear() {
        this.rwLock.writeLock().lock();
        try {
            this.storage.clear();
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        this.pinListLock.writeLock().lock();
        try {
            this.pinList.clear();
        }
        finally {
            this.pinListLock.writeLock().unlock();
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(ICacheKey key) throws CacheException {
        ICacheableObject obj = this.get(key);
        this.pinListLock.writeLock().lock();
        try {
            this.pinList.remove(obj);
        }
        finally {
            this.pinListLock.writeLock().unlock();
        }
        this.rwLock.writeLock().lock();
        try {
            this.storage.remove(key);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }
}

