/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.cache.storage;

import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.cache.ICacheableObject;
import com.cognos.xqe.cache.storage.ReferenceHashmapCacheStorage;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.List;

public class SoftReferenceHashmapCacheStorage
extends ReferenceHashmapCacheStorage {
    public SoftReferenceHashmapCacheStorage(int pinSize) {
        super(pinSize);
    }

    @Override
    protected Reference<ICacheableObject> createReference(ICacheKey key, ICacheableObject obj) {
        return new CacheReference(key, obj);
    }

    @Override
    protected void processRefQ() {
        this.rwLock.writeLock().lock();
        try {
            CacheReference ref;
            while ((ref = (CacheReference)this.refQ.poll()) != null) {
                this.storage.remove(ref.refKey);
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public int getFreeSize() {
        return 0;
    }

    @Override
    public void bulkPut(List<ICacheKey> keys, List<ICacheableObject> objs) throws CacheException {
        for (int i = 0; i < keys.size(); ++i) {
            this.put(keys.get(i), objs.get(i));
        }
    }

    protected class CacheReference
    extends SoftReference<ICacheableObject> {
        protected ICacheKey refKey;

        protected CacheReference(ICacheKey key, ICacheableObject obj) {
            super(obj, SoftReferenceHashmapCacheStorage.this.refQ);
            this.refKey = null;
            this.refKey = key;
        }
    }
}

