/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.cache.storage.primitive;

import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.cache.storage.primitive.CacheValueNotFound;
import com.cognos.xqe.cache.storage.primitive.IPrimitiveCacheStorage;
import com.cognos.xqe.exception.XQERuntimeException;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xindice.core.DBException;
import org.apache.xindice.core.data.Value;
import org.apache.xindice.core.filer.BTree;
import org.apache.xindice.core.filer.BTreeException;
import org.apache.xindice.core.filer.BTreeNotFoundException;
import org.apache.xindice.util.Configuration;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class BTreePrimitiveCacheStorage
implements IPrimitiveCacheStorage {
    BTree store;

    public BTreePrimitiveCacheStorage(String cacheDirName, String cacheName) {
        this(cacheDirName, cacheName, true);
    }

    public BTreePrimitiveCacheStorage(String cacheDirName, String cacheName, boolean replace) {
        File cacheDir = new File(cacheDirName);
        if (!cacheDir.exists()) {
            cacheDir.mkdir();
        }
        File storeFile = new File(cacheDir.getPath() + File.separator + cacheName + "BTreeCacheStorage");
        if (replace && storeFile.exists() && !storeFile.delete()) {
            throw new XQERuntimeException(new CacheException.FileRemovalFailure(storeFile.getAbsolutePath()));
        }
        this.store = new BTree(storeFile);
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            InputSource src = new InputSource(new StringReader("<xindice>    <root-collection dbroot='./db/' name='db'>        <queryengine>            <resolver autoindex='false' class='org.apache.xindice.core.query.XPathQueryResolver'/>            <resolver class='org.apache.xindice.core.xupdate.XUpdateQueryResolver'/>        </queryengine>    </root-collection>    <xml-rpc>        <driver name='xerces'/>    </xml-rpc></xindice>"));
            document = parser.parse(src);
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(e);
        }
        Configuration btreeConfig = new Configuration(document, false);
        this.store.setConfig(btreeConfig);
        try {
            if (!this.store.exists()) {
                this.store.create();
            }
            this.store.open();
        }
        catch (DBException e) {
            throw new XQERuntimeException(e);
        }
    }

    @Override
    public long get(ICacheKey key) throws CacheValueNotFound {
        try {
            return this.store.findValue(new Value(key.getBytes()));
        }
        catch (BTreeNotFoundException e) {
            throw new CacheValueNotFound();
        }
        catch (BTreeException e) {
            throw new XQERuntimeException(e);
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
    }

    @Override
    public void put(ICacheKey key, long value) {
        try {
            this.store.addValue(new Value(key.getBytes()), value);
        }
        catch (BTreeException e) {
            throw new XQERuntimeException(e);
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
    }

    @Override
    public void close() throws CacheException {
        try {
            this.store.close();
        }
        catch (DBException de) {
            throw new CacheException(de);
        }
    }
}

