/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.cache.storage.primitive;

import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.cache.storage.primitive.CacheValueNotFound;
import com.cognos.xqe.cache.storage.primitive.IPrimitiveCacheStorage;
import com.cognos.xqe.exception.RequestCanceledException;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class MapPrimitiveCacheStorage
implements IPrimitiveCacheStorage {
    private Map<ICacheKey, Long> storage = null;
    private ReadWriteLock rwLock = new ReentrantReadWriteLock();

    public MapPrimitiveCacheStorage(Map<ICacheKey, Long> map) {
        this.storage = map;
    }

    @Override
    public long get(ICacheKey key) throws CacheValueNotFound, CacheException {
        this.rwLock.readLock().lock();
        try {
            Long value = this.storage.get(key);
            if (value != null) {
                long l = value;
                return l;
            }
            throw new CacheValueNotFound();
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public void put(ICacheKey key, long value) throws CacheException {
        try {
            this.rwLock.writeLock().lockInterruptibly();
            this.storage.put(key, value);
        }
        catch (InterruptedException e) {
            throw new RequestCanceledException();
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public void close() {
    }
}

