/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.cache.transformer;

import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.cache.ICacheableObject;
import com.cognos.xqe.cache.transformer.StringToMetadataRecordListTransformer;
import com.cognos.xqe.metadata.record.MetadataRecord;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;

public class CacheableMetadataRecord
implements ICacheableObject {
    private static final long serialVersionUID = 6947151326693469867L;
    private MetadataRecord record = null;
    private ICacheKey recordKey = null;
    StringToMetadataRecordListTransformer transformer = new StringToMetadataRecordListTransformer();

    @Override
    public void readFromStream(ObjectInputStream in) throws IOException, ClassNotFoundException, CacheException {
        this.record = this.transformer.inflateMetadataRecordValue(in);
    }

    @Override
    public void writeToStream(ObjectOutputStream out) throws IOException, CacheException {
        this.transformer.serializeMetadataRecordValue(this.record, out);
    }

    public CacheableMetadataRecord(ICacheKey key, MetadataRecord rec) {
        this.recordKey = key;
        this.record = rec;
    }

    public CacheableMetadataRecord() {
    }

    @Override
    public ICacheableObject cloneObj() {
        return null;
    }

    @Override
    public ICacheKey getCacheKey() {
        return this.recordKey;
    }

    @Override
    public int getSize() throws CacheException {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(os);
            this.record.externalize(out);
            return os.size();
        }
        catch (IOException e) {
            throw new CacheException.ObjectSerializationException(e);
        }
    }

    @Override
    public void setKey(ICacheKey key) {
        this.recordKey = key;
    }

    public MetadataRecord getRecord() {
        return this.record;
    }

    @Override
    public void deflateObject(ByteBuffer bbf) throws CacheException {
    }

    @Override
    public void inflateObject(ByteBuffer bbf) throws CacheException {
    }
}

