/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.config;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.config.XQESubConfiguration;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.HashMap;
import java.util.Map;

public class ConfigSubtreeIndexer {
    private String base = null;
    private Map<String, String> keys = new HashMap<String, String>();

    public ConfigSubtreeIndexer(String key) {
        this.base = key;
    }

    public void addKey(String name, String key) {
        this.keys.put(name, key);
    }

    public int getSize() {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        XQESubConfiguration subConfiguration = configuration.getChildren(this.base);
        return subConfiguration.getSize();
    }

    public String getProperty(int index, String name) {
        XQESubConfiguration subConfiguration = this.findIndex(index);
        if (subConfiguration == null) {
            return null;
        }
        return subConfiguration.getString(this.keys.get(name), null);
    }

    public Integer getIntProperty(int index, String name) {
        return XQEIntegerPool.getInteger(Integer.parseInt(this.getProperty(index, name)));
    }

    public void setProperty(int index, String name, String value) {
        XQESubConfiguration subConfiguration = this.findIndex(index);
        if (subConfiguration == null) {
            return;
        }
        subConfiguration.setString(this.keys.get(name), value);
    }

    private String buildKey(int index) {
        return this.base + "(" + index + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addRow(Map<String, String> row) {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        try {
            configuration.lockWrite();
            int index = this.getSize();
            for (Map.Entry<String, String> pairs : row.entrySet()) {
                String key = this.buildKey(index) + this.keys.get(pairs.getKey());
                configuration.setProperty(key, pairs.getValue());
            }
            int n = index;
            return n;
        }
        finally {
            configuration.releaseWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addEmptyRow() {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        try {
            configuration.lockWrite();
            int index = this.getSize();
            for (String key : this.keys.values()) {
                String configKey = this.buildKey(index) + key;
                configuration.setProperty(configKey, "");
            }
            int n = index;
            return n;
        }
        finally {
            configuration.releaseWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRow(int index) {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        try {
            configuration.lockWrite();
            for (String key : this.keys.values()) {
                String configKey = this.buildKey(index) + key;
                String test = configuration.getStringProperty(configKey, null);
                if (test == null) continue;
                configuration.clearPropertyValue(configKey);
            }
        }
        finally {
            configuration.releaseWrite();
        }
    }

    private XQESubConfiguration findIndex(int index) {
        if (index < 0) {
            return null;
        }
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        XQESubConfiguration subConfiguration = configuration.getChildren(this.base);
        if (index >= subConfiguration.getSize()) {
            return null;
        }
        subConfiguration.index(index);
        return subConfiguration;
    }
}

