/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.config;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQECCLConfigurationFactory;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.cubingservices.CommonClassesFactory;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPConfiguration;
import com.cognos.xqe.util.ExceptionUtil;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class XQEConfigurationManager {
    private static XQEConfigurationManager instance;
    private Map<ServiceEnumeration, XQEConfiguration> configs;
    private Timer timer = null;
    private ReadWriteLock configLock = new ReentrantReadWriteLock();

    private XQEConfigurationManager() {
        this.configs = new TreeMap<ServiceEnumeration, XQEConfiguration>();
    }

    public static synchronized XQEConfigurationManager getInstance() {
        if (instance == null) {
            instance = new XQEConfigurationManager();
        }
        return instance;
    }

    public XQEConfiguration getOrCreateXQEConfiguration() {
        return this.getOrCreateXQEConfiguration(null);
    }

    public XQEConfiguration getOrCreateXQEConfiguration(Properties props) {
        XQEConfiguration config;
        block5: {
            config = null;
            try {
                config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
                if (config != null) break block5;
                ICCLConfiguration cclConfig = XQECCLConfigurationFactory.getInstance();
                try {
                    cclConfig.init();
                }
                catch (CCLConfigurationException e) {
                    throw new XQERuntimeException(e);
                }
                if (props == null || props.isEmpty()) {
                    props = CommonClassesFactory.createPropertiesFromCCLConfiguration(cclConfig, false);
                }
                config = CommonClassesFactory.createXQEConfiguration(ServiceEnumeration.XQE, props);
                XQEConfigurationManager.getInstance().add(ServiceEnumeration.XQE, config);
                config.loadParameterAccessCoordinator();
                ROLAPConfiguration.logAdvancedSettings(props);
            }
            catch (Throwable ex) {
                System.err.println("Error initializing XQE Configuration: " + ExceptionUtil.getStackTrace(ex));
                throw new XQERuntimeException(XQEMessageKeys.INI_ErrorDuringInitialization, ex, "XQEConfigurationManager");
            }
        }
        return config;
    }

    public XQEConfiguration getConfiguration(ServiceEnumeration serviceType) {
        this.configLock.readLock().lock();
        try {
            XQEConfiguration xQEConfiguration = this.configs.get((Object)serviceType);
            return xQEConfiguration;
        }
        finally {
            this.configLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ServiceEnumeration serviceType, XQEConfiguration newConfig) {
        this.configLock.writeLock().lock();
        try {
            XQEConfiguration oldConfig;
            if (newConfig == null) {
                newConfig = CommonClassesFactory.createXQEConfiguration(serviceType, new Properties());
            }
            if (null != this.timer) {
                newConfig.registerTimerTasks(this.timer);
            }
            if (null != (oldConfig = this.configs.put(serviceType, newConfig))) {
                oldConfig.unregisterTimerTasks();
            }
        }
        finally {
            this.configLock.writeLock().unlock();
        }
    }

    public void remove(ServiceEnumeration serviceType) {
        this.configLock.writeLock().lock();
        try {
            XQEConfiguration config = this.configs.remove((Object)serviceType);
            if (null != config) {
                config.unregisterTimerTasks();
            }
        }
        finally {
            this.configLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setTimer(Timer newTimer) {
        boolean result = false;
        this.configLock.writeLock().lock();
        try {
            if (null == this.timer && null != newTimer) {
                result = true;
                this.timer = newTimer;
                for (XQEConfiguration config : this.configs.values()) {
                    if (null == config) continue;
                    config.registerTimerTasks(newTimer);
                }
            }
        }
        finally {
            this.configLock.writeLock().unlock();
        }
        return result;
    }

    public boolean resetTimer() {
        return this.resetTimer(this.timer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resetTimer(Timer oldTimer) {
        boolean result = false;
        this.configLock.writeLock().lock();
        try {
            if (null != this.timer && this.timer == oldTimer) {
                result = true;
                this.timer = null;
                for (XQEConfiguration config : this.configs.values()) {
                    if (null == config) continue;
                    config.unregisterTimerTasks();
                }
            }
        }
        finally {
            this.configLock.writeLock().unlock();
        }
        return result;
    }
}

