/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.cubingservices.messaging;

import com.cognos.xqe.trace.XQEDebugLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.UTFDataFormatException;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public abstract class Message {
    public static final byte INVALID_ID = -128;
    public static final byte MSG_UNKNOWN = -11;
    public static final byte MSG_ERROR = -1;
    public static final byte MSG_SUCCESS = 0;
    public static final byte MSG_TYPE_REQUEST = 1;
    public static final byte MSG_TYPE_RESPONSE = 2;
    public static final byte MSG_CONNECT = 11;
    public static final byte MSG_CONNECT_ACK = 12;
    public static final byte MSG_DISCONNECT = 13;
    public static final byte MSG_GET_CUBES = 21;
    public static final byte MSG_CUBES = 22;
    public static final byte MSG_GET_CUBE_DATA = 25;
    public static final byte MSG_CUBE_METADATA = 26;
    public static final byte MSG_CUBE_METADATA_CLIENT = 27;
    public static final byte MSG_CUBE_STATUS = 28;
    public static final byte MSG_MEMBERSET = 29;
    public static final byte MSG_MEMBERSET_CLIENT = 30;
    public static final byte MSG_EXECUTE = 31;
    public static final byte MSG_RESULTSET = 32;
    public static final byte MSG_FETCH_AXES = 33;
    public static final byte MSG_FETCH_CELLDATA = 34;
    public static final byte MSG_DRILLTHROUGH_RESULTSET = 35;
    public static final byte MSG_ADMIN_SHUTDOWN_SERVER = 36;
    public static final byte MSG_ADMIN_REFRESH_LOGGER = 37;
    public static final byte MSG_ADMIN_CONSOLE_LOG = 38;
    public static final byte MSG_ADMIN_ROLL_LOG = 39;
    public static final byte MSG_ADMIN_TRACE_CMD = 40;
    public static final byte MSG_PING_SERVER = 41;
    public static final byte MSG_FUNCTIONS = 42;
    public static final byte MSG_ADMIN_REFRESH_SECURITY = 43;
    public static final byte MSG_ADMIN_START_XMLA_PROVIDER = 44;
    public static final byte MSG_ADMIN_STOP_XMLA_PROVIDER = 45;
    public static final byte MSG_XMLA_STATUS = 46;
    public static final byte MSG_ADMIN_SHOW = 47;
    public static final byte MSG_ADMIN_CANCEL = 48;
    public static final byte MSG_EXECUTE_COGNOS = 49;
    public static final byte MSG_CANCEL_COGNOS = 50;
    public static final byte MSG_ADMIN_STAT_JVM = 51;
    public static final byte MSG_EXECUTE_V5 = 52;
    public static final byte MSG_RESULTSET_V5 = 53;
    public static final byte MSG_ADMIN_UPDATE_SERVER_CONFIG = 54;
    public static final byte MSG_XMLA_MESSAGE = 55;
    public static final byte MSG_XMLA_RESPONSE_MESSAGE = 56;
    public static final byte MSG_READY_4_QUERY = 57;
    public static final byte INVALID_TYPE = -128;
    private byte msgID = (byte)-11;
    private byte msgType = (byte)2;
    protected static final int EXECUTE_MESSAGE_CHUNK_SIZE = 21000;
    DataInputStream dis;
    ByteArrayOutputStream data = new ByteArrayOutputStream();
    DataOutputStream dos = new DataOutputStream(this.data);
    public static final int SIGNATURE = 267312044;
    protected static final byte UNKNOWNTYPE = 0;
    protected static final byte BYTETYPE = 1;
    protected static final byte SHORTTYPE = 2;
    protected static final byte INTTYPE = 3;
    protected static final byte LONGTYPE = 4;
    protected static final byte BIGDECIMALTYPE = 5;
    protected static final byte FLOATTYPE = 6;
    protected static final byte DOUBLETYPE = 7;
    protected static final byte STRINGTYPE = 8;
    protected static final byte DATETYPE = 9;
    protected static final byte MISSINGVALUETYPE = 10;
    protected static final byte ERRORVALUETYPE = 11;
    protected static final byte TIMESTAMPTYPE = 12;
    protected static final byte TIMETYPE = 13;
    protected static final byte XQEERRORTYPE = 14;

    public Message(byte id) {
        this.msgID = id;
    }

    public Message(byte id, byte type) {
        this.msgID = id;
        this.msgType = type;
    }

    public Message() {
    }

    public void getData(byte[] dat) throws Exception {
        this.dis = new DataInputStream(new ByteArrayInputStream(dat));
        this.msgID = (byte)this.dis.read();
        this.msgType = this.readByte();
        if (this.readInt() != 267312044) {
            XQEDebugLog.err.println("Bad message received.");
        }
        this.unpack();
    }

    public boolean comGetData(DataInputStream d, byte id, byte type) {
        boolean success = true;
        this.dis = d;
        this.msgID = id;
        this.msgType = type;
        try {
            this.unpack();
        }
        catch (Exception e) {
            success = false;
        }
        return success;
    }

    public byte[] putData() throws Exception {
        this.data.reset();
        this.dos.write(this.msgID);
        this.dos.write(this.msgType);
        this.writeInt(267312044);
        this.pack();
        return this.data.toByteArray();
    }

    public abstract void unpack() throws Exception;

    public abstract void pack() throws Exception;

    public int getMessageID() {
        return this.msgID;
    }

    public byte getMsgID() {
        return this.msgID;
    }

    public byte getMsgType() {
        return this.msgType;
    }

    public void setMsgType(byte type) {
        this.msgType = type;
    }

    public void writeBytes(byte[] b) throws Exception {
        this.dos.writeInt(b.length);
        this.dos.write(b);
    }

    public byte[] readBytes() throws Exception {
        int len = this.dis.readInt();
        byte[] b = new byte[len];
        this.dis.read(b);
        return b;
    }

    public String readString() throws Exception {
        if (this.dis.readBoolean()) {
            return this.dis.readUTF();
        }
        return null;
    }

    public void writeString(String s) throws Exception {
        this.dos.writeBoolean(s != null);
        if (s != null) {
            try {
                this.dos.writeUTF(s);
            }
            catch (UTFDataFormatException udfe) {
                this.dos.writeUTF(s.substring(0, 21000));
            }
        }
    }

    public void writeInt(int i) throws Exception {
        this.dos.writeInt(i);
    }

    public int readInt() throws Exception {
        return this.dis.readInt();
    }

    public void writeDouble(double d) throws Exception {
        this.dos.writeDouble(d);
    }

    public double readDouble() throws Exception {
        return this.dis.readDouble();
    }

    public void writeByte(byte b) throws Exception {
        this.dos.writeByte(b);
    }

    public byte readByte() throws Exception {
        return this.dis.readByte();
    }

    public void writeShort(short s) throws Exception {
        this.dos.writeShort(s);
    }

    public short readShort() throws Exception {
        return this.dis.readShort();
    }

    public void writeLong(long l) throws Exception {
        this.dos.writeLong(l);
    }

    protected long readLong() throws Exception {
        return this.dis.readLong();
    }

    protected String[] readStringArray() throws Exception {
        int n = this.readInt();
        if (n < 1) {
            return null;
        }
        String[] sarr = new String[n];
        for (int i = 0; i < n; ++i) {
            sarr[i] = this.readString();
        }
        return sarr;
    }

    protected void writeStringArray(String[] sarr) throws Exception {
        this.writeInt(sarr.length);
        for (int i = 0; i < sarr.length; ++i) {
            this.writeString(sarr[i]);
        }
    }

    protected int[] readIntArray() throws Exception {
        int n = this.readInt();
        int[] iArr = new int[n];
        for (int i = 0; i < n; ++i) {
            iArr[i] = this.readInt();
        }
        return iArr;
    }

    protected void writeIntArray(int[] iArr) throws Exception {
        this.writeInt(iArr.length);
        for (int i = 0; i < iArr.length; ++i) {
            this.writeInt(iArr[i]);
        }
    }

    protected Date readDate() throws Exception {
        Date date = null;
        long time = this.readLong();
        if (time != 0L) {
            date = new Date();
            date.setTime(time);
        }
        return date;
    }

    protected void writeDate(Date date) throws Exception {
        if (date != null) {
            this.writeLong(date.getTime());
        } else {
            this.writeLong(0L);
        }
    }

    public String toString() {
        return "Message: the class " + this.getClass().getName() + " has not implemented toString()";
    }

    public boolean readBoolean() throws Exception {
        return this.dis.readBoolean();
    }

    public void writeBoolean(boolean b) throws Exception {
        this.dos.writeBoolean(b);
    }

    public Object readObject() throws Exception {
        switch (this.readByte()) {
            case 0: {
                return this.readBytes();
            }
            case 1: {
                return new Byte(this.readByte());
            }
            case 2: {
                return new Short(this.readShort());
            }
            case 3: {
                return new Integer(this.readInt());
            }
            case 4: {
                return new Long(this.readLong());
            }
            case 5: {
                return new BigDecimal(this.readString());
            }
            case 6: {
                return new Float(this.readDouble());
            }
            case 7: {
                return new Double(this.readDouble());
            }
            case 8: {
                return this.readString();
            }
            case 9: {
                return this.readDate();
            }
            case 13: {
                return new Time(this.readLong());
            }
            case 12: {
                return new Timestamp(this.readLong());
            }
            case 10: {
                return null;
            }
            case 11: {
                return new ErrValue(this.readString());
            }
        }
        return this.readString();
    }

    public void writeObject(Object o) throws Exception {
        if (o == null) {
            this.writeByte((byte)10);
        } else if (o instanceof ErrValue) {
            this.writeByte((byte)11);
            this.writeString(((ErrValue)o).getErrorMsg());
        } else if (o instanceof Byte) {
            this.writeByte((byte)1);
            this.writeByte((Byte)o);
        } else if (o instanceof Short) {
            this.writeByte((byte)2);
            this.writeShort((Short)o);
        } else if (o instanceof BigDecimal) {
            this.writeByte((byte)5);
            this.writeString(o.toString());
        } else if (o instanceof Float) {
            this.writeByte((byte)6);
            this.writeDouble(((Float)o).doubleValue());
        } else if (o instanceof Integer) {
            this.writeByte((byte)3);
            this.writeInt((Integer)o);
        } else if (o instanceof Long) {
            this.writeByte((byte)4);
            this.writeLong((Long)o);
        } else if (o instanceof Double) {
            this.writeByte((byte)7);
            this.writeDouble((Double)o);
        } else if (o instanceof String) {
            this.writeByte((byte)8);
            this.writeString((String)o);
        } else if (o instanceof Time) {
            this.writeByte((byte)13);
            this.writeLong(((Time)o).getTime());
        } else if (o instanceof Timestamp) {
            this.writeByte((byte)12);
            this.writeLong(((Timestamp)o).getTime());
        } else if (o instanceof Date) {
            this.writeByte((byte)9);
            this.writeDate((Date)o);
        } else {
            this.writeByte((byte)0);
            this.writeBytes((byte[])o);
        }
    }

    public class ErrValue {
        public static final String ERROR_VALUE = "#ERR";
        private String mErrorMsg;

        public ErrValue(String info) {
            this.mErrorMsg = info;
        }

        public String getErrorMsg() {
            return this.mErrorMsg;
        }

        public String toString() {
            return ERROR_VALUE;
        }
    }
}

