/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.collators;

import com.cognos.xqe.data.collators.CollatorPoolFactory;
import com.cognos.xqe.data.collators.WrapperCollator;
import com.cognos.xqe.exception.XQERuntimeException;
import com.ibm.icu.text.Collator;
import java.util.Locale;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;

public final class CollatorPool
extends GenericKeyedObjectPool {
    private static final CollatorPool INSTANCE = new CollatorPool(new CollatorPoolFactory(), -1);
    private static final Locale DEFAULTLOCALE = Locale.getDefault();
    CollatorPoolFactory collatorFactory = null;

    private CollatorPool(CollatorPoolFactory poolFactory, int maxActive) {
        super((KeyedPoolableObjectFactory)poolFactory, maxActive);
        this.collatorFactory = poolFactory;
    }

    public static Collator borrowCollatorImpl(Object key) throws Exception {
        return (Collator)INSTANCE.borrowObject(key);
    }

    public static Collator borrowCollator(Object key) throws Exception {
        return new WrapperCollator(CollatorPool.INSTANCE.collatorFactory, key);
    }

    public static void returnCollator(Object key, Collator collator) {
        try {
            Collator collatorImpl = ((WrapperCollator)collator).getCollatorImpl();
            if (collatorImpl != null) {
                INSTANCE.returnObject(key, collatorImpl);
            }
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(e);
        }
    }

    public static void returnCollatorImpl(Object key, Collator collatorImpl) {
        try {
            if (collatorImpl != null) {
                INSTANCE.returnObject(key, collatorImpl);
            }
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(e);
        }
    }

    public static void returnDefaultCollator(Collator collator) {
        CollatorPool.returnCollator(DEFAULTLOCALE, collator);
    }
}

