/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.collators;

import com.cognos.i18n.ToolkitResources;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.collators.ICustomCollatorFactory;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.util.LocaleConverter;
import com.ibm.icu.text.Collator;
import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;

public class CollatorPoolFactory
extends BaseKeyedPoolableObjectFactory {
    private static String[] customCollatorNames = new String[]{"CtCp1252", "CtCp850", "CtCp850Dictionary", "CtIso1", "CtIso1Dictionary", "CtRoman8", "CtRoman8Dictionary", "IbmDb2MvsE37Identity", "IbmDb2Udb1252Identity", "IbmDb2Udb1252Unique", "IfCp1252", "IfCp1252DeEnEsFrItNl", "IfCp1252FiSv", "IfCp819", "IfCp819DeEnEsFrItNl", "IfCp819FiSv", "IfCp850", "IfCp850DeEnEsFrItNl", "IfCp850FiSv", "MsSqlLatin1GeneralCp1", "OrWe8iso8859p1", "OrWe8mswin1252", "RbCp1252", "RbCp1252Default", "RbLatin1", "RbLatin1Default", "Sybaseasiq1252latin1", "SybaseasiqIso1", "TdAsciiCi", "TdAscii", "TdEbcdicCi", "TdEbcdic", "UnicodeCodepoint"};

    public CollatorPoolFactory() {
        Arrays.sort(customCollatorNames);
    }

    public static String getCollationLevel(String level) {
        String collationSequenceWeight = null;
        CollatorWeight[] collatorWeights = CollatorWeight.values();
        for (int i = 0; i < collatorWeights.length; ++i) {
            if (!collatorWeights[i].name.equals(level)) continue;
            collationSequenceWeight = collatorWeights[i].abbreviation;
            break;
        }
        return collationSequenceWeight;
    }

    public Object makeObject(Object key) throws Exception {
        Collator collator = null;
        if (key instanceof Locale) {
            collator = this.makeCollatorFromLocale((Locale)key);
        }
        if (key instanceof String) {
            collator = this.makeCollatorFromString((String)key);
        }
        if (collator != null) {
            collator.freeze();
        }
        return collator;
    }

    private Collator makeCollatorFromLocale(Locale key) {
        Locale icuLocale = ToolkitResources.getDefaultLocaleForCurrentLocale((Locale)key);
        if (!this.isValidLocale(icuLocale)) {
            XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Resources", LogLevel.WARN).log(LogLevel.WARN, String.format("Locale %s is not valid. Falling back to ICU default collator.", key.toString()));
        }
        return Collator.getInstance((Locale)icuLocale);
    }

    private boolean isValidLocale(Locale locale) {
        try {
            return locale.getISO3Country() != null && locale.getISO3Language() != null;
        }
        catch (MissingResourceException e) {
            return false;
        }
    }

    private Collator makeCollatorFromString(String name) throws XQERuntimeException {
        String[] parts = name.split("\\:");
        String localeName = parts[0];
        int strengthLevel = -1;
        if (parts.length > 1) {
            CollatorWeight[] weights = CollatorWeight.values();
            for (int i = 0; i < weights.length; ++i) {
                if (!weights[i].abbreviation.equalsIgnoreCase(parts[1])) continue;
                strengthLevel = weights[i].weight;
                break;
            }
            if (strengthLevel == -1) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_CollatorStrength, parts[1], name);
            }
        }
        Collator collator = null;
        if (Arrays.binarySearch(customCollatorNames, localeName) >= 0) {
            collator = this.makeCustomCollator(localeName);
        } else {
            Locale locale = LocaleConverter.strToLocale(localeName);
            collator = this.makeCollatorFromLocale(locale);
        }
        if (strengthLevel != -1) {
            collator.setStrength(strengthLevel);
        }
        return collator;
    }

    private Collator makeCustomCollator(String name) throws XQERuntimeException {
        Collator collator;
        try {
            ICustomCollatorFactory factory = (ICustomCollatorFactory)Class.forName(this.makeClassName(name)).newInstance();
            collator = (Collator)factory.newCollator();
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_LocaleCollatorCreation, name);
        }
        return collator;
    }

    private String makeClassName(String name) {
        return String.format("com.cognos.xqe.data.collators.%1$sCollatorFactory", name);
    }

    public static enum CollatorWeight {
        PRIMARY("PRIMARY", "P", 0),
        SECONDARY("SECONDARY", "S", 1),
        TERTIARY("TERTIARY", "T", 2),
        QUATERNARY("QUATERNARY", "Q", 3),
        IDENTICAL("IDENTICAL", "I", 15),
        CANONICAL_DECOMPOSITION("CANONICAL_DECOMPOSITION", "CD", 17),
        FULL_DECOMPOSITION("FULL_DECOMPOSITION", "FD", 15),
        NO_DECOMPOSITION("NO_DECOMPOSITION", "ND", 16);

        String name;
        String abbreviation;
        int weight;

        private CollatorWeight(String aName, String anAbbreviation, int aWeight) {
            this.name = aName;
            this.abbreviation = anAbbreviation;
            this.weight = aWeight;
        }

        public String getName() {
            return this.name;
        }

        public String getAbbreviation() {
            return this.abbreviation;
        }

        public int getWeight() {
            return this.weight;
        }
    }
}

