/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.json;

import com.cognos.xqe.authentication.AuthenticationHelper;
import com.cognos.xqe.data.json.JSONReader;
import com.cognos.xqe.data.json.StreamingJSONReader;
import com.cognos.xqe.data.providers.relational.AbstractConnection;
import java.io.IOException;
import java.net.URLConnection;
import java.util.Map;

public class CloudantReader
implements JSONReader {
    private static final String _ALL_DOCS = "_all_docs";
    private static final String _DESIGN = "_design";
    private static final String _FIND = "_find";
    private static final String _VIEW = "_view";
    private static final String _SEARCH = "_search";
    private static final String DOCS = "$.docs";
    private static final String ROWS = "$.rows";
    private JSONReader reader;

    CloudantReader(URLConnection connection, String pathExpr) throws IOException {
        this.initialize(connection, connection.getURL().getPath(), pathExpr);
    }

    CloudantReader(AbstractConnection connection, Map<String, Object> properties, String pathExpr) throws IOException {
        this(AuthenticationHelper.createURLConnection(connection, properties), pathExpr);
    }

    private void initialize(URLConnection connection, String url, String pathExpr) throws IOException {
        String dataPathExpr = "$";
        if (url.endsWith(_FIND)) {
            dataPathExpr = DOCS;
        } else if (url.contains(_ALL_DOCS)) {
            dataPathExpr = ROWS;
        } else if (url.contains(_DESIGN)) {
            if (url.contains(_VIEW) || url.contains(_SEARCH)) {
                dataPathExpr = ROWS;
            }
        } else {
            dataPathExpr = pathExpr;
            pathExpr = null;
        }
        this.reader = new StreamingJSONReader(connection, dataPathExpr, pathExpr);
    }

    @Override
    public boolean hasNext() {
        return this.reader.hasNext();
    }

    @Override
    public Object next() {
        return this.reader.next();
    }

    @Override
    public void remove() {
    }

    @Override
    public void release() {
        this.reader.release();
    }
}

