/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.json;

import com.cognos.xqe.data.json.JSONReader;
import com.cognos.xqe.data.json.JSONUtil;
import com.cognos.xqe.data.json.PagingReader;
import com.cognos.xqe.data.providers.relational.AbstractConnection;
import com.cognos.xqe.exception.XQERuntimeException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import net.minidev.json.JSONObject;

public class TwitterReader
implements JSONReader {
    private static final String[] TWITTER_TIMELINES = new String[]{"/1.1/users/search.json", "/1.1/statuses/home_timeline.json", "/1.1/statuses/user_timeline.json", "/1.1/statuses/mentions_timeline.json", "/1.1/statuses/retweets_of_me.json"};
    private static final String[] TWITTER_CURSORED_COLLECTIONS = new String[]{"/1.1/friends/list.json", "/1.1/followers/list.json"};
    private PagingReader reader;

    TwitterReader(AbstractConnection connection, Map<String, Object> properties, String pathExpr) throws IOException {
        String connectionURL = (String)properties.get("URL");
        String path = new URL(connectionURL).getPath();
        this.reader = TwitterReader.contains(TWITTER_TIMELINES, path) ? new TimelineReader(connection, properties, pathExpr) : (TwitterReader.contains(TWITTER_CURSORED_COLLECTIONS, path) ? new CollectionReader(connection, properties, pathExpr) : new BasicReader(connection, properties, pathExpr));
    }

    @Override
    public boolean hasNext() {
        return this.reader.hasNext();
    }

    @Override
    public JSONObject next() {
        return this.reader.next();
    }

    @Override
    public void release() {
        this.reader.release();
    }

    private static boolean contains(String[] array, String value) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void remove() {
    }

    private class TimelineReader
    extends BasicReader {
        protected int nRows;
        private long minId;

        TimelineReader(AbstractConnection connection, Map<String, Object> properties, String pathExpr) {
            super(connection, properties, pathExpr);
            this.nRows = 0;
        }

        @Override
        public JSONObject next() {
            long id = (Long)this.jsonObj.get((Object)"id");
            this.minId = this.nRows++ == 0 ? id : Math.min(this.minId, id);
            return super.next();
        }

        @Override
        protected String getNextPageURL() {
            this.nRows = 0;
            return String.format("%s&max_id=%d", this.originalURL, this.minId - 1L);
        }
    }

    private class CollectionReader
    extends PagingReader {
        private static final String NEXT_CURSOR_STR = "next_cursor_str";
        private static final String USERS = "users";

        CollectionReader(AbstractConnection connection, Map<String, Object> properties, String pathExpr) {
            super(connection, properties, pathExpr);
        }

        @Override
        protected String getNextPageURL() {
            String nextPageURL = null;
            try {
                JsonToken token;
                do {
                    String name;
                    if ((token = this.parser.nextToken()) != JsonToken.FIELD_NAME || !(name = this.parser.getCurrentName()).equals(NEXT_CURSOR_STR)) continue;
                    this.parser.nextToken();
                    nextPageURL = String.format("%s&cursor=%s", this.originalURL, JSONUtil.parseValue(this.parser));
                    break;
                } while (token != null);
            }
            catch (IOException e) {
                throw new XQERuntimeException(e);
            }
            return nextPageURL;
        }

        @Override
        protected boolean eod(String nextPageURL) {
            return nextPageURL == null || nextPageURL.equals("0");
        }

        @Override
        protected void getContentImpl() throws IOException {
            JsonToken token;
            do {
                String name;
                if ((token = this.parser.nextToken()) != JsonToken.FIELD_NAME || !(name = this.parser.getCurrentName()).equals(USERS)) continue;
                this.parser.nextToken();
                this.parser.nextToken();
                break;
            } while (token != null);
        }
    }

    private class BasicReader
    extends PagingReader {
        BasicReader(AbstractConnection connection, Map<String, Object> properties, String pathExpr) {
            super(connection, properties, pathExpr);
        }

        @Override
        protected void getContentImpl() throws IOException {
            if (this.parser.nextToken() == JsonToken.START_ARRAY) {
                this.parser.nextToken();
            }
        }
    }
}

