/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.model;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Fault;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMAttribute;
import org.dom4j.dom.DOMElement;

public abstract class DataSourceException
extends XQERuntimeException {
    private static final long serialVersionUID = 1L;
    private IDataSource dataSource;

    public DataSourceException() {
        super(XQEMessageKeys.DS_DataSourceConnectionFailure);
        this.dataSource = null;
    }

    public DataSourceException(IMessageKey.Param0 exceptionCode) {
        super(exceptionCode);
        this.dataSource = null;
    }

    public DataSourceException(IMessageKey.Param0 exceptionCode, Throwable cause) {
        super(exceptionCode, cause);
        this.dataSource = null;
    }

    public DataSourceException(IDataSource theDataSource) {
        super(XQEMessageKeys.DS_DataSourceConnectionFailure);
        this.dataSource = theDataSource;
    }

    public DataSourceException(IDataSource theDataSource, IMessageKey.Param0 exceptionCode) {
        super(exceptionCode);
        this.dataSource = theDataSource;
    }

    public DataSourceException(IDataSource theDataSource, IMessageKey.Param0 exceptionCode, Throwable cause) {
        super(exceptionCode, cause);
        this.dataSource = theDataSource;
    }

    public DataSourceException(IDataSource theDataSource, IMessageKey.Param1 exceptionCode, String arg) {
        super(exceptionCode, arg);
        this.dataSource = theDataSource;
    }

    public DataSourceException(IDataSource theDataSource, IMessageKey.Param1 exceptionCode, Throwable cause, String arg) {
        super(exceptionCode, cause, arg);
        this.dataSource = theDataSource;
    }

    protected Element getFaultDataSource() {
        if (this.dataSource != null) {
            DOMElement faultDataSource = new DOMElement(new QName("faultDataSource"));
            DOMAttribute value = new DOMAttribute(new QName("value"), this.dataSource.getCMDataSourceName());
            faultDataSource.add((Attribute)value);
            return faultDataSource;
        }
        return null;
    }

    protected Element getFaultConnection() {
        IDataSourceConnection conn;
        IDataSourceConnection connection = null;
        try {
            if (this.dataSource != null) {
                connection = this.dataSource.getDataSourceConnection();
            }
        }
        catch (DataSourceException e) {
            return null;
        }
        if (connection != null && (conn = this.dataSource.getDataSourceConnection()).getConnectionString(null) != null) {
            String connectionString;
            String searchPath;
            DOMElement faultConnection = new DOMElement(new QName("faultConnection"));
            String connectionName = conn.getName();
            if (connectionName != null) {
                DOMElement connNameElement = new DOMElement(new QName("name"));
                DOMAttribute value = new DOMAttribute(new QName("value"), connectionName);
                connNameElement.add((Attribute)value);
                faultConnection.add((Element)connNameElement);
            }
            if ((searchPath = conn.getSearchPath()) != null) {
                DOMElement searchPathElement = new DOMElement(new QName("searchPath"));
                DOMAttribute value = new DOMAttribute(new QName("value"), searchPath);
                searchPathElement.add((Attribute)value);
                faultConnection.add((Element)searchPathElement);
            }
            if ((connectionString = conn.getConnectionString(null)) != null) {
                DOMElement connStringElement = new DOMElement(new QName("connectionString"));
                DOMAttribute value = new DOMAttribute(new QName("value"), connectionString);
                connStringElement.add((Attribute)value);
                faultConnection.add((Element)connStringElement);
            }
            return faultConnection;
        }
        return null;
    }

    protected Element getFaultSignon() {
        IDataSourceConnectionSignon signon;
        block5: {
            signon = null;
            try {
                IDataSourceConnection connection;
                if (this.dataSource == null || (connection = this.dataSource.getDataSourceConnection()) == null) break block5;
                try {
                    signon = connection.getSignon();
                    connection.invalidateResolvedSignon();
                }
                catch (XQERuntimeException e) {
                    if (!this.dataSource.getType().equals("XML") || e.getMessageKey() != XQEMessageKeys.DS_UnableToRetrieveDataSourceSignons) {
                        throw e;
                    }
                }
            }
            catch (DataSourceException e) {
                return null;
            }
        }
        return DataSourceException.getFaultSignonElem(signon);
    }

    private void addMessage(Element exception, String msg) {
        DOMElement message = new DOMElement(BIBusEnvelope.BUS_MESSAGE);
        exception.add((Element)message);
        DOMElement messageString = new DOMElement(new QName("messageString"));
        messageString.addText(msg);
        message.add((Element)messageString);
    }

    protected Element getFaultDetail() {
        DOMElement exception = new DOMElement(BIBusEnvelope.BUS_EXCEPTION);
        this.addMessage((Element)exception, this.getFaultString());
        for (Throwable cause = this.getCause(); cause != null; cause = cause.getCause()) {
            String msg = cause.getLocalizedMessage();
            if (msg != null) {
                this.addMessage((Element)exception, msg);
            }
            if (cause == cause.getCause()) break;
        }
        return exception;
    }

    protected void addSubfaultElements(Element faultElement) {
    }

    public IDataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(IDataSource aDataSource) {
        this.dataSource = aDataSource;
    }

    @Override
    public BIBusEnvelope getFaultEnvelope() {
        Element dsElement;
        Element faultSignon;
        Element faultConnection;
        Element faultDataSource;
        BIBusEnvelope faultEnvelope = new BIBusEnvelope();
        Element faultElement = faultEnvelope.createFaultElement(this.getFaultCode(), this.getFaultString());
        this.addSubfaultElements(faultElement);
        Element detailElement = faultElement.element("detail");
        Element detailMessage = this.getFaultDetail();
        if (detailMessage != null) {
            detailElement.add(detailMessage);
        }
        if ((faultDataSource = this.getFaultDataSource()) != null) {
            faultElement.add(faultDataSource);
        }
        if ((faultConnection = this.getFaultConnection()) != null) {
            faultElement.add(faultConnection);
        }
        if ((faultSignon = this.getFaultSignon()) != null) {
            faultElement.add(faultSignon);
        }
        if (this.dataSource != null && (dsElement = this.dataSource.asXML()) != null) {
            faultElement.add(dsElement);
        }
        return faultEnvelope;
    }

    @Override
    public Fault getFault() {
        return this.getFaultFromEnvelope();
    }

    protected static String getAdjustedSignonName(String signonName) {
        if (signonName.equals("V5Credential") || signonName.equals("DataSourceCredential") || signonName.equals("OIDCCredential")) {
            return "";
        }
        return signonName;
    }

    protected static Element getFaultSignonElem(IDataSourceConnectionSignon signon) {
        DOMElement faultSignon = new DOMElement(new QName("faultSignon"));
        DOMElement userName = new DOMElement(new QName("name"));
        String adjustedSignonName = "";
        if (signon != null) {
            adjustedSignonName = DataSourceException.getAdjustedSignonName(signon.getName());
        }
        DOMAttribute value = new DOMAttribute(new QName("value"), adjustedSignonName);
        userName.add((Attribute)value);
        faultSignon.add((Element)userName);
        return faultSignon;
    }
}

