/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.model;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.data.model.DataSourceException;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import org.dom4j.Element;

public class DataSourceNotFoundException
extends DataSourceException {
    static final long serialVersionUID = 78897412874854594L;

    public DataSourceNotFoundException(IDataSource theDataSource) {
        super(theDataSource, XQEMessageKeys.DS_DataSourceNotFound, theDataSource.getCMDataSourceName());
    }

    public DataSourceNotFoundException(IDataSource theDataSource, Exception cause) {
        super(theDataSource, XQEMessageKeys.DS_DataSourceNotFound, cause, theDataSource.getCMDataSourceName());
    }

    @Override
    public String getFaultCode() {
        return "CQE-806";
    }

    @Override
    public String getFaultString() {
        return XQEMessages.getMessage(XQEMessageKeys.DS_DataSourceNotFound, XQEMessages.getCurrProductLocale(), this.getDataSource().getCMDataSourceName());
    }

    @Override
    public BIBusEnvelope getFaultEnvelope() {
        Element dsElement;
        BIBusEnvelope faultEnvelope = new BIBusEnvelope();
        Element faultElement = faultEnvelope.createFaultElement(this.getFaultCode(), this.getFaultString());
        if (this.getDataSource() != null && (dsElement = this.getDataSource().asXML()) != null) {
            faultElement.add(dsElement);
        }
        return faultEnvelope;
    }
}

