/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.providers.IDataProvider;
import com.cognos.xqe.data.providers.ProviderCategoryEnum;
import com.cognos.xqe.data.providers.connection.properties.ChoiceConstraint;
import com.cognos.xqe.data.providers.connection.properties.ConnectionPropertyDescriptor;
import com.cognos.xqe.data.providers.connection.properties.ConnectionPropertyType;
import com.cognos.xqe.data.providers.connection.properties.ConnectionPropertyUse;
import com.cognos.xqe.data.providers.connection.properties.IUseCondition;
import com.cognos.xqe.data.providers.connection.properties.IValueConstraint;
import com.cognos.xqe.data.providers.connection.properties.PropertyEqualsCondition;
import com.cognos.xqe.data.providers.connection.properties.PropertyExistsCondition;
import com.cognos.xqe.data.providers.connection.properties.PropertyNotExistsCondition;
import com.cognos.xqe.data.providers.connection.properties.RegexConstraint;
import com.cognos.xqe.data.providers.connection.properties.UseConditionUnion;
import com.cognos.xqe.data.providers.connection.properties.ValueConstraintIntersection;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.data.providers.olap.TracingOLAPDataProvider;
import com.cognos.xqe.data.providers.relational.IRelationalDataProvider;
import com.cognos.xqe.data.providers.relational.TraceRelationalDataProvider;
import com.cognos.xqe.data.providers.rscache.CachingProvider;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.ResourceLocator;
import com.cognos.xqe.util.SingletonHelper;
import com.cognos.xqe.util.pool.XQESAXReaderPool;
import com.cognos.xqe.util.xml.stax.ChildElementIterator;
import com.cognos.xqe.util.xml.stax.DelegatingComponentHandler;
import com.cognos.xqe.util.xml.stax.DocumentHandler;
import com.cognos.xqe.util.xml.stax.IStaxComponentHandler;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;

public class ProviderManager {
    private static final String LOG_GROUP = "ProviderManager";
    private static final String LOGMSG_INITIALIZING_MANAGER = "Initializing manager";
    private static final String LOGMSG_CONFIG_FILE_MISSING = "xqe.providers.xml configuration file was not found";
    private static final String LOGMSG_LOADING_DEV_CONFIG_FILE = "Loading xqe.providers.dev.xml configuration file on top of xqe.providers.xml";
    private static final String LOGMSG_CONFIG_ERROR = "An error occurred while loading configurations: ";
    private static final String LOGMSG_INSTANCE_LOADED = "Loaded provider instance ";
    private static final String LOGMSG_INSTANCE_RELEASED = "Released provider instance ";
    private static final String LOGMSG_TYPE_LOADED = "Loaded provider type ";
    private static final String LOGMSG_RELEASING_MANAGER = "Releasing manager";
    private static final String LOGMSG_INSTANCE_LOAD_ERROR = "An error occurred while loading provider instance ";
    private static final String LOGMSG_INSTANCE_RELEASE_ERROR = "An error occurred while releasing provider instance ";
    private static final String LOGMSG_CAUSED_BY = "; Caused by: ";
    private static final String LOGMSG_UNRECOGNIZED_ELEMENT = "Unrecognized element found: ";
    private static final String NAME = "name";
    private static final String NAMESPACE = "";
    private static final QName PROVIDER_INSTANCES_QNAME = new QName("", "providerInstances");
    private static final QName INSTANCE_QNAME = new QName("", "instance");
    private static final QName CLASS_NAME_QNAME = new QName("", "className");
    private static final QName PROVIDER_TYPES_QNAME = new QName("", "providerTypes");
    private static final QName PROVIDER_QNAME = new QName("", "provider");
    private static final QName CONNECTION_PROPERTIES_QNAME = new QName("", "connectionProperties");
    private static final QName CONNECTION_PROPERTY_QNAME = new QName("", "connectionProperty");
    private static final QName VALUE_CONSTRAINTS_QNAME = new QName("", "valueConstraints");
    private static final QName REGEX_QNAME = new QName("", "regex");
    private static final QName CHOICE_QNAME = new QName("", "choice");
    private static final QName USE_CONDITIONS_QNAME = new QName("", "useConditions");
    private static final QName PROPERTY_EXISTS_QNAME = new QName("", "propertyExists");
    private static final QName PROPERTY_NOT_EXISTS_QNAME = new QName("", "propertyNotExists");
    private static final QName PROPERTY_EQUALS_QNAME = new QName("", "propertyEquals");
    private static final QName DATATYPE_QNAME = new QName("", "datatype");
    private static final QName USE_QNAME = new QName("", "use");
    private static final QName NAME_QNAME = new QName("", "name");
    private static final QName DRIVERS_QNAME = new QName("", "drivers");
    private static final QName DRIVER_QNAME = new QName("", "driver");
    private static final QName TYPE_QNAME = new QName("", "type");
    private static final QName SUB_TYPE_QNAME = new QName("", "subType");
    private static SingletonHelper<ProviderManager> singletonHelper = new SingletonHelper<ProviderManager>(){

        @Override
        protected ProviderManager newInstance() {
            return new ProviderManager();
        }

        @Override
        protected void releaseImpl(ProviderManager theInstance) {
            theInstance.release();
        }

        @Override
        protected void initializeImpl(ProviderManager theInstance) {
            theInstance.initialize();
        }
    };
    private ConcurrentMap<String, ProviderInfo> providersTypes = new ConcurrentHashMap<String, ProviderInfo>();
    private ConcurrentMap<String, IDataProvider> providerInstances = new ConcurrentHashMap<String, IDataProvider>();
    private ConcurrentMap<String, ProviderPropertiesInfo> providersProperties = new ConcurrentHashMap<String, ProviderPropertiesInfo>();
    private boolean providersLoaded = false;
    private XQELogger logger = null;
    private Timer timer = new Timer("Provider-Manager-Timer", true);

    protected ProviderManager() {
    }

    public void addProviderInstance(String instanceName, String className, Properties properties) {
        ProviderPropertiesInfo propertiesInfo = new ProviderPropertiesInfo(className, properties);
        this.providersProperties.putIfAbsent(instanceName, propertiesInfo);
    }

    public void addProviderInstance(String instanceName, IDataProvider instance, Properties properties) {
        ProviderPropertiesInfo propertiesInfo = new ProviderPropertiesInfo(instance.getClass().toString(), properties);
        this.providersProperties.putIfAbsent(instanceName, propertiesInfo);
        this.providerInstances.put(instanceName, instance);
    }

    public void removeProviderInstance(String instanceName) {
        this.providerInstances.remove(instanceName);
        this.providersProperties.remove(instanceName);
    }

    public void addProviderType(String providerType, String providerName, String instanceName, List<ConnectionPropertyDescriptor> connProps, Map<String, String> driverMappings) {
        if (!this.providersProperties.containsKey(instanceName)) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Provider instance name does not exist: " + instanceName);
        }
        ProviderInfo providerInfo = new ProviderInfo();
        providerInfo.providerType = providerType;
        providerInfo.providerName = providerName;
        providerInfo.instanceName = instanceName;
        if (null != connProps) {
            providerInfo.setConnectionPropertyDescriptors(connProps);
        }
        if (null != driverMappings) {
            providerInfo.setDriverMappings(driverMappings);
        }
        this.providersTypes.putIfAbsent(providerType, providerInfo);
    }

    public void removeProviderType(String providerType) {
        this.providersTypes.remove(providerType);
    }

    protected void loadProviders(File providerConfigFile) {
        this.updateProvidersPropertiesAndInfos(providerConfigFile);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateProvidersPropertiesAndInfos(File providerConfigFile) {
        XQELogger traceLogger = this.getLogger();
        FileInputStream fileStream = null;
        try {
            fileStream = new FileInputStream(providerConfigFile);
            this.updateProvidersPropertiesAndInfos(providerConfigFile.getAbsolutePath(), fileStream);
        }
        catch (XQERuntimeException ex) {
            try {
                if (!traceLogger.isOn(LogLevel.ERROR)) throw ex;
                traceLogger.log(LogLevel.ERROR, LOGMSG_CONFIG_ERROR, (Throwable)ex);
                throw ex;
                catch (Throwable ex2) {
                    if (!traceLogger.isOn(LogLevel.ERROR)) throw new XQERuntimeException(XQEMessageKeys.CFG_FileLoadError, ex2, providerConfigFile.getPath());
                    traceLogger.log(LogLevel.ERROR, LOGMSG_CONFIG_ERROR, ex2);
                    throw new XQERuntimeException(XQEMessageKeys.CFG_FileLoadError, ex2, providerConfigFile.getPath());
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fileStream);
    }

    private void updateProvidersPropertiesAndInfos(URL configResourceUrl) {
        XQELogger traceLogger = this.getLogger();
        InputStream input = null;
        try {
            input = configResourceUrl.openStream();
            this.updateProvidersPropertiesAndInfos(configResourceUrl.toExternalForm(), input);
        }
        catch (IOException e) {
            if (traceLogger.isOn(LogLevel.ERROR)) {
                traceLogger.log(LogLevel.ERROR, LOGMSG_CONFIG_ERROR, (Throwable)e);
            }
            throw new XQERuntimeException(XQEMessageKeys.CFG_FileLoadError, (Throwable)e, configResourceUrl.toExternalForm());
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    private void updateProvidersPropertiesAndInfos(String uri, InputStream input) {
        XQELogger traceLogger = this.getLogger();
        try {
            XMLStreamReader xmlReader = StaxUtil.createXMLStreamReader(input);
            ProvidersHandler rootHandler = new ProvidersHandler(uri);
            DocumentHandler documentHandler = new DocumentHandler();
            documentHandler.setRootHandler(rootHandler);
            documentHandler.consume(xmlReader);
        }
        catch (XQERuntimeException ex) {
            if (traceLogger.isOn(LogLevel.ERROR)) {
                traceLogger.log(LogLevel.ERROR, LOGMSG_CONFIG_ERROR, (Throwable)ex);
            }
            throw ex;
        }
        catch (XMLStreamException e) {
            throw new XQERuntimeException(XQEMessageKeys.CFG_FileLoadError, (Throwable)e, uri);
        }
    }

    private void loadProviders() {
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        if (this.providersLoaded) {
            throw new IllegalStateException("The providers were already loaded");
        }
        String providersName = "xqe.providers.xml";
        ResourceLocator.IResourceMatcher[] searchPath = new ResourceLocator.IResourceMatcher[]{new ResourceLocator.DirectoryResourceMatcher(new File(config.getConfigDirectory())), new ResourceLocator.ClassResourceMatcher(this.getClass(), "/META-INF/xqe/configuration/")};
        URL providerConfigUrl = ResourceLocator.findURL(providersName, searchPath);
        if (providerConfigUrl == null) {
            this.getLogger().log(LogLevel.ERROR, LOGMSG_CONFIG_FILE_MISSING);
            throw new XQERuntimeException(XQEMessageKeys.CFG_FileExistError, providersName);
        }
        this.updateProvidersPropertiesAndInfos(providerConfigUrl);
        String providersDevName = "xqe.providers.dev.xml";
        URL providerConfigDevUrl = ResourceLocator.findURL(providersDevName, searchPath);
        if (providerConfigDevUrl != null) {
            this.getLogger().log(LogLevel.WARN, LOGMSG_LOADING_DEV_CONFIG_FILE);
            this.updateProvidersPropertiesAndInfos(providerConfigDevUrl);
        }
        this.providersLoaded = true;
    }

    private XQELogger getLogger() {
        if (null == this.logger) {
            this.logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", LOG_GROUP, LogLevel.INFO);
        }
        return this.logger;
    }

    public static ProviderManager getInstance() {
        return singletonHelper.getInstance();
    }

    public static void releaseInstance() {
        singletonHelper.releaseInstance();
    }

    protected void initialize() {
        this.getLogger().log(LOGMSG_INITIALIZING_MANAGER);
        this.loadProviders();
    }

    protected void release() {
        XQELogger traceLogger = this.getLogger();
        traceLogger.log(LOGMSG_RELEASING_MANAGER);
        for (IDataProvider provInstance : this.providerInstances.values()) {
            try {
                provInstance.release();
                if (!traceLogger.isOn()) continue;
                traceLogger.log(LOGMSG_INSTANCE_RELEASED + provInstance.getProviderInstanceName());
            }
            catch (Exception ex) {
                if (!traceLogger.isOn(LogLevel.WARN)) continue;
                traceLogger.log(LogLevel.WARN, LOGMSG_INSTANCE_RELEASE_ERROR + provInstance.getProviderInstanceName() + LOGMSG_CAUSED_BY, (Throwable)ex);
            }
        }
        this.providerInstances.clear();
        this.providersTypes.clear();
        this.providersProperties.clear();
        this.providerInstances = null;
        this.providersTypes = null;
        this.providersProperties = null;
    }

    public IDataProvider getDataProviderInstance(String instanceName) {
        XQELogger traceLogger = this.getLogger();
        IDataProvider provider = (IDataProvider)this.providerInstances.get(instanceName);
        if (null != provider) {
            return provider;
        }
        try {
            IDataProvider providerFromMap;
            ProviderPropertiesInfo propertiesInfo = (ProviderPropertiesInfo)this.providersProperties.get(instanceName);
            Class<?> providerClass = Class.forName(propertiesInfo.getClassName());
            if (!IDataProvider.class.isAssignableFrom(providerClass)) {
                throw new XQERuntimeException(XQEMessageKeys.PVD_InvalidProviderInstanceType, providerClass.getName());
            }
            Constructor<?> cTor = providerClass.getConstructor(String.class, Properties.class);
            provider = (IDataProvider)cTor.newInstance(instanceName, propertiesInfo.getProperties());
            if (provider instanceof IOLAPDataProvider) {
                boolean isRSCacheEnabled = Boolean.valueOf((provider = new TracingOLAPDataProvider((IOLAPDataProvider)provider, instanceName)).getProperty("resultSetCacheEnabled"));
                if (isRSCacheEnabled) {
                    provider = new CachingProvider((IOLAPDataProvider)provider);
                }
            } else if (provider instanceof IRelationalDataProvider) {
                provider = new TraceRelationalDataProvider((IRelationalDataProvider)provider);
            }
            if (traceLogger.isOn()) {
                traceLogger.log(LOGMSG_INSTANCE_LOADED + instanceName);
            }
            if ((providerFromMap = this.providerInstances.putIfAbsent(instanceName, provider)) != null) {
                provider = providerFromMap;
            }
        }
        catch (InvocationTargetException ex) {
            if (traceLogger.isOn(LogLevel.ERROR)) {
                traceLogger.log(LogLevel.ERROR, LOGMSG_INSTANCE_LOAD_ERROR + instanceName + LOGMSG_CAUSED_BY, ex.getTargetException());
            }
            throw new XQERuntimeException(XQEMessageKeys.PVD_ErrorLoadingProviderInstance, ex.getCause(), instanceName);
        }
        catch (Exception ex) {
            if (traceLogger.isOn(LogLevel.ERROR)) {
                traceLogger.log(LogLevel.ERROR, LOGMSG_INSTANCE_LOAD_ERROR + instanceName + LOGMSG_CAUSED_BY, (Throwable)ex);
            }
            throw new XQERuntimeException(XQEMessageKeys.PVD_ErrorLoadingProviderInstance, (Throwable)ex, instanceName);
        }
        return provider;
    }

    public ProviderInfo getProviderInfo(String providerType) {
        ProviderInfo providerInfo = (ProviderInfo)this.providersTypes.get(providerType);
        if (providerInfo == null) {
            if (providerType != null && providerType.startsWith("JDBC")) {
                providerInfo = (ProviderInfo)this.providersTypes.get("JDBC");
            }
            if (providerInfo == null) {
                throw new XQERuntimeException(XQEMessageKeys.PVD_InvalidProviderType, ProviderManager.getProviderNameFromQFSConfig(providerType));
            }
        }
        return providerInfo;
    }

    public ProviderInfo[] getProviders() {
        return this.providersTypes.values().toArray(new ProviderInfo[0]);
    }

    public IOLAPDataProvider getOLAPProvider(String providerType) {
        ProviderInfo info = this.getProviderInfo(providerType);
        if (info.getProviderCategory() != ProviderCategoryEnum.OLAP) {
            return null;
        }
        IDataProvider provider = info.getDataProvider();
        if (provider instanceof IOLAPDataProvider) {
            return (IOLAPDataProvider)provider;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getProviderNameFromQFSConfig(String providerType) {
        String providerName = null;
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        File qfsConfigFile = new File(config.getConfigDirectory() + "/qfs_config.xml");
        if (qfsConfigFile.exists()) {
            try {
                SAXReader reader = XQESAXReaderPool.getInstance().borrowReader();
                try {
                    Document qfsConfigFileDoc = reader.read(qfsConfigFile);
                    XPath xpathSelector = DocumentHelper.createXPath((String)("//QFSConfiguration/providerList/provider[@connectionCode='" + providerType + "']"));
                    List providerElements = CollectionCast.uncheckedCast(xpathSelector.selectNodes((Object)qfsConfigFileDoc));
                    if (!providerElements.isEmpty()) {
                        providerName = ((Element)providerElements.get(0)).attributeValue(NAME);
                    }
                    if (null == providerName) {
                        providerName = "relational (" + providerType + ')';
                    }
                }
                finally {
                    XQESAXReaderPool.getInstance().returnReader(reader);
                }
            }
            catch (Exception e) {
                throw XQERuntimeException.wrap(XQEMessageKeys.GEN_UnexpectedException, e);
            }
        }
        if (null == providerName) {
            providerName = providerType;
        }
        return providerName;
    }

    public IRelationalDataProvider getRelationalProvider(String providerType) {
        ProviderInfo info = this.getProviderInfo(providerType);
        IRelationalDataProvider provider = (IRelationalDataProvider)info.getDataProvider();
        if (info.getProviderCategory() != ProviderCategoryEnum.RELATIONAL) {
            throw new UnsupportedOperationException("Provider category was not RELATIONAL");
        }
        return provider;
    }

    public IDataProvider getProvider(String providerType) {
        ProviderInfo info = this.getProviderInfo(providerType);
        return info.getDataProvider();
    }

    private static void assertAttributeDefined(XMLStreamReader reader, QName attributeName, QName elementName, String value) throws XMLStreamException {
        if (null == value || value.length() == 0) {
            throw new XQERuntimeException(XQEMessageKeys.XML_MissingXMLAttributeWithLoc, attributeName.toString(), (Object)elementName.toString(), (Object)reader.getLocation().getLineNumber(), (Object)reader.getLocation().getColumnNumber());
        }
    }

    private static void throwIllegalAttributeValue(XMLStreamReader reader, QName attributeName, QName elementName, String value, Throwable cause) throws XMLStreamException {
        throw new XQERuntimeException(XQEMessageKeys.XML_IllegalXMLAttributeValueWithLoc, cause, (Object)attributeName.toString(), (Object)value, (Object)elementName.toString(), (Object)reader.getLocation().getLineNumber(), (Object)reader.getLocation().getColumnNumber());
    }

    private static void throwUnexpectedElement(XMLStreamReader reader, QName elementName) throws XMLStreamException {
        throw new XQERuntimeException(XQEMessageKeys.XML_UnexpectedXMLElementWithLoc, (Object)elementName.toString(), (Object)reader.getLocation().getLineNumber(), (Object)reader.getLocation().getColumnNumber());
    }

    private final class ProvidersHandler
    extends DelegatingComponentHandler {
        private String fileName;

        ProvidersHandler(String file) {
            this.fileName = file;
            this.setupProvidersHandler();
        }

        private void setupProvidersHandler() {
            this.registerDelegate(PROVIDER_INSTANCES_QNAME, this.buildProviderInstancesHandler());
            this.registerDelegate(PROVIDER_TYPES_QNAME, this.buildProviderTypesHandler());
        }

        private IStaxComponentHandler buildProviderInstancesHandler() {
            IStaxComponentHandler result = new IStaxComponentHandler(){

                @Override
                public void consume(XMLStreamReader reader) throws XMLStreamException {
                    ProvidersHandler.this.readProviderInstances(reader);
                }
            };
            return result;
        }

        private IStaxComponentHandler buildProviderTypesHandler() {
            IStaxComponentHandler result = new IStaxComponentHandler(){

                @Override
                public void consume(XMLStreamReader reader) throws XMLStreamException {
                    ProvidersHandler.this.readProviderTypes(reader);
                }
            };
            return result;
        }

        private void require(XMLStreamReader reader, int type, String nameSpaceURI, String localPart) throws XMLStreamException {
            String nsURI = nameSpaceURI;
            if (nsURI != null && nsURI.equals(ProviderManager.NAMESPACE)) {
                nsURI = null;
            }
            reader.require(type, nsURI, localPart);
        }

        private void readProviderInstances(XMLStreamReader reader) throws XMLStreamException {
            this.require(reader, 1, PROVIDER_INSTANCES_QNAME.getNamespaceURI(), PROVIDER_INSTANCES_QNAME.getLocalPart());
            ChildElementIterator childIter = new ChildElementIterator(reader);
            while (childIter.next()) {
                this.require(reader, 1, INSTANCE_QNAME.getNamespaceURI(), INSTANCE_QNAME.getLocalPart());
                String instanceName = reader.getAttributeValue(NAME_QNAME.getNamespaceURI(), NAME_QNAME.getLocalPart());
                ProviderManager.assertAttributeDefined(reader, NAME_QNAME, INSTANCE_QNAME, instanceName);
                String className = reader.getAttributeValue(CLASS_NAME_QNAME.getNamespaceURI(), CLASS_NAME_QNAME.getLocalPart());
                ProviderManager.assertAttributeDefined(reader, CLASS_NAME_QNAME, INSTANCE_QNAME, className);
                Properties properties = new Properties();
                int attrCount = reader.getAttributeCount();
                for (int i = 0; i < attrCount; ++i) {
                    properties.put(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                }
                properties.put("timer", ProviderManager.this.timer);
                if (!StaxUtil.skipElement(reader)) {
                    throw new XQERuntimeException(XQEMessageKeys.CFG_FileLoadError, this.fileName);
                }
                ProviderManager.this.addProviderInstance(instanceName, className, properties);
            }
        }

        private void readProviderTypes(XMLStreamReader reader) throws XMLStreamException {
            this.require(reader, 1, PROVIDER_TYPES_QNAME.getNamespaceURI(), PROVIDER_TYPES_QNAME.getLocalPart());
            ChildElementIterator childIter = new ChildElementIterator(reader);
            while (childIter.next()) {
                this.readProvider(reader);
            }
        }

        private void readProvider(XMLStreamReader reader) throws XMLStreamException {
            XQELogger traceLogger = ProviderManager.this.getLogger();
            this.require(reader, 1, PROVIDER_QNAME.getNamespaceURI(), PROVIDER_QNAME.getLocalPart());
            String providerName = reader.getAttributeValue(NAME_QNAME.getNamespaceURI(), NAME_QNAME.getLocalPart());
            ProviderManager.assertAttributeDefined(reader, NAME_QNAME, PROVIDER_QNAME, providerName);
            String providerType = reader.getAttributeValue(TYPE_QNAME.getNamespaceURI(), TYPE_QNAME.getLocalPart());
            ProviderManager.assertAttributeDefined(reader, TYPE_QNAME, PROVIDER_QNAME, providerType);
            String instanceName = reader.getAttributeValue(INSTANCE_QNAME.getNamespaceURI(), INSTANCE_QNAME.getLocalPart());
            ProviderManager.assertAttributeDefined(reader, INSTANCE_QNAME, PROVIDER_QNAME, providerType);
            List<ConnectionPropertyDescriptor> connProps = null;
            Map<String, String> driverMappings = null;
            ChildElementIterator childIter = new ChildElementIterator(reader);
            while (childIter.next()) {
                this.require(reader, 1, null, null);
                if (reader.getName().equals(CONNECTION_PROPERTIES_QNAME)) {
                    connProps = this.readConnectionProperties(reader);
                    continue;
                }
                if (reader.getName().equals(DRIVERS_QNAME)) {
                    driverMappings = this.readDrivers(reader);
                    continue;
                }
                if (traceLogger.isOn(LogLevel.WARN)) {
                    traceLogger.log(LogLevel.WARN, ProviderManager.LOGMSG_UNRECOGNIZED_ELEMENT + reader.getLocalName());
                }
                throw new XQERuntimeException(XQEMessageKeys.XML_UnexpectedXMLElementWithLoc, reader.getName(), (Object)reader.getLocation().getLineNumber(), (Object)reader.getLocation().getColumnNumber());
            }
            if (traceLogger.isOn()) {
                traceLogger.log(ProviderManager.LOGMSG_TYPE_LOADED + providerType);
            }
            ProviderManager.this.addProviderType(providerType, providerName, instanceName, connProps, driverMappings);
        }

        private List<ConnectionPropertyDescriptor> readConnectionProperties(XMLStreamReader reader) throws XMLStreamException {
            this.require(reader, 1, CONNECTION_PROPERTIES_QNAME.getNamespaceURI(), CONNECTION_PROPERTIES_QNAME.getLocalPart());
            ArrayList<ConnectionPropertyDescriptor> connProps = new ArrayList<ConnectionPropertyDescriptor>();
            ChildElementIterator propertyIter = new ChildElementIterator(reader);
            while (propertyIter.next()) {
                this.readConnectionProperty(reader, connProps);
            }
            return connProps;
        }

        private void readConnectionProperty(XMLStreamReader reader, List<ConnectionPropertyDescriptor> connProps) throws XMLStreamException {
            this.require(reader, 1, CONNECTION_PROPERTY_QNAME.getNamespaceURI(), CONNECTION_PROPERTY_QNAME.getLocalPart());
            String propertyNameStr = reader.getAttributeValue(NAME_QNAME.getNamespaceURI(), NAME_QNAME.getLocalPart());
            ProviderManager.assertAttributeDefined(reader, NAME_QNAME, CONNECTION_PROPERTY_QNAME, propertyNameStr);
            String propertyDatatypeStr = reader.getAttributeValue(DATATYPE_QNAME.getNamespaceURI(), DATATYPE_QNAME.getLocalPart());
            ProviderManager.assertAttributeDefined(reader, DATATYPE_QNAME, CONNECTION_PROPERTY_QNAME, propertyNameStr);
            ConnectionPropertyType propertyType = null;
            try {
                propertyType = ConnectionPropertyType.valueOf(propertyDatatypeStr.toUpperCase(Locale.US));
            }
            catch (Throwable ex) {
                ProviderManager.throwIllegalAttributeValue(reader, DATATYPE_QNAME, CONNECTION_PROPERTY_QNAME, propertyDatatypeStr, ex);
            }
            String propertyUseStr = reader.getAttributeValue(USE_QNAME.getNamespaceURI(), USE_QNAME.getLocalPart());
            ProviderManager.assertAttributeDefined(reader, USE_QNAME, CONNECTION_PROPERTY_QNAME, propertyNameStr);
            ConnectionPropertyUse propertyUse = null;
            try {
                propertyUse = ConnectionPropertyUse.valueOf(propertyUseStr.toUpperCase(Locale.US));
            }
            catch (Throwable ex) {
                ProviderManager.throwIllegalAttributeValue(reader, USE_QNAME, CONNECTION_PROPERTY_QNAME, propertyUseStr, ex);
            }
            ArrayList<IUseCondition> useConditions = new ArrayList<IUseCondition>();
            ArrayList<IValueConstraint> valueConstraints = new ArrayList<IValueConstraint>();
            ChildElementIterator childIter = new ChildElementIterator(reader);
            while (childIter.next()) {
                if (reader.getName().equals(USE_CONDITIONS_QNAME)) {
                    this.readUseConditions(reader, useConditions);
                    continue;
                }
                if (reader.getName().equals(VALUE_CONSTRAINTS_QNAME)) {
                    this.readValueConstraints(reader, valueConstraints);
                    continue;
                }
                ProviderManager.throwUnexpectedElement(reader, reader.getName());
            }
            ConnectionPropertyDescriptor propertyDescriptor = new ConnectionPropertyDescriptor(propertyNameStr, propertyType, propertyUse, new UseConditionUnion(useConditions), new ValueConstraintIntersection(valueConstraints));
            connProps.add(propertyDescriptor);
        }

        private void readUseConditions(XMLStreamReader reader, List<IUseCondition> useConditions) throws XMLStreamException {
            this.require(reader, 1, USE_CONDITIONS_QNAME.getNamespaceURI(), USE_CONDITIONS_QNAME.getLocalPart());
            ChildElementIterator childIter = new ChildElementIterator(reader);
            while (childIter.next()) {
                if (reader.getName().equals(PROPERTY_EQUALS_QNAME)) {
                    useConditions.add(PropertyEqualsCondition.parseFromXML(reader));
                    continue;
                }
                if (reader.getName().equals(PROPERTY_EXISTS_QNAME)) {
                    useConditions.add(PropertyExistsCondition.parseFromXML(reader));
                    continue;
                }
                if (reader.getName().equals(PROPERTY_NOT_EXISTS_QNAME)) {
                    useConditions.add(PropertyNotExistsCondition.parseFromXML(reader));
                    continue;
                }
                ProviderManager.throwUnexpectedElement(reader, reader.getName());
            }
        }

        private void readValueConstraints(XMLStreamReader reader, List<IValueConstraint> valueConstraints) throws XMLStreamException {
            this.require(reader, 1, VALUE_CONSTRAINTS_QNAME.getNamespaceURI(), VALUE_CONSTRAINTS_QNAME.getLocalPart());
            ChildElementIterator childIter = new ChildElementIterator(reader);
            while (childIter.next()) {
                if (reader.getName().equals(CHOICE_QNAME)) {
                    valueConstraints.add(ChoiceConstraint.parseFromXML(reader));
                    continue;
                }
                if (reader.getName().equals(REGEX_QNAME)) {
                    valueConstraints.add(RegexConstraint.parseFromXML(reader));
                    continue;
                }
                ProviderManager.throwUnexpectedElement(reader, reader.getName());
            }
        }

        private Map<String, String> readDrivers(XMLStreamReader reader) throws XMLStreamException {
            this.require(reader, 1, DRIVERS_QNAME.getNamespaceURI(), DRIVERS_QNAME.getLocalPart());
            HashMap<String, String> driverMappings = new HashMap<String, String>();
            ChildElementIterator driverIter = new ChildElementIterator(reader);
            while (driverIter.next()) {
                this.require(reader, 1, DRIVER_QNAME.getNamespaceURI(), DRIVER_QNAME.getLocalPart());
                String driverSubType = reader.getAttributeValue(SUB_TYPE_QNAME.getNamespaceURI(), SUB_TYPE_QNAME.getLocalPart());
                ProviderManager.assertAttributeDefined(reader, SUB_TYPE_QNAME, DRIVER_QNAME, driverSubType);
                String driverClassName = reader.getAttributeValue(CLASS_NAME_QNAME.getNamespaceURI(), CLASS_NAME_QNAME.getLocalPart());
                ProviderManager.assertAttributeDefined(reader, CLASS_NAME_QNAME, DRIVER_QNAME, driverClassName);
                driverMappings.put(driverSubType, driverClassName);
                if (StaxUtil.skipElement(reader)) continue;
                throw new XQERuntimeException(XQEMessageKeys.CFG_FileLoadError, this.fileName);
            }
            return driverMappings;
        }
    }

    public final class ProviderPropertiesInfo {
        private final String className;
        private final Properties properties;

        public ProviderPropertiesInfo(String theClassName, Properties theProperties) {
            this.className = theClassName;
            this.properties = theProperties;
        }

        public String getClassName() {
            return this.className;
        }

        public Properties getProperties() {
            return this.properties;
        }
    }

    public final class ProviderInfo {
        private String instanceName;
        private String providerName;
        private String providerType;
        private ProviderCategoryEnum providerCategory = null;
        private List<ConnectionPropertyDescriptor> connectionPropertyDescriptors = new ArrayList<ConnectionPropertyDescriptor>();
        private Map<String, String> driverMappings = new HashMap<String, String>();
        private IDataProvider dataProvider;

        private ProviderInfo() {
        }

        public List<ConnectionPropertyDescriptor> getConnectionPropertyDescriptors() {
            return Collections.unmodifiableList(this.connectionPropertyDescriptors);
        }

        private void setConnectionPropertyDescriptors(List<ConnectionPropertyDescriptor> descriptors) {
            this.connectionPropertyDescriptors.addAll(descriptors);
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public String getProviderName() {
            return this.providerName;
        }

        public String getProviderType() {
            return this.providerType;
        }

        public ProviderCategoryEnum getProviderCategory() {
            if (this.providerCategory != null) {
                return this.providerCategory;
            }
            IDataProvider localProvider = this.getDataProvider();
            if (localProvider instanceof IOLAPDataProvider) {
                this.providerCategory = ProviderCategoryEnum.OLAP;
            } else if (localProvider instanceof IRelationalDataProvider) {
                this.providerCategory = ProviderCategoryEnum.RELATIONAL;
            } else {
                throw new XQERuntimeException(XQEMessageKeys.PVD_InvalidProviderInstanceType, localProvider.getClass().getName());
            }
            return this.providerCategory;
        }

        public Map<String, String> getDriverMappings() {
            return Collections.unmodifiableMap(this.driverMappings);
        }

        private void setDriverMappings(Map<String, String> mappings) {
            this.driverMappings.putAll(mappings);
        }

        public IDataProvider getDataProvider() {
            if (null != this.dataProvider) {
                return this.dataProvider;
            }
            this.dataProvider = ProviderManager.this.getDataProviderInstance(this.instanceName);
            return this.dataProvider;
        }

        public IDataProvider findDataProvider() {
            return this.dataProvider;
        }
    }
}

