/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.ProviderResultSetBase;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.resource.ReleasableResourceTracker;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class ProviderScrollableCellIteratorBase
extends XScrollableCellIterator {
    private final ProviderResultSetBase mResultSet;
    private final AtomicBoolean mReleased = new AtomicBoolean(false);
    private static final XQELogger ERROR_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Resources", LogLevel.ERROR);

    public ProviderScrollableCellIteratorBase(ProviderResultSetBase rs, XDataContext xDataContext, Integer nodeId) {
        super(xDataContext, nodeId);
        if (null == rs) {
            throw new IllegalArgumentException("rs was null");
        }
        this.mResultSet = rs;
        this.mResultSet.getResourceTracker().addInstance(this, Thread.currentThread().getStackTrace());
    }

    public final ProviderResultSetBase getResultSet() {
        return this.mResultSet;
    }

    public final Locale getFormatLocale() {
        return this.getResultSet().getFormatLocale();
    }

    @Override
    public final void release() {
        try {
            if (this.mReleased.compareAndSet(false, true)) {
                ReleasableResourceTracker parentTracker = this.getResultSet().getResourceTracker();
                parentTracker.removeInstance(this);
                this.releaseImpl();
            }
        }
        catch (Throwable e) {
            ERROR_LOGGER.log(e);
        }
    }

    public abstract void releaseImpl();
}

