/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.analytics;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public final class ForecastTypeParser {
    private static final int PERCENTANGE_DENOMINATOR = 100;
    private static final String DELIMITERS = "(),;[]/\\|&%~!@#^*=<>?\"':~ \r\n\t";
    private static final String WHITESPACE_CHARACTERS = " \r\n\t";
    String text2Parse;
    StringTokenizer tokenizer;
    int positionInText;
    int prevPositionInText;

    private ForecastTypeParser(String fText2Parse) {
        this.text2Parse = fText2Parse;
        this.tokenizer = new StringTokenizer(this.text2Parse, DELIMITERS, true);
        this.positionInText = 0;
        this.prevPositionInText = 0;
    }

    String nextToken() {
        String token;
        do {
            if (!this.tokenizer.hasMoreTokens()) {
                return null;
            }
            token = this.tokenizer.nextToken();
            this.prevPositionInText = this.positionInText;
            this.positionInText += token.length();
        } while (ForecastTypeParser.isWhiteSpace(token));
        return token;
    }

    private void reportSyntaxError() {
        String errorInText = this.text2Parse.substring(0, this.prevPositionInText) + "^^^" + this.text2Parse.substring(this.prevPositionInText);
        throw new XQERuntimeException(XQEMessageKeys.PRE_ForecastTypeSyntaxError, errorInText);
    }

    public Map<String, Collection<Object>> parse() {
        String token;
        ForecastTypeParser parser = new ForecastTypeParser(this.text2Parse);
        String currentPropertyName = "";
        ArrayList<List<Object>> curParameterListCollection = null;
        HashMap<String, Collection<Object>> parsedType = new HashMap<String, Collection<Object>>();
        while ((token = parser.nextToken()) != null) {
            if (token.equals("(")) {
                List<Object> parameterList = parser.readValueList();
                if (curParameterListCollection != null) {
                    curParameterListCollection.add(parameterList);
                    continue;
                }
                Collection value = (Collection)parsedType.get(currentPropertyName);
                if (value == null) {
                    parsedType.put(currentPropertyName, parameterList);
                    continue;
                }
                curParameterListCollection = new ArrayList<List<Object>>();
                curParameterListCollection.add((List<Object>)value);
                curParameterListCollection.add(parameterList);
                parsedType.put(currentPropertyName, curParameterListCollection);
                continue;
            }
            if (ForecastTypeParser.isPropertyName(token)) {
                currentPropertyName = token;
                parsedType.put(currentPropertyName, null);
                curParameterListCollection = null;
                continue;
            }
            this.reportSyntaxError();
        }
        return parsedType;
    }

    private List<Object> readValueList() {
        String token;
        ArrayList<Object> valueList = new ArrayList<Object>();
        while ((token = this.nextToken()) != null) {
            if (token.equals("%")) {
                this.applyPercentToLastValue(valueList);
                continue;
            }
            if (token.equals(")")) {
                return valueList;
            }
            if (valueList.size() > 0) {
                if (!token.equals(",") && !token.equals(";")) {
                    this.reportSyntaxError();
                }
                token = this.nextToken();
            }
            valueList.add(this.readValue(token));
        }
        this.reportSyntaxError();
        return valueList;
    }

    private void applyPercentToLastValue(List<Object> valueList) {
        if (valueList.size() == 0) {
            this.reportSyntaxError();
        }
        Object lastValue = valueList.get(valueList.size() - 1);
        double number = 0.0;
        if (lastValue instanceof Integer) {
            number = ((Integer)lastValue).intValue();
        } else if (lastValue instanceof Double) {
            number = (Double)lastValue;
        } else {
            this.reportSyntaxError();
        }
        valueList.set(valueList.size() - 1, new Double(number / 100.0));
    }

    public static Map<String, Collection<Object>> parse(String text2Parse) {
        ForecastTypeParser parser = new ForecastTypeParser(text2Parse);
        return parser.parse();
    }

    private Object readValue(String token) {
        if (token == null) {
            this.reportSyntaxError();
        }
        try {
            return Integer.parseInt(token);
        }
        catch (NumberFormatException e) {
            try {
                return Double.parseDouble(token);
            }
            catch (NumberFormatException e1) {
                return token;
            }
        }
    }

    private static boolean isPropertyName(String token) {
        return token.matches("([a-z]|[A-Z])([a-z]|[A-Z]|[0-9]|_)*");
    }

    private static boolean isWhiteSpace(String token) {
        for (int i = 0; i < token.length(); ++i) {
            if (WHITESPACE_CHARACTERS.indexOf(token.charAt(i)) >= 0) continue;
            return false;
        }
        return true;
    }
}

