/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.connection;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.connection.ConnectionPoolLogger;
import com.cognos.xqe.data.providers.connection.ProviderConnectionPoolFactory;
import com.cognos.xqe.data.providers.connection.ProviderContextualConnectionPoolFactory;
import com.cognos.xqe.pool.connection.IConnectionPool;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.pool.connection.poolfactory.ConnectionPoolFactory;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import java.util.Map;
import java.util.Set;
import java.util.Timer;

public class ConnectionPoolHelper {
    private final IConnectionPool mGlobalConnectionPool;
    private final Timer mTimer;
    private final ConnectionPoolFactory mConnectionPoolFactory;

    public ConnectionPoolHelper(Timer timer) {
        this.mTimer = timer;
        this.mConnectionPoolFactory = new ConnectionPoolFactory();
        this.mGlobalConnectionPool = this.mConnectionPoolFactory.createPool(new ProviderConnectionPoolFactory(this.mTimer));
    }

    public void setConnectionPool(IExecutionEnvironment executionEnvironment) {
        if (executionEnvironment.getConnectionPool() == null) {
            executionEnvironment.setConnectionPool(ConnectionPoolHelper.wrapPoolForLogging(this.mGlobalConnectionPool, executionEnvironment));
        }
    }

    public void setMultiRequestConnectionPool(IExecutionEnvironment executionEnvironment, MultiRequestContext multiRequestContext) {
        executionEnvironment.setMultiRequestContext(multiRequestContext);
        IConnectionPool newConnectionPool = multiRequestContext.getConnectionPool();
        if (null == newConnectionPool) {
            newConnectionPool = this.mConnectionPoolFactory.createPool(new ProviderContextualConnectionPoolFactory(this.mGlobalConnectionPool));
            newConnectionPool = ConnectionPoolHelper.wrapPoolForLogging(newConnectionPool, executionEnvironment);
            multiRequestContext.setConnectionPool(newConnectionPool);
        }
        executionEnvironment.setConnectionPool(newConnectionPool);
    }

    public void release() {
        Map<String, Integer> finalNumberOfBorrowedConnections = this.getBorrowedConnectionStatistics();
        if (finalNumberOfBorrowedConnections.size() != 0) {
            XQEDebugLog.err.println("*** The following connections have not been returned to the pool, \n\tplease investigate: " + finalNumberOfBorrowedConnections);
            XQEDebugLog.err.println();
        }
        this.mGlobalConnectionPool.release();
    }

    public Map<String, Integer> getBorrowedConnectionStatistics() {
        return this.mGlobalConnectionPool.getBorrowedConnectionStatistics();
    }

    public Map<String, Integer> getIdleConnectionStatistics() {
        return this.mGlobalConnectionPool.getIdleConnectionStatistics();
    }

    public Map<String, Map<IPooledConnection, Set<Object>>> getCachingStatistics() {
        return this.mGlobalConnectionPool.getCachingStatistics();
    }

    public void returnAllBorrowedConnections() {
        this.mGlobalConnectionPool.returnAllBorrowedConnections();
    }

    public void closeAllIdleConnections() {
        this.mGlobalConnectionPool.closeAllIdleConnections();
    }

    public void closeAllIdleConnectionsForProvider(String providerName) {
        this.mGlobalConnectionPool.getOrCreateProviderConnectionPool(providerName).closeAllIdleConnections();
    }

    private static IConnectionPool wrapPoolForLogging(IConnectionPool connectionPool, IExecutionEnvironment executionEnvironment) {
        IConnectionPool returnedConnectionPool = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Connection.Pool", ConnectionPoolLogger.LOGGING_LEVEL).isOn() || XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Connection.Factory", ConnectionPoolLogger.LOGGING_LEVEL).isOn() || XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "QueryService.Connection", ConnectionPoolLogger.LOGGING_LEVEL).isOn() ? new ConnectionPoolLogger(connectionPool, executionEnvironment) : connectionPool;
        return returnedConnectionPool;
    }
}

