/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.connection.properties;

import com.cognos.xqe.data.providers.connection.properties.IValueConstraint;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class RegexConstraint
implements IValueConstraint {
    private static final String REGEX = "regex";
    private static final String PATTERN = "pattern";
    private final Pattern pattern;

    public RegexConstraint(String thePattern) {
        this.pattern = Pattern.compile(thePattern);
    }

    @Override
    public boolean isValid(String value) {
        return this.pattern.matcher(value).matches();
    }

    public static RegexConstraint parseFromXML(XMLStreamReader reader) throws XMLStreamException {
        reader.require(1, null, REGEX);
        String patternString = reader.getAttributeValue(null, PATTERN);
        StaxUtil.skipElement(reader);
        return new RegexConstraint(patternString);
    }
}

