/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap;

import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.metadata.record.RecordType;
import com.cognos.xqe.util.CollectionCast;
import java.util.List;

public enum MetadataOperation {
    ACTIONS(RecordType.ACTION),
    ALIASES(RecordType.ALIAS),
    CATALOGS(RecordType.CATALOG),
    CUBES(RecordType.CUBE),
    DIMENSIONS(RecordType.DIMENSION),
    HIERARCHIES(RecordType.HIERARCHY),
    HIERARCHYNAMEDSETS(RecordType.HIERARCHYNAMEDSET),
    HIERARCHYROOTMEMBERS(RecordType.MEMBER),
    HIERARCHYCALCULATEDMEMBERS(RecordType.MEMBER),
    LEVELS(RecordType.LEVEL),
    MACROS(RecordType.MACRO),
    MEASURES(RecordType.MEASURE),
    MEMBERS(RecordType.MEMBER),
    NAMEDSETS(RecordType.NAMEDSET),
    NAMEDSETMEMBERS(RecordType.MEMBER),
    NAMEDSETLEVELUNIQUENAMES(null),
    PROPERTIES(RecordType.PROPERTY),
    VARIABLES(RecordType.VARIABLE),
    DATASOURCELOCALES(null),
    CUBEDEFAULTMEASURE(null);

    private final RecordType recordType;
    private static final String UNSUPPORTED_OPERATION = "Unsupported Metadata Operation";

    private MetadataOperation(RecordType theRecordType) {
        this.recordType = theRecordType;
    }

    public RecordType getRecordType() {
        return this.recordType;
    }

    public static List<MetadataRecord> invoke(MetadataOperation theOperation, IOLAPMetadataProvider theMetadataProvider, IRestrictions theRestrictions) {
        if (null == theOperation) {
            throw new IllegalArgumentException("theOperation is null");
        }
        if (null == theMetadataProvider) {
            throw new IllegalArgumentException("theMetadataProvider is null");
        }
        if (null == theRestrictions) {
            throw new IllegalArgumentException("theRestrictions is null");
        }
        switch (theOperation) {
            case ACTIONS: {
                return CollectionCast.upcast(theMetadataProvider.getActions(theRestrictions), MetadataRecord.class);
            }
            case ALIASES: {
                return CollectionCast.upcast(theMetadataProvider.getAliases(theRestrictions), MetadataRecord.class);
            }
            case CATALOGS: {
                return CollectionCast.upcast(theMetadataProvider.getCatalogs(theRestrictions), MetadataRecord.class);
            }
            case CUBES: {
                return CollectionCast.upcast(theMetadataProvider.getCubes(theRestrictions), MetadataRecord.class);
            }
            case DIMENSIONS: {
                return CollectionCast.upcast(theMetadataProvider.getDimensions(theRestrictions), MetadataRecord.class);
            }
            case HIERARCHIES: {
                return CollectionCast.upcast(theMetadataProvider.getHierarchies(theRestrictions), MetadataRecord.class);
            }
            case HIERARCHYROOTMEMBERS: {
                return CollectionCast.upcast(theMetadataProvider.getHierarchyRootMembers(theRestrictions), MetadataRecord.class);
            }
            case HIERARCHYCALCULATEDMEMBERS: {
                return CollectionCast.upcast(theMetadataProvider.getHierarchyCalculatedMembers(theRestrictions), MetadataRecord.class);
            }
            case LEVELS: {
                return CollectionCast.upcast(theMetadataProvider.getLevels(theRestrictions), MetadataRecord.class);
            }
            case MACROS: {
                return CollectionCast.upcast(theMetadataProvider.getMacros(theRestrictions), MetadataRecord.class);
            }
            case MEASURES: {
                return CollectionCast.upcast(theMetadataProvider.getMeasures(theRestrictions), MetadataRecord.class);
            }
            case MEMBERS: {
                return CollectionCast.upcast(theMetadataProvider.getMembers(theRestrictions), MetadataRecord.class);
            }
            case NAMEDSETS: {
                return CollectionCast.upcast(theMetadataProvider.getNamedSets(theRestrictions), MetadataRecord.class);
            }
            case HIERARCHYNAMEDSETS: {
                return CollectionCast.upcast(theMetadataProvider.getHierarchyNamedSets(theRestrictions), MetadataRecord.class);
            }
            case NAMEDSETMEMBERS: {
                return CollectionCast.upcast(theMetadataProvider.getNamedSetMembers(theRestrictions), MetadataRecord.class);
            }
            case PROPERTIES: {
                return CollectionCast.upcast(theMetadataProvider.getProperties(theRestrictions), MetadataRecord.class);
            }
            case VARIABLES: {
                return CollectionCast.upcast(theMetadataProvider.getVariables(theRestrictions), MetadataRecord.class);
            }
        }
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, UNSUPPORTED_OPERATION);
    }

    public static String invokeNonStandard(MetadataOperation theOperation, IOLAPMetadataProvider theMetadataProvider, IRestrictions theRestrictions) {
        if (null == theOperation) {
            throw new IllegalArgumentException("theOperation was null");
        }
        if (null == theMetadataProvider) {
            throw new IllegalArgumentException("theMetadataProvider was null");
        }
        if (null == theRestrictions) {
            throw new IllegalArgumentException("theRestrictions was null");
        }
        switch (theOperation) {
            case CUBEDEFAULTMEASURE: {
                return theMetadataProvider.getCubeDefaultMeasure(theRestrictions);
            }
        }
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, UNSUPPORTED_OPERATION);
    }

    public static List<String> invokeNonStandardList(MetadataOperation theMetaOperation, IOLAPMetadataProvider theMetaProvider, IRestrictions theRestrictions) {
        if (null == theMetaOperation) {
            throw new IllegalArgumentException("theMetaOperation was null");
        }
        if (null == theMetaProvider) {
            throw new IllegalArgumentException("theMetaProvider was null");
        }
        if (null == theRestrictions) {
            throw new IllegalArgumentException("the restrictions were null");
        }
        if (theMetaOperation == DATASOURCELOCALES) {
            return theMetaProvider.getDatasourceLocales(theRestrictions);
        }
        if (theMetaOperation == NAMEDSETLEVELUNIQUENAMES) {
            return theMetaProvider.getNamedSetLevelUniqueNames(theRestrictions);
        }
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, UNSUPPORTED_OPERATION);
    }

    public static MetadataOperation fromString(String operation) {
        String op = operation.replaceAll("get", "").toUpperCase();
        return MetadataOperation.valueOf(op);
    }
}

