/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.cache.config;

import com.cognos.xqe.data.providers.olap.cache.IOLAPMetadataCacheFactory;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.xml.stax.ChildElementIterator;
import com.cognos.xqe.util.xml.stax.IStaxComponentHandler;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

class CacheFactoryHandler
implements IStaxComponentHandler {
    private static final String CACHE_FACTORY_INSTANCE = "cacheFactoryInstance";
    private static final String ARGS = "args";
    private static final String ARG = "arg";
    private static final String NULL = "null";
    private static final String BOOLEAN = "boolean";
    private static final String BYTE = "byte";
    private static final String SHORT = "short";
    private static final String INT = "int";
    private static final String LONG = "long";
    private static final String FLOAT = "float";
    private static final String DOUBLE = "double";
    private static final String STRING = "string";
    private static final String ARRAY = "array";
    private static final String CLASS = "class";
    private static final String NAME = "name";
    private IOLAPMetadataCacheFactory factoryInstance = null;

    CacheFactoryHandler() {
    }

    @Override
    public void consume(XMLStreamReader reader) throws XMLStreamException {
        String factoryName = reader.getAttributeValue(null, NAME);
        ChildElementIterator childIter = new ChildElementIterator(reader);
        if (childIter.next()) {
            if (!reader.getLocalName().equals(CACHE_FACTORY_INSTANCE)) {
                throw new XQERuntimeException(XQEMessageKeys.XML_UnexpectedXMLElementWithLoc, reader.getName(), (Object)reader.getLocation().getLineNumber(), (Object)reader.getLocation().getColumnNumber());
            }
        } else {
            throw new XQERuntimeException(XQEMessageKeys.XML_MissingXMLElementWithLoc, (Object)CACHE_FACTORY_INSTANCE, (Object)reader.getLocation().getLineNumber(), (Object)reader.getLocation().getColumnNumber());
        }
        this.factoryInstance = this.consumeCacheFactoryInstance(reader, factoryName);
        if (childIter.next()) {
            throw new XQERuntimeException(XQEMessageKeys.XML_UnexpectedXMLElementWithLoc, reader.getName(), (Object)reader.getLocation().getLineNumber(), (Object)reader.getLocation().getColumnNumber());
        }
    }

    public IOLAPMetadataCacheFactory getFactoryInstance() {
        return this.factoryInstance;
    }

    private IOLAPMetadataCacheFactory consumeCacheFactoryInstance(XMLStreamReader reader, String factoryName) throws XMLStreamException {
        String className = reader.getAttributeValue(null, CLASS);
        if (null == className) {
            throw new XQERuntimeException(XQEMessageKeys.XML_MissingXMLElementWithLoc, (Object)CACHE_FACTORY_INSTANCE, (Object)reader.getLocation().getLineNumber(), (Object)reader.getLocation().getColumnNumber());
        }
        Class<?> factoryClass = null;
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            factoryClass = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            if (ARGS.equals(reader.getLocalName())) {
                this.consumeArgs(reader, args);
                continue;
            }
            throw new XQERuntimeException(XQEMessageKeys.XML_UnexpectedXMLElementWithLoc, reader.getName(), (Object)reader.getLocation().getLineNumber(), (Object)reader.getLocation().getColumnNumber());
        }
        IOLAPMetadataCacheFactory instance = null;
        try {
            instance = (IOLAPMetadataCacheFactory)factoryClass.newInstance();
        }
        catch (Exception ex) {
            throw XQERuntimeException.wrap(XQEMessageKeys.GEN_UnexpectedException, ex);
        }
        if (null != factoryName) {
            args.put("FACTORY_NAME", factoryName);
        }
        instance.setArguments(args);
        return instance;
    }

    private void consumeArgs(XMLStreamReader reader, Map<String, Object> theArguments) throws XMLStreamException {
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            if (ARG.equals(reader.getLocalName())) {
                this.consumeArg(reader, theArguments);
                continue;
            }
            throw new XQERuntimeException(XQEMessageKeys.XML_UnexpectedXMLElementWithLoc, reader.getName(), (Object)reader.getLocation().getLineNumber(), (Object)reader.getLocation().getColumnNumber());
        }
    }

    private void consumeArg(XMLStreamReader reader, Map<String, Object> args) throws XMLStreamException {
        String attrName = reader.getAttributeValue(null, NAME);
        if (null == attrName) {
            throw new XQERuntimeException(XQEMessageKeys.XML_MissingXMLElementWithLoc, (Object)ARG, (Object)reader.getLocation().getLineNumber(), (Object)reader.getLocation().getColumnNumber());
        }
        ChildElementIterator childIter = new ChildElementIterator(reader);
        Object argValue = null;
        if (childIter.next()) {
            argValue = this.consumeValue(reader);
            if (childIter.next()) {
                throw new XQERuntimeException(XQEMessageKeys.XML_UnexpectedXMLElementWithLoc, reader.getName(), (Object)reader.getLocation().getLineNumber(), (Object)reader.getLocation().getColumnNumber());
            }
        }
        args.put(attrName, argValue);
    }

    private Object consumeValue(XMLStreamReader reader) throws XMLStreamException {
        String typeName = reader.getLocalName();
        Object value = null;
        if (NULL.equals(typeName)) {
            StaxUtil.skipElement(reader);
        } else if (BOOLEAN.equals(typeName)) {
            value = Boolean.parseBoolean(reader.getElementText());
        } else if (BYTE.equals(typeName)) {
            value = Byte.parseByte(reader.getElementText());
        } else if (SHORT.equals(typeName)) {
            value = Short.parseShort(reader.getElementText());
        } else if (INT.equals(typeName)) {
            value = Integer.parseInt(reader.getElementText());
        } else if (LONG.equals(typeName)) {
            value = Long.parseLong(reader.getElementText());
        } else if (FLOAT.equals(typeName)) {
            value = Float.valueOf(Float.parseFloat(reader.getElementText()));
        } else if (DOUBLE.equals(typeName)) {
            value = Double.parseDouble(reader.getElementText());
        } else if (STRING.equals(typeName)) {
            value = reader.getElementText();
        } else if (ARRAY.equals(typeName)) {
            value = this.consumeArray(reader);
        } else if (CACHE_FACTORY_INSTANCE.equals(typeName)) {
            value = this.consumeCacheFactoryInstance(reader, null);
        } else {
            throw new XQERuntimeException(XQEMessageKeys.XML_UnexpectedXMLElementWithLoc, reader.getName(), (Object)reader.getLocation().getLineNumber(), (Object)reader.getLocation().getColumnNumber());
        }
        return value;
    }

    private Object[] consumeArray(XMLStreamReader reader) throws XMLStreamException {
        ChildElementIterator childIter = new ChildElementIterator(reader);
        ArrayList<Object> elements = new ArrayList<Object>();
        while (childIter.next()) {
            elements.add(this.consumeValue(reader));
        }
        return elements.toArray();
    }
}

