/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.cache.inmemory;

import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.MetadataOperation;
import com.cognos.xqe.data.providers.olap.MetadataProviderBase;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.cache.AbstractOLAPMetadataCache;
import com.cognos.xqe.data.providers.olap.cache.CacheParameters;
import com.cognos.xqe.data.providers.olap.cache.inmemory.InMemoryOLAPMetadataCacheFactory;
import com.cognos.xqe.metadata.TreeOperatorEnum;
import com.cognos.xqe.metadata.record.CatalogRecord;
import com.cognos.xqe.metadata.record.CubeRecord;
import com.cognos.xqe.metadata.record.DimensionRecord;
import com.cognos.xqe.metadata.record.HierarchyRecord;
import com.cognos.xqe.metadata.record.LevelRecord;
import com.cognos.xqe.metadata.record.MeasureRecord;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.metadata.record.PropertyRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class InMemoryOLAPMetadataCache
extends AbstractOLAPMetadataCache {
    private final RootCache rootCache = new RootCache();

    InMemoryOLAPMetadataCache(InMemoryOLAPMetadataCacheFactory theFactory, CacheParameters theParameters) {
        super(theFactory, theParameters);
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public void flushImpl() {
    }

    @Override
    protected boolean invalidateImpl(MetadataOperation operation, IRestrictions restrictions) {
        return false;
    }

    @Override
    public void clearImpl() {
        this.rootCache.clear();
    }

    @Override
    public void closeImpl() {
    }

    @Override
    public <T extends MetadataRecord> List<T> getMetadataImpl(MetadataOperation operation, IRestrictions restrictions) {
        List<MetadataRecord> results = null;
        switch (operation) {
            case ACTIONS: {
                break;
            }
            case ALIASES: {
                break;
            }
            case CATALOGS: {
                results = this.getCatalogs(this.rootCache, restrictions);
                break;
            }
            case CUBES: {
                results = this.getCubes(this.rootCache, restrictions);
                break;
            }
            case DIMENSIONS: {
                results = this.getDimensions(this.rootCache, restrictions);
                break;
            }
            case HIERARCHIES: {
                results = this.getHierarchies(this.rootCache, restrictions);
                break;
            }
            case HIERARCHYROOTMEMBERS: {
                results = this.getHierarchyRootMembers(this.rootCache, restrictions);
                break;
            }
            case LEVELS: {
                results = this.getLevels(this.rootCache, restrictions);
                break;
            }
            case MACROS: {
                break;
            }
            case MEASURES: {
                results = this.getMeasures(this.rootCache, restrictions);
                break;
            }
            case MEMBERS: {
                break;
            }
            case NAMEDSETMEMBERS: {
                break;
            }
            case NAMEDSETLEVELUNIQUENAMES: {
                break;
            }
            case NAMEDSETS: {
                break;
            }
            case HIERARCHYNAMEDSETS: {
                break;
            }
            case PROPERTIES: {
                results = this.getProperties(this.rootCache, restrictions);
                break;
            }
            case VARIABLES: {
                break;
            }
        }
        return results;
    }

    private List<MemberRecord> getHierarchyRootMembers(RootCache cache, IRestrictions restrictions) {
        MetadataProviderBase.validateRequiredRestrictions(MetadataOperation.HIERARCHYROOTMEMBERS, restrictions);
        String catalogRes = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String cubeRes = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String hunRes = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        List<MemberRecord> rootMembers = cache.getHierarchyRootMembers(catalogRes, cubeRes, hunRes);
        if (null == rootMembers) {
            return null;
        }
        return new ArrayList<MemberRecord>(rootMembers);
    }

    private List<MeasureRecord> getMeasures(RootCache cache, IRestrictions restrictions) {
        MeasureRecord record;
        MetadataProviderBase.validateRequiredRestrictions(MetadataOperation.MEASURES, restrictions);
        String catalogRes = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String schemaRes = (String)restrictions.getValueOf(RestrictionType.SCHEMA);
        String cubeRes = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String measureNameRes = (String)restrictions.getValueOf(RestrictionType.MEASURE);
        String measureGroupNameRes = (String)restrictions.getValueOf(RestrictionType.MEASUREGROUP_NAME);
        String measureUniqueNameRes = (String)restrictions.getValueOf(RestrictionType.MEASURE_UNIQUE_NAME);
        EnumSet treeOps = (EnumSet)restrictions.getValueOf(RestrictionType.TREEOP);
        int fromRes = restrictions.getValueOf(RestrictionType.FROM, 0);
        int sizeRes = restrictions.getValueOf(RestrictionType.SIZE, Integer.MAX_VALUE);
        List<MeasureRecord> result = null;
        List<MeasureRecord> allMeasures = null;
        boolean fetchAll = false;
        boolean skipSelf = false;
        if (treeOps != null) {
            if (!treeOps.contains((Object)TreeOperatorEnum.SELF) && !treeOps.contains((Object)TreeOperatorEnum.SIBLINGS)) {
                result = Collections.emptyList();
                return result;
            }
            if (treeOps.contains((Object)TreeOperatorEnum.SIBLINGS)) {
                fetchAll = true;
                if (treeOps.size() == 1) {
                    skipSelf = true;
                }
            }
        }
        if (null != measureUniqueNameRes && !fetchAll && !skipSelf && null != (record = cache.getMeasure(catalogRes, cubeRes, measureUniqueNameRes))) {
            result = new ArrayList<MeasureRecord>(1);
            if (sizeRes > 0 && fromRes == 0) {
                result.add(record);
            }
            return result;
        }
        allMeasures = cache.getAllMeasuresForCube(catalogRes, cubeRes);
        if (null == allMeasures) {
            return null;
        }
        result = new ArrayList<MeasureRecord>(Math.min(sizeRes, allMeasures.size()));
        int i = 0;
        for (MeasureRecord record2 : allMeasures) {
            if (i - fromRes >= sizeRes) break;
            if (null != catalogRes && !InMemoryOLAPMetadataCache.equalTo(record2.getCatalogName(), catalogRes) || null != schemaRes && !InMemoryOLAPMetadataCache.equalTo(record2.getSchemaName(), schemaRes) || null != cubeRes && !InMemoryOLAPMetadataCache.equalTo(record2.getCubeName(), cubeRes) || null != measureNameRes && !InMemoryOLAPMetadataCache.equalTo(record2.getName(), measureNameRes) || null != measureGroupNameRes && !InMemoryOLAPMetadataCache.equalTo(record2.getMeasureFolder(), measureGroupNameRes) || null != measureUniqueNameRes && (skipSelf && InMemoryOLAPMetadataCache.equalTo(record2.getUniqueName(), measureUniqueNameRes) || !fetchAll && !InMemoryOLAPMetadataCache.equalTo(record2.getUniqueName(), measureUniqueNameRes))) continue;
            if (i < fromRes) {
                ++i;
                continue;
            }
            result.add(record2);
            ++i;
        }
        return result;
    }

    private List<PropertyRecord> getProperties(RootCache cache, IRestrictions restrictions) {
        MetadataProviderBase.validateRequiredRestrictions(MetadataOperation.PROPERTIES, restrictions);
        String catalogRes = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String schemaRes = (String)restrictions.getValueOf(RestrictionType.SCHEMA);
        String cubeRes = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String propNameRes = (String)restrictions.getValueOf(RestrictionType.PROPERTY);
        String hierarchyUniqueNameRes = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        String dimensionUniqueNameRes = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String levelUniqueNameRes = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME);
        ArrayList<PropertyRecord> result = null;
        List<PropertyRecord> allProperties = null;
        boolean fetchAll = false;
        allProperties = cache.getAllPropertiesForCube(catalogRes, cubeRes);
        if (null == allProperties) {
            return null;
        }
        result = new ArrayList<PropertyRecord>(allProperties.size());
        for (PropertyRecord record : allProperties) {
            if (null != catalogRes && !InMemoryOLAPMetadataCache.equalTo(record.getCatalogName(), catalogRes) || null != schemaRes && !InMemoryOLAPMetadataCache.equalTo(record.getSchemaName(), schemaRes) || null != cubeRes && !InMemoryOLAPMetadataCache.equalTo(record.getCubeName(), cubeRes) || null != record.getDimensionUniqueName() && record.getDimensionUniqueName().length() > 0 && null != record.getHierarchyUniqueName() && record.getHierarchyUniqueName().length() > 0 && null == record.getLevelUniqueName() && null != levelUniqueNameRes || null != dimensionUniqueNameRes && null != record.getDimensionUniqueName() && record.getDimensionUniqueName().length() > 0 && !InMemoryOLAPMetadataCache.equalTo(record.getDimensionUniqueName(), dimensionUniqueNameRes) || null != hierarchyUniqueNameRes && null != record.getHierarchyUniqueName() && record.getHierarchyUniqueName().length() > 0 && !InMemoryOLAPMetadataCache.equalTo(record.getHierarchyUniqueName(), hierarchyUniqueNameRes) || null != levelUniqueNameRes && null != record.getLevelUniqueName() && record.getLevelUniqueName().length() > 0 && !InMemoryOLAPMetadataCache.equalTo(record.getLevelUniqueName(), levelUniqueNameRes) || null != propNameRes && !fetchAll && !InMemoryOLAPMetadataCache.equalTo(record.getUniqueName(), propNameRes)) continue;
            result.add(record);
        }
        return result;
    }

    private List<LevelRecord> getLevels(RootCache cache, IRestrictions restrictions) {
        LevelRecord record;
        MetadataProviderBase.validateRequiredRestrictions(MetadataOperation.LEVELS, restrictions);
        String catalogRes = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String schemaRes = (String)restrictions.getValueOf(RestrictionType.SCHEMA);
        String cubeRes = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String dunRes = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String hunRes = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        String lunRes = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME);
        int levelNumberRes = restrictions.getValueOf(RestrictionType.LEVEL_NUMBER, -1);
        int fromRes = restrictions.getValueOf(RestrictionType.FROM, 0);
        int sizeRes = restrictions.getValueOf(RestrictionType.SIZE, Integer.MAX_VALUE);
        ArrayList<LevelRecord> result = null;
        List<LevelRecord> allLevels = null;
        if (null != lunRes && null != (record = cache.getLevel(catalogRes, cubeRes, lunRes))) {
            result = new ArrayList<LevelRecord>(1);
            if (sizeRes > 0 && fromRes == 0) {
                result.add(record);
            }
            return result;
        }
        if (null != hunRes) {
            allLevels = cache.getAllLevelsForHierarchy(catalogRes, cubeRes, hunRes);
        }
        if (null == allLevels) {
            return null;
        }
        result = new ArrayList(Math.min(sizeRes, allLevels.size()));
        int i = 0;
        for (LevelRecord record2 : allLevels) {
            if (i - fromRes >= sizeRes) break;
            if (null != catalogRes && !InMemoryOLAPMetadataCache.equalTo(record2.getCatalogName(), catalogRes) || null != schemaRes && !InMemoryOLAPMetadataCache.equalTo(record2.getSchemaName(), schemaRes) || null != cubeRes && !InMemoryOLAPMetadataCache.equalTo(record2.getCubeName(), cubeRes) || null != dunRes && !InMemoryOLAPMetadataCache.equalTo(record2.getDimensionUniqueName(), dunRes) || null != hunRes && !InMemoryOLAPMetadataCache.equalTo(record2.getHierarchyUniqueName(), hunRes) || null != lunRes && !InMemoryOLAPMetadataCache.equalTo(record2.getUniqueName(), lunRes) || -1 != levelNumberRes && record2.getLevelNumber() != levelNumberRes) continue;
            if (i < fromRes) {
                ++i;
                continue;
            }
            result.add(record2);
            ++i;
        }
        return result;
    }

    private List<HierarchyRecord> getHierarchies(RootCache cache, IRestrictions restrictions) {
        HierarchyRecord record;
        MetadataProviderBase.validateRequiredRestrictions(MetadataOperation.HIERARCHIES, restrictions);
        String catalogRes = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String schemaRes = (String)restrictions.getValueOf(RestrictionType.SCHEMA);
        String cubeRes = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String dunRes = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String hunRes = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        int fromRes = restrictions.getValueOf(RestrictionType.FROM, 0);
        int sizeRes = restrictions.getValueOf(RestrictionType.SIZE, Integer.MAX_VALUE);
        ArrayList<HierarchyRecord> result = null;
        List<HierarchyRecord> allHiers = null;
        if (null != hunRes && null != (record = cache.getHierarchy(catalogRes, cubeRes, hunRes))) {
            result = new ArrayList<HierarchyRecord>(1);
            if (sizeRes > 0 && fromRes == 0) {
                result.add(record);
            }
            return result;
        }
        if (null != dunRes) {
            allHiers = cache.getAllHierarchiesForDimension(catalogRes, cubeRes, dunRes);
        }
        if (null == allHiers) {
            return null;
        }
        result = new ArrayList(Math.min(sizeRes, allHiers.size()));
        int i = 0;
        for (HierarchyRecord record2 : allHiers) {
            if (i - fromRes >= sizeRes) break;
            if (null != catalogRes && !InMemoryOLAPMetadataCache.equalTo(record2.getCatalogName(), catalogRes) || null != schemaRes && !InMemoryOLAPMetadataCache.equalTo(record2.getSchemaName(), schemaRes) || null != cubeRes && !InMemoryOLAPMetadataCache.equalTo(record2.getCubeName(), cubeRes) || null != dunRes && !InMemoryOLAPMetadataCache.equalTo(record2.getDimensionUniqueName(), dunRes) || null != hunRes && !InMemoryOLAPMetadataCache.equalTo(record2.getUniqueName(), hunRes)) continue;
            if (i < fromRes) {
                ++i;
                continue;
            }
            result.add(record2);
            ++i;
        }
        return result;
    }

    private List<DimensionRecord> getDimensions(RootCache cache, IRestrictions restrictions) {
        DimensionRecord record;
        MetadataProviderBase.validateRequiredRestrictions(MetadataOperation.DIMENSIONS, restrictions);
        String catalogRes = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String schemaRes = (String)restrictions.getValueOf(RestrictionType.SCHEMA);
        String cubeRes = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String dunRes = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        int fromRes = restrictions.getValueOf(RestrictionType.FROM, 0);
        int sizeRes = restrictions.getValueOf(RestrictionType.SIZE, Integer.MAX_VALUE);
        ArrayList<DimensionRecord> result = null;
        if (null != dunRes && null != (record = cache.getDimension(catalogRes, cubeRes, dunRes))) {
            result = new ArrayList<DimensionRecord>(1);
            if (sizeRes > 0 && fromRes == 0) {
                result.add(record);
            }
            return result;
        }
        List<DimensionRecord> allDims = cache.getAllDimensionsForCube(catalogRes, cubeRes);
        if (null == allDims) {
            return null;
        }
        result = new ArrayList(Math.min(sizeRes, allDims.size()));
        int i = 0;
        for (DimensionRecord record2 : allDims) {
            if (i - fromRes >= sizeRes) break;
            if (null != catalogRes && !InMemoryOLAPMetadataCache.equalTo(record2.getCatalogName(), catalogRes) || null != schemaRes && !InMemoryOLAPMetadataCache.equalTo(record2.getSchemaName(), schemaRes) || null != cubeRes && !InMemoryOLAPMetadataCache.equalTo(record2.getCubeName(), cubeRes) || null != dunRes && !InMemoryOLAPMetadataCache.equalTo(record2.getUniqueName(), dunRes)) continue;
            if (i < fromRes) {
                ++i;
                continue;
            }
            result.add(record2);
            ++i;
        }
        return result;
    }

    private List<CubeRecord> getCubes(RootCache cache, IRestrictions restrictions) {
        CubeRecord record;
        MetadataProviderBase.validateRequiredRestrictions(MetadataOperation.CUBES, restrictions);
        String catalogRes = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String schemaRes = (String)restrictions.getValueOf(RestrictionType.SCHEMA);
        String cubeRes = (String)restrictions.getValueOf(RestrictionType.CUBE);
        int fromRes = restrictions.getValueOf(RestrictionType.FROM, 0);
        int sizeRes = restrictions.getValueOf(RestrictionType.SIZE, Integer.MAX_VALUE);
        ArrayList<CubeRecord> result = null;
        if (null != cubeRes && null != (record = cache.getCube(catalogRes, cubeRes))) {
            result = new ArrayList<CubeRecord>(1);
            if (sizeRes > 0 && fromRes == 0) {
                result.add(record);
            }
            return result;
        }
        List<CubeRecord> allCubes = cache.getAllCubesForCatalog(catalogRes);
        if (null == allCubes) {
            return null;
        }
        result = new ArrayList(Math.min(sizeRes, allCubes.size()));
        int i = 0;
        for (CubeRecord record2 : allCubes) {
            if (i - fromRes >= sizeRes) break;
            if (null != catalogRes && !InMemoryOLAPMetadataCache.equalTo(record2.getCatalogName(), catalogRes) || null != schemaRes && !InMemoryOLAPMetadataCache.equalTo(record2.getSchemaName(), schemaRes) || null != cubeRes && !InMemoryOLAPMetadataCache.equalTo(record2.getName(), cubeRes)) continue;
            if (i < fromRes) {
                ++i;
                continue;
            }
            result.add(record2);
            ++i;
        }
        return result;
    }

    private List<CatalogRecord> getCatalogs(RootCache cache, IRestrictions restrictions) {
        CatalogRecord record;
        MetadataProviderBase.validateRequiredRestrictions(MetadataOperation.CATALOGS, restrictions);
        String catalogRes = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        int fromRes = restrictions.getValueOf(RestrictionType.FROM, 0);
        int sizeRes = restrictions.getValueOf(RestrictionType.SIZE, Integer.MAX_VALUE);
        ArrayList<CatalogRecord> result = null;
        if (null != catalogRes && null != (record = cache.getCatalog(catalogRes))) {
            result = new ArrayList<CatalogRecord>(1);
            if (sizeRes > 0 && fromRes == 0) {
                result.add(record);
            }
            return result;
        }
        List<CatalogRecord> allCatalogs = cache.getAllCatalogs();
        if (null == allCatalogs) {
            return null;
        }
        result = new ArrayList(Math.min(sizeRes, allCatalogs.size()));
        int i = 0;
        for (CatalogRecord record2 : allCatalogs) {
            if (i - fromRes >= sizeRes) break;
            if (null != catalogRes && !InMemoryOLAPMetadataCache.equalTo(record2.getName(), catalogRes)) continue;
            if (i < fromRes) {
                ++i;
                continue;
            }
            result.add(record2);
            ++i;
        }
        return result;
    }

    @Override
    public <T extends MetadataRecord> void putMetadataImpl(MetadataOperation operation, IRestrictions restrictions, List<T> records) {
        switch (operation) {
            case ACTIONS: {
                break;
            }
            case ALIASES: {
                break;
            }
            case CATALOGS: {
                this.putCatalogs(this.rootCache, restrictions, records);
                break;
            }
            case CUBES: {
                this.putCubes(this.rootCache, restrictions, records);
                break;
            }
            case DIMENSIONS: {
                this.putDimensions(this.rootCache, restrictions, records);
                break;
            }
            case HIERARCHIES: {
                this.putHierarchies(this.rootCache, restrictions, records);
                break;
            }
            case HIERARCHYROOTMEMBERS: {
                this.putHierarchyRootMembers(this.rootCache, restrictions, records);
                break;
            }
            case LEVELS: {
                this.putLevels(this.rootCache, restrictions, records);
                break;
            }
            case MACROS: {
                break;
            }
            case MEASURES: {
                this.putMeasures(this.rootCache, restrictions, records);
                break;
            }
            case MEMBERS: {
                break;
            }
            case NAMEDSETMEMBERS: {
                break;
            }
            case NAMEDSETLEVELUNIQUENAMES: {
                break;
            }
            case NAMEDSETS: {
                break;
            }
            case HIERARCHYNAMEDSETS: {
                break;
            }
            case PROPERTIES: {
                this.putProperties(this.rootCache, restrictions, records);
                break;
            }
            case VARIABLES: {
                break;
            }
        }
    }

    private void putMeasures(RootCache cache, IRestrictions restrictions, List<MeasureRecord> records) {
        String catalogRes = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String cubeRes = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String munRes = (String)restrictions.getValueOf(RestrictionType.MEASURE_UNIQUE_NAME);
        EnumSet treeOps = (EnumSet)restrictions.getValueOf(RestrictionType.TREEOP);
        int fromRes = restrictions.getValueOf(RestrictionType.FROM, 0);
        int sizeRes = restrictions.getValueOf(RestrictionType.SIZE, Integer.MAX_VALUE);
        boolean putAll = false;
        boolean skipSelf = false;
        if (treeOps != null) {
            if (!treeOps.contains((Object)TreeOperatorEnum.SELF) && !treeOps.contains((Object)TreeOperatorEnum.SIBLINGS)) {
                return;
            }
            if (treeOps.contains((Object)TreeOperatorEnum.SIBLINGS)) {
                putAll = true;
                if (treeOps.size() == 1) {
                    skipSelf = true;
                }
            }
        } else if (null == munRes) {
            putAll = true;
        }
        if (0 != fromRes || Integer.MAX_VALUE != sizeRes) {
            putAll = false;
        }
        if (putAll && !skipSelf) {
            cache.putAllMeasuresForCube(catalogRes, cubeRes, records);
        } else {
            for (MeasureRecord record : records) {
                cache.putMeasure(record);
            }
        }
    }

    private void putProperties(RootCache cache, IRestrictions restrictions, List<PropertyRecord> records) {
        String catalogRes = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String cubeRes = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String propertyRes = (String)restrictions.getValueOf(RestrictionType.PROPERTY);
        String hierRes = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        String dimRes = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String levelRes = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME);
        int fromRes = restrictions.getValueOf(RestrictionType.FROM, 0);
        int sizeRes = restrictions.getValueOf(RestrictionType.SIZE, Integer.MAX_VALUE);
        boolean putAll = false;
        if (null == propertyRes && null == hierRes && null == dimRes && null == levelRes) {
            putAll = true;
        }
        if (0 != fromRes || Integer.MAX_VALUE != sizeRes) {
            putAll = false;
        }
        if (putAll) {
            cache.putAllPropertiesForCube(catalogRes, cubeRes, records);
        } else if (null != records) {
            for (PropertyRecord record : records) {
                cache.putProperty(record);
            }
        }
    }

    private void putLevels(RootCache cache, IRestrictions restrictions, List<LevelRecord> records) {
        String catalogRes = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String cubeRes = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String dunRes = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String hunRes = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        String lunRes = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME);
        int levelNumberRes = restrictions.getValueOf(RestrictionType.LEVEL_NUMBER, -1);
        int fromRes = restrictions.getValueOf(RestrictionType.FROM, 0);
        int sizeRes = restrictions.getValueOf(RestrictionType.SIZE, Integer.MAX_VALUE);
        if (null != lunRes || -1 != levelNumberRes || 0 != fromRes || Integer.MAX_VALUE != sizeRes) {
            for (LevelRecord record : records) {
                cache.putLevel(record);
            }
        } else if (null != hunRes) {
            cache.putAllLevelsForHierarchy(catalogRes, cubeRes, hunRes, records);
        } else if (null != dunRes) {
            HashMap<String, LinkedList<LevelRecord>> levelsForHierMap = new HashMap<String, LinkedList<LevelRecord>>();
            for (LevelRecord levelRecord : records) {
                LinkedList<LevelRecord> levels = (LinkedList<LevelRecord>)levelsForHierMap.get(levelRecord.getHierarchyUniqueName());
                if (null == levels) {
                    levels = new LinkedList<LevelRecord>();
                    levelsForHierMap.put(levelRecord.getHierarchyUniqueName(), levels);
                }
                levels.add(levelRecord);
            }
            for (Map.Entry entry : levelsForHierMap.entrySet()) {
                cache.putAllLevelsForHierarchy(catalogRes, cubeRes, (String)entry.getKey(), (List)entry.getValue());
            }
        } else {
            LinkedList<LevelRecord> levels;
            HashMap<String, LinkedList<LevelRecord>> levelsForDimMap = new HashMap<String, LinkedList<LevelRecord>>();
            for (LevelRecord levelRecord : records) {
                levels = (LinkedList<LevelRecord>)levelsForDimMap.get(levelRecord.getDimensionUniqueName());
                if (null == levels) {
                    levels = new LinkedList<LevelRecord>();
                    levelsForDimMap.put(levelRecord.getDimensionUniqueName(), levels);
                }
                levels.add(levelRecord);
            }
            for (String string : levelsForDimMap.keySet()) {
                levels = (List)levelsForDimMap.get(string);
                IRestrictions newRestrictions = restrictions.duplicate();
                newRestrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, string);
                this.putLevels(cache, newRestrictions, levels);
            }
        }
    }

    private void putHierarchyRootMembers(RootCache cache, IRestrictions restrictions, List<MemberRecord> records) {
        String catalogRes = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String cubeRes = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String hunRes = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        cache.putHierarchyRootMembers(catalogRes, cubeRes, hunRes, records);
    }

    private void putHierarchies(RootCache cache, IRestrictions restrictions, List<HierarchyRecord> records) {
        String catalogRes = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String cubeRes = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String dunRes = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String hunRes = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        int fromRes = restrictions.getValueOf(RestrictionType.FROM, 0);
        int sizeRes = restrictions.getValueOf(RestrictionType.SIZE, Integer.MAX_VALUE);
        if (null != hunRes || 0 != fromRes || Integer.MAX_VALUE != sizeRes) {
            for (HierarchyRecord record : records) {
                cache.putHierarchy(record);
            }
        } else if (null != dunRes) {
            cache.putAllHierarchiesForDimension(catalogRes, cubeRes, dunRes, records);
        } else {
            LinkedList<HierarchyRecord> hiers;
            HashMap<String, LinkedList<HierarchyRecord>> hiersForDimMap = new HashMap<String, LinkedList<HierarchyRecord>>();
            for (HierarchyRecord record : records) {
                hiers = (LinkedList<HierarchyRecord>)hiersForDimMap.get(record.getDimensionUniqueName());
                if (null == hiers) {
                    hiers = new LinkedList<HierarchyRecord>();
                    hiersForDimMap.put(record.getDimensionUniqueName(), hiers);
                }
                hiers.add(record);
            }
            for (String dun : hiersForDimMap.keySet()) {
                hiers = (List)hiersForDimMap.get(dun);
                cache.putAllHierarchiesForDimension(catalogRes, cubeRes, dun, hiers);
            }
        }
    }

    private void putDimensions(RootCache cache, IRestrictions restrictions, List<DimensionRecord> records) {
        String catalogRes = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String cubeRes = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String dunRes = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        int fromRes = restrictions.getValueOf(RestrictionType.FROM, 0);
        int sizeRes = restrictions.getValueOf(RestrictionType.SIZE, Integer.MAX_VALUE);
        if (null != dunRes || 0 != fromRes || Integer.MAX_VALUE != sizeRes) {
            for (DimensionRecord record : records) {
                cache.putDimension(record);
            }
        } else {
            cache.putAllDimensionsForCube(catalogRes, cubeRes, records);
        }
    }

    private void putCubes(RootCache cache, IRestrictions restrictions, List<CubeRecord> records) {
        String catalogRes = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String cubeRes = (String)restrictions.getValueOf(RestrictionType.CUBE);
        int fromRes = restrictions.getValueOf(RestrictionType.FROM, 0);
        int sizeRes = restrictions.getValueOf(RestrictionType.SIZE, Integer.MAX_VALUE);
        if (null != cubeRes || 0 != fromRes || Integer.MAX_VALUE != sizeRes) {
            for (CubeRecord record : records) {
                cache.putCube(record);
            }
        } else {
            cache.putAllCubesForCatalog(catalogRes, records);
        }
    }

    private void putCatalogs(RootCache cache, IRestrictions restrictions, List<CatalogRecord> records) {
        String catalogRes = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        int fromRes = restrictions.getValueOf(RestrictionType.FROM, 0);
        int sizeRes = restrictions.getValueOf(RestrictionType.SIZE, Integer.MAX_VALUE);
        if (null != catalogRes || 0 != fromRes || Integer.MAX_VALUE != sizeRes) {
            for (CatalogRecord record : records) {
                cache.putCatalog(record);
            }
        } else {
            cache.putAllCatalogs(records);
        }
    }

    private static boolean equalTo(Object obj1, Object obj2) {
        if (null == obj1) {
            return null == obj2;
        }
        return obj1 == obj2 || obj1.equals(obj2);
    }

    public static final class CubeCache {
        private volatile CubeRecord cube = null;
        private final Map<String, MeasureRecord> measureNameCache = new TreeMap<String, MeasureRecord>();
        private final ReadWriteLock measureNameCacheLock = new ReentrantReadWriteLock();
        private final Map<String, PropertyRecord> propertyNameCache = new TreeMap<String, PropertyRecord>();
        private final ReadWriteLock propertyNameCacheLock = new ReentrantReadWriteLock();
        private final Map<String, DimensionRecord> dunCache = new TreeMap<String, DimensionRecord>();
        private final ReadWriteLock dunCacheLock = new ReentrantReadWriteLock();
        private final Map<String, HierarchyRecord> hunCache = new TreeMap<String, HierarchyRecord>();
        private final ReadWriteLock hunCacheLock = new ReentrantReadWriteLock();
        private final Map<String, LevelRecord> lunCache = new TreeMap<String, LevelRecord>();
        private final ReadWriteLock lunCacheLock = new ReentrantReadWriteLock();
        private final Map<String, MemberRecord> munCache = new TreeMap<String, MemberRecord>();
        private final ReadWriteLock munCacheLock = new ReentrantReadWriteLock();
        private volatile List<DimensionRecord> allDimensions = null;
        private volatile List<MeasureRecord> allMeasures = null;
        private volatile List<PropertyRecord> allProperties = null;
        private final Map<String, List<HierarchyRecord>> allHierarchies = new TreeMap<String, List<HierarchyRecord>>();
        private final ReadWriteLock allHierarchiesLock = new ReentrantReadWriteLock();
        private final Map<String, List<LevelRecord>> allLevels = new TreeMap<String, List<LevelRecord>>();
        private final ReadWriteLock allLevelsLock = new ReentrantReadWriteLock();
        private final Map<String, List<MemberRecord>> hierarchyRootMembers = new TreeMap<String, List<MemberRecord>>();
        private final ReadWriteLock hierarchyRootMembersLock = new ReentrantReadWriteLock();

        public CubeRecord getCube() {
            return this.cube;
        }

        public void putCube(CubeRecord record) {
            this.cube = record;
        }

        public List<DimensionRecord> getAllDimensions() {
            return this.allDimensions;
        }

        public List<HierarchyRecord> getAllHierarchiesForDimension(String dun) {
            this.allHierarchiesLock.readLock().lock();
            try {
                List<HierarchyRecord> list = this.allHierarchies.get(dun);
                return list;
            }
            finally {
                this.allHierarchiesLock.readLock().unlock();
            }
        }

        public List<LevelRecord> getAllLevelsForHierarchy(String hun) {
            this.allLevelsLock.readLock().lock();
            try {
                List<LevelRecord> list = this.allLevels.get(hun);
                return list;
            }
            finally {
                this.allLevelsLock.readLock().unlock();
            }
        }

        public List<MemberRecord> getHierarchyRootMembers(String hun) {
            this.hierarchyRootMembersLock.readLock().lock();
            try {
                List<MemberRecord> list = this.hierarchyRootMembers.get(hun);
                return list;
            }
            finally {
                this.hierarchyRootMembersLock.readLock().unlock();
            }
        }

        public List<MeasureRecord> getAllMeasures() {
            return this.allMeasures;
        }

        public List<PropertyRecord> getAllProperties() {
            return this.allProperties;
        }

        public DimensionRecord getDimension(String dun) {
            this.dunCacheLock.readLock().lock();
            try {
                DimensionRecord dimensionRecord = this.dunCache.get(dun);
                return dimensionRecord;
            }
            finally {
                this.dunCacheLock.readLock().unlock();
            }
        }

        public HierarchyRecord getHierarchy(String hun) {
            this.hunCacheLock.readLock().lock();
            try {
                HierarchyRecord hierarchyRecord = this.hunCache.get(hun);
                return hierarchyRecord;
            }
            finally {
                this.hunCacheLock.readLock().unlock();
            }
        }

        public LevelRecord getLevel(String lun) {
            this.lunCacheLock.readLock().lock();
            try {
                LevelRecord levelRecord = this.lunCache.get(lun);
                return levelRecord;
            }
            finally {
                this.lunCacheLock.readLock().unlock();
            }
        }

        public MemberRecord getMember(String mun) {
            this.munCacheLock.readLock().lock();
            try {
                MemberRecord memberRecord = this.munCache.get(mun);
                return memberRecord;
            }
            finally {
                this.munCacheLock.readLock().unlock();
            }
        }

        public MeasureRecord getMeasure(String measureName) {
            this.measureNameCacheLock.readLock().lock();
            try {
                MeasureRecord measureRecord = this.measureNameCache.get(measureName);
                return measureRecord;
            }
            finally {
                this.measureNameCacheLock.readLock().unlock();
            }
        }

        public PropertyRecord getProperty(String propertyName) {
            this.propertyNameCacheLock.readLock().lock();
            try {
                PropertyRecord propertyRecord = this.propertyNameCache.get(propertyName);
                return propertyRecord;
            }
            finally {
                this.propertyNameCacheLock.readLock().unlock();
            }
        }

        public void putAllDimensions(List<DimensionRecord> records) {
            this.allDimensions = records;
            for (DimensionRecord record : records) {
                this.putDimension(record);
            }
        }

        public void putAllHierarchiesForDimension(String dun, List<HierarchyRecord> records) {
            this.allHierarchiesLock.writeLock().lock();
            try {
                this.allHierarchies.put(dun, records);
            }
            finally {
                this.allHierarchiesLock.writeLock().unlock();
            }
            for (HierarchyRecord record : records) {
                this.putHierarchy(record);
            }
        }

        public void putAllLevelsForHierarchy(String hun, List<LevelRecord> records) {
            this.allLevelsLock.writeLock().lock();
            try {
                this.allLevels.put(hun, records);
            }
            finally {
                this.allLevelsLock.writeLock().unlock();
            }
            for (LevelRecord record : records) {
                this.putLevel(record);
            }
        }

        public void putHierarchyRootMembers(String hun, List<MemberRecord> records) {
            this.hierarchyRootMembersLock.writeLock().lock();
            try {
                this.hierarchyRootMembers.put(hun, records);
            }
            finally {
                this.hierarchyRootMembersLock.writeLock().unlock();
            }
        }

        public void putAllMeasures(List<MeasureRecord> records) {
            this.allMeasures = records;
            for (MeasureRecord record : records) {
                this.putMeasure(record);
            }
        }

        public void putAllProperties(List<PropertyRecord> records) {
            this.allProperties = records;
            for (PropertyRecord record : records) {
                this.putProperty(record);
            }
        }

        public void putDimension(DimensionRecord record) {
            this.dunCacheLock.writeLock().lock();
            try {
                this.dunCache.put(record.getUniqueName(), record);
            }
            finally {
                this.dunCacheLock.writeLock().unlock();
            }
        }

        public void putHierarchy(HierarchyRecord record) {
            this.hunCacheLock.writeLock().lock();
            try {
                this.hunCache.put(record.getUniqueName(), record);
            }
            finally {
                this.hunCacheLock.writeLock().unlock();
            }
        }

        public void putLevel(LevelRecord record) {
            this.lunCacheLock.writeLock().lock();
            try {
                this.lunCache.put(record.getUniqueName(), record);
            }
            finally {
                this.lunCacheLock.writeLock().unlock();
            }
        }

        public void putMember(MemberRecord record) {
            this.munCacheLock.writeLock().lock();
            try {
                this.munCache.put(record.getUniqueName(), record);
            }
            finally {
                this.munCacheLock.writeLock().unlock();
            }
        }

        public void putMeasure(MeasureRecord record) {
            this.measureNameCacheLock.writeLock().lock();
            try {
                this.measureNameCache.put(record.getUniqueName(), record);
            }
            finally {
                this.measureNameCacheLock.writeLock().unlock();
            }
        }

        public void putProperty(PropertyRecord record) {
            this.propertyNameCacheLock.writeLock().lock();
            try {
                this.propertyNameCache.put(record.getUniqueName(), record);
            }
            finally {
                this.propertyNameCacheLock.writeLock().unlock();
            }
        }
    }

    public static final class CatalogCache {
        private volatile CatalogRecord catalog = null;
        private volatile List<CubeRecord> allCubes = null;
        private final Map<String, CubeCache> cubeCaches = new TreeMap<String, CubeCache>();
        private final ReadWriteLock cubeCachesLock = new ReentrantReadWriteLock();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CubeCache getCubeCache(String cubeName) {
            CubeCache result = null;
            this.cubeCachesLock.readLock().lock();
            try {
                result = this.cubeCaches.get(cubeName);
            }
            finally {
                this.cubeCachesLock.readLock().unlock();
            }
            if (null != result) {
                return result;
            }
            this.cubeCachesLock.writeLock().lock();
            try {
                result = this.cubeCaches.get(cubeName);
                if (null != result) {
                    CubeCache cubeCache = result;
                    return cubeCache;
                }
                result = new CubeCache();
                this.cubeCaches.put(cubeName, result);
            }
            finally {
                this.cubeCachesLock.writeLock().unlock();
            }
            return result;
        }

        public CatalogRecord getCatalog() {
            return this.catalog;
        }

        public void putCatalog(CatalogRecord record) {
            this.catalog = record;
        }

        public List<CubeRecord> getAllCubes() {
            return this.allCubes;
        }

        public List<DimensionRecord> getAllDimensionsForCube(String cubeName) {
            CubeCache cache = this.getCubeCache(cubeName);
            return cache.getAllDimensions();
        }

        public List<HierarchyRecord> getAllHierarchiesForDimension(String cubeName, String dun) {
            CubeCache cache = this.getCubeCache(cubeName);
            return cache.getAllHierarchiesForDimension(dun);
        }

        public List<LevelRecord> getAllLevelsForHierarchy(String cubeName, String hun) {
            CubeCache cache = this.getCubeCache(cubeName);
            return cache.getAllLevelsForHierarchy(hun);
        }

        public List<MemberRecord> getHierarchyRootMembers(String cubeName, String hun) {
            CubeCache cache = this.getCubeCache(cubeName);
            return cache.getHierarchyRootMembers(hun);
        }

        public List<MeasureRecord> getAllMeasuresForCube(String cubeName) {
            CubeCache cache = this.getCubeCache(cubeName);
            return cache.getAllMeasures();
        }

        public List<PropertyRecord> getAllPropertiesForCube(String cubeName) {
            CubeCache cache = this.getCubeCache(cubeName);
            return cache.getAllProperties();
        }

        public CubeRecord getCube(String cubeName) {
            CubeCache cache = this.getCubeCache(cubeName);
            return cache.getCube();
        }

        public DimensionRecord getDimension(String cubeName, String dun) {
            CubeCache cache = this.getCubeCache(cubeName);
            return cache.getDimension(dun);
        }

        public HierarchyRecord getHierarchy(String cubeName, String hun) {
            CubeCache cache = this.getCubeCache(cubeName);
            return cache.getHierarchy(hun);
        }

        public LevelRecord getLevel(String cubeName, String lun) {
            CubeCache cache = this.getCubeCache(cubeName);
            return cache.getLevel(lun);
        }

        public MemberRecord getMember(String cubeName, String mun) {
            CubeCache cache = this.getCubeCache(cubeName);
            return cache.getMember(mun);
        }

        public MeasureRecord getMeasure(String cubeName, String measureName) {
            CubeCache cache = this.getCubeCache(cubeName);
            return cache.getMeasure(measureName);
        }

        public PropertyRecord getProperty(String cubeName, String propertyName) {
            CubeCache cache = this.getCubeCache(cubeName);
            return cache.getProperty(propertyName);
        }

        public void putAllCubes(List<CubeRecord> records) {
            this.allCubes = records;
            for (CubeRecord record : records) {
                this.putCube(record);
            }
        }

        public void putAllDimensionsForCube(String cubeName, List<DimensionRecord> records) {
            CubeCache cache = this.getCubeCache(cubeName);
            cache.putAllDimensions(records);
        }

        public void putAllHierarchiesForDimension(String cubeName, String dun, List<HierarchyRecord> records) {
            CubeCache cache = this.getCubeCache(cubeName);
            cache.putAllHierarchiesForDimension(dun, records);
        }

        public void putAllLevelsForHierarchy(String cubeName, String hun, List<LevelRecord> records) {
            CubeCache cache = this.getCubeCache(cubeName);
            cache.putAllLevelsForHierarchy(hun, records);
        }

        public void putHierarchyRootMembers(String cubeName, String hun, List<MemberRecord> records) {
            CubeCache cache = this.getCubeCache(cubeName);
            cache.putHierarchyRootMembers(hun, records);
        }

        public void putAllMeasuresForCube(String cubeName, List<MeasureRecord> records) {
            CubeCache cache = this.getCubeCache(cubeName);
            cache.putAllMeasures(records);
        }

        public void putAllPropertiesForCube(String cubeName, List<PropertyRecord> records) {
            CubeCache cache = this.getCubeCache(cubeName);
            cache.putAllProperties(records);
        }

        public void putCube(CubeRecord record) {
            CubeCache cache = this.getCubeCache(record.getUniqueName());
            cache.putCube(record);
        }

        public void putDimension(DimensionRecord record) {
            CubeCache cache = this.getCubeCache(record.getCubeName());
            cache.putDimension(record);
        }

        public void putHierarchy(HierarchyRecord record) {
            CubeCache cache = this.getCubeCache(record.getCubeName());
            cache.putHierarchy(record);
        }

        public void putLevel(LevelRecord record) {
            CubeCache cache = this.getCubeCache(record.getCubeName());
            cache.putLevel(record);
        }

        public void putMember(MemberRecord record) {
            CubeCache cache = this.getCubeCache(record.getCubeName());
            cache.putMember(record);
        }

        public void putMeasure(MeasureRecord record) {
            CubeCache cache = this.getCubeCache(record.getCubeName());
            cache.putMeasure(record);
        }

        public void putProperty(PropertyRecord record) {
            CubeCache cache = this.getCubeCache(record.getCubeName());
            cache.putProperty(record);
        }
    }

    public static final class RootCache {
        private volatile List<CatalogRecord> allCatalogs = null;
        private final Map<String, CatalogCache> catalogCaches = new HashMap<String, CatalogCache>();
        private final ReadWriteLock catalogCachesLock = new ReentrantReadWriteLock(false);

        public void clear() {
            this.allCatalogs = null;
            this.catalogCachesLock.writeLock().lock();
            try {
                this.catalogCaches.clear();
            }
            finally {
                this.catalogCachesLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CatalogCache getCatalogCache(String catalogName) {
            CatalogCache result = null;
            this.catalogCachesLock.readLock().lock();
            try {
                result = this.catalogCaches.get(catalogName);
            }
            finally {
                this.catalogCachesLock.readLock().unlock();
            }
            if (null != result) {
                return result;
            }
            this.catalogCachesLock.writeLock().lock();
            try {
                result = this.catalogCaches.get(catalogName);
                if (null != result) {
                    CatalogCache catalogCache = result;
                    return catalogCache;
                }
                result = new CatalogCache();
                this.catalogCaches.put(catalogName, result);
            }
            finally {
                this.catalogCachesLock.writeLock().unlock();
            }
            return result;
        }

        public List<CatalogRecord> getAllCatalogs() {
            return this.allCatalogs;
        }

        public List<CubeRecord> getAllCubesForCatalog(String catalogName) {
            CatalogCache cache = this.getCatalogCache(catalogName);
            return cache.getAllCubes();
        }

        public List<DimensionRecord> getAllDimensionsForCube(String catalogName, String cubeName) {
            CatalogCache cache = this.getCatalogCache(catalogName);
            return cache.getAllDimensionsForCube(cubeName);
        }

        public List<HierarchyRecord> getAllHierarchiesForDimension(String catalogName, String cubeName, String dun) {
            CatalogCache cache = this.getCatalogCache(catalogName);
            return cache.getAllHierarchiesForDimension(cubeName, dun);
        }

        public List<LevelRecord> getAllLevelsForHierarchy(String catalogName, String cubeName, String hun) {
            CatalogCache cache = this.getCatalogCache(catalogName);
            return cache.getAllLevelsForHierarchy(cubeName, hun);
        }

        public List<MemberRecord> getHierarchyRootMembers(String catalogName, String cubeName, String hun) {
            CatalogCache cache = this.getCatalogCache(catalogName);
            return cache.getHierarchyRootMembers(cubeName, hun);
        }

        public List<MeasureRecord> getAllMeasuresForCube(String catalogName, String cubeName) {
            CatalogCache cache = this.getCatalogCache(catalogName);
            return cache.getAllMeasuresForCube(cubeName);
        }

        public List<PropertyRecord> getAllPropertiesForCube(String catalogName, String cubeName) {
            CatalogCache cache = this.getCatalogCache(catalogName);
            return cache.getAllPropertiesForCube(cubeName);
        }

        public CatalogRecord getCatalog(String catalogName) {
            CatalogCache cache = this.getCatalogCache(catalogName);
            return cache.getCatalog();
        }

        public CubeRecord getCube(String catalogName, String cubeName) {
            CatalogCache cache = this.getCatalogCache(catalogName);
            return cache.getCube(cubeName);
        }

        public DimensionRecord getDimension(String catalogName, String cubeName, String dun) {
            CatalogCache cache = this.getCatalogCache(catalogName);
            return cache.getDimension(cubeName, dun);
        }

        public HierarchyRecord getHierarchy(String catalogName, String cubeName, String hun) {
            CatalogCache cache = this.getCatalogCache(catalogName);
            return cache.getHierarchy(cubeName, hun);
        }

        public LevelRecord getLevel(String catalogName, String cubeName, String lun) {
            CatalogCache cache = this.getCatalogCache(catalogName);
            return cache.getLevel(cubeName, lun);
        }

        public MemberRecord getMember(String catalogName, String cubeName, String mun) {
            CatalogCache cache = this.getCatalogCache(catalogName);
            return cache.getMember(cubeName, mun);
        }

        public MeasureRecord getMeasure(String catalogName, String cubeName, String measureName) {
            CatalogCache cache = this.getCatalogCache(catalogName);
            return cache.getMeasure(cubeName, measureName);
        }

        public PropertyRecord getProperty(String catalogName, String cubeName, String propertyName) {
            CatalogCache cache = this.getCatalogCache(catalogName);
            return cache.getProperty(cubeName, propertyName);
        }

        public void putAllCatalogs(List<CatalogRecord> records) {
            this.allCatalogs = records;
        }

        public void putAllCubesForCatalog(String catalogName, List<CubeRecord> records) {
            CatalogCache cache = this.getCatalogCache(catalogName);
            cache.putAllCubes(records);
        }

        public void putAllDimensionsForCube(String catalogName, String cubeName, List<DimensionRecord> records) {
            CatalogCache cache = this.getCatalogCache(catalogName);
            cache.putAllDimensionsForCube(cubeName, records);
        }

        public void putAllHierarchiesForDimension(String catalogName, String cubeName, String dun, List<HierarchyRecord> records) {
            CatalogCache cache = this.getCatalogCache(catalogName);
            cache.putAllHierarchiesForDimension(cubeName, dun, records);
        }

        public void putAllLevelsForHierarchy(String catalogName, String cubeName, String hun, List<LevelRecord> records) {
            CatalogCache cache = this.getCatalogCache(catalogName);
            cache.putAllLevelsForHierarchy(cubeName, hun, records);
        }

        public void putHierarchyRootMembers(String catalogName, String cubeName, String hun, List<MemberRecord> records) {
            CatalogCache cache = this.getCatalogCache(catalogName);
            cache.putHierarchyRootMembers(cubeName, hun, records);
        }

        public void putAllMeasuresForCube(String catalogName, String cubeName, List<MeasureRecord> records) {
            CatalogCache cache = this.getCatalogCache(catalogName);
            cache.putAllMeasuresForCube(cubeName, records);
        }

        public void putAllPropertiesForCube(String catalogName, String cubeName, List<PropertyRecord> records) {
            CatalogCache cache = this.getCatalogCache(catalogName);
            cache.putAllPropertiesForCube(cubeName, records);
        }

        public void putCatalog(CatalogRecord record) {
            CatalogCache cache = this.getCatalogCache(record.getName());
            cache.putCatalog(record);
        }

        public void putCube(CubeRecord record) {
            CatalogCache cache = this.getCatalogCache(record.getCatalogName());
            cache.putCube(record);
        }

        public void putDimension(DimensionRecord record) {
            CatalogCache cache = this.getCatalogCache(record.getCatalogName());
            cache.putDimension(record);
        }

        public void putHierarchy(HierarchyRecord record) {
            CatalogCache cache = this.getCatalogCache(record.getCatalogName());
            cache.putHierarchy(record);
        }

        public void putLevel(LevelRecord record) {
            CatalogCache cache = this.getCatalogCache(record.getCatalogName());
            cache.putLevel(record);
        }

        public void putMember(MemberRecord record) {
            CatalogCache cache = this.getCatalogCache(record.getCatalogName());
            cache.putMember(record);
        }

        public void putMeasure(MeasureRecord record) {
            CatalogCache cache = this.getCatalogCache(record.getCatalogName());
            cache.putMeasure(record);
        }

        public void putProperty(PropertyRecord record) {
            CatalogCache cache = this.getCatalogCache(record.getCatalogName());
            cache.putProperty(record);
        }
    }
}

