/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.cache.xindice;

import com.cognos.xqe.cache.transformer.StringToMetadataRecordListTransformer;
import com.cognos.xqe.cache.xindice.XindiceBackedMap;
import com.cognos.xqe.cache.xindice.XindiceCacheManager;
import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.MetadataOperation;
import com.cognos.xqe.data.providers.olap.cache.AbstractOLAPMetadataCache;
import com.cognos.xqe.data.providers.olap.cache.CacheParameters;
import com.cognos.xqe.data.providers.olap.cache.xindice.CacheConfig;
import com.cognos.xqe.data.providers.olap.cache.xindice.XindiceOLAPMetadataCacheFactory;
import com.cognos.xqe.metadata.record.MetadataRecord;
import java.io.Serializable;
import java.util.List;

public class XindiceOLAPMetadataCache
extends AbstractOLAPMetadataCache {
    private final CacheConfig configuration;
    private XindiceBackedMap<String, List<? extends MetadataRecord>> cache;

    XindiceOLAPMetadataCache(XindiceOLAPMetadataCacheFactory theFactory, CacheParameters theParameters, CacheConfig theConfiguration) {
        super(theFactory, theParameters);
        this.configuration = theConfiguration;
        this.initializeCache();
    }

    private void initializeCache() {
        this.cache = XindiceCacheManager.getInstance().getMap(this.configuration.getCacheName(), new StringToMetadataRecordListTransformer(), this.configuration.isPersistent(), this.configuration.getPersistentLifetime(), this.configuration.isAutoFlushed(), this.configuration.isCompressed(), this.configuration.isEncrypted());
        String theVersionId = (String)((Object)XindiceCacheManager.getInstance().getUserData(this.configuration.getCacheName()));
        if (null != theVersionId) {
            this.setVersionId(theVersionId);
        }
    }

    @Override
    public boolean isPersistent() {
        return this.configuration.isPersistent();
    }

    @Override
    public <T extends MetadataRecord> List<T> getMetadataImpl(MetadataOperation operation, IRestrictions restrictions) {
        String key = operation.toString() + restrictions.toString();
        return this.cache.get(key);
    }

    @Override
    public <T extends MetadataRecord> void putMetadataImpl(MetadataOperation operation, IRestrictions restrictions, List<T> records) {
        String key = operation.toString() + restrictions.toString();
        this.cache.putFast(key, records);
    }

    @Override
    public void flushImpl() {
        this.cache.flush();
        if (null != this.getVersionId()) {
            XindiceCacheManager.getInstance().setUserData(this.configuration.getCacheName(), (Serializable)((Object)this.getVersionId()));
        }
    }

    @Override
    protected boolean invalidateImpl(MetadataOperation operation, IRestrictions restrictions) {
        String key = operation.toString() + restrictions.toString();
        return this.cache.removeFast(key);
    }

    @Override
    public void clearImpl() {
        this.cache.clear();
        this.flushImpl();
    }

    @Override
    public void closeImpl() {
        this.flushImpl();
        this.cache.close();
        if (!this.configuration.isPersistent()) {
            XindiceCacheManager.getInstance().removeMap(this.configuration.getCacheName());
        }
    }
}

