/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.qfwbridge;

import com.cognos.xqe.data.providers.qfwbridge.QFWHandle;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.util.LocaleConverter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class QFWObject
implements IReleasable {
    private final QFWObject mParent;
    private final QFWHandle mHandle;
    private final AtomicBoolean mReleased = new AtomicBoolean(false);
    private final Locale mErrorLocale;
    private final List<QFWObject> mChildren = Collections.synchronizedList(new LinkedList());

    public QFWObject(QFWObject parent, byte type, long nativeHandle, Locale errorLocale) {
        this.mParent = parent;
        this.mHandle = new QFWHandle(this, type, nativeHandle);
        this.mErrorLocale = errorLocale;
        if (null != this.mParent) {
            this.mParent.addChild(this);
        }
    }

    public final QFWObject getParent() {
        return this.mParent;
    }

    public final long getNativeHandle() {
        this.assertValidHandle();
        return this.mHandle.getHandle();
    }

    public final long getNativeHandleNoThrow() {
        return this.mHandle.getHandle();
    }

    public final void setNativeHandle(long handle) {
        this.mHandle.setHandle(handle);
    }

    public final Locale getErrorLocale() {
        if (null == this.mErrorLocale) {
            return Locale.ENGLISH;
        }
        return this.mErrorLocale;
    }

    public final String getErrorLanguage() {
        return LocaleConverter.getLanguage(this.getErrorLocale());
    }

    protected final QFWObject[] getChildren() {
        return this.mChildren.toArray(new QFWObject[0]);
    }

    protected final void addChild(QFWObject child) {
        this.assertValidHandle();
        this.mChildren.add(child);
    }

    protected final void removeChild(QFWObject child) {
        this.mChildren.remove(child);
    }

    protected final void assertValidHandle() {
        if (0L == this.mHandle.getHandle()) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Native handle was not initialised. Potential call sequence error.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void release() {
        if (this.mReleased.compareAndSet(false, true)) {
            try {
                QFWObject[] children;
                if (null != this.mParent) {
                    this.mParent.removeChild(this);
                }
                for (QFWObject child : children = this.getChildren()) {
                    child.release();
                }
                this.mHandle.release();
            }
            finally {
                this.mHandle.setHandle(0L);
            }
        }
    }
}

