/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational;

import com.cognos.xqe.ast.QueryFormatter;
import com.cognos.xqe.authentication.AuthenticationType;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.relational.IRelationalConnection;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.function.IProcedure;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import java.sql.Connection;
import java.util.Locale;
import java.util.Map;

public abstract class AbstractConnection
implements IRelationalConnection {
    public static final String UID = "UID";
    public static final String PWD = "PWD";
    public static final String AUTHENTICATION_TYPE = "AUTHENTICATION_TYPE";
    public static final String MIME_TYPE = "MIME_TYPE";
    public static final String URL = "URL";
    public static final String SUBTYPE = "SUBTYPE";
    public static final String APITYPE = "APITYPE";
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String DATA = "DATA";
    public static final String PATH = "PATH";
    public static final String METHOD = "METHOD";
    public static final String SCHEMA = "SCHEMA";
    public static final String ASSEMBLY = "ASSEMBLY";
    public static final String APPLICATION_JSON = "application/json";
    public static final String MAX_PARSED_OBJECTS = "MAX_PARSED_OBJECTS";
    public static final String NUMS_AS_STRINGS = "NUMS_AS_STRINGS";
    public static final String NUMS_AS_DOUBLES = "NUMS_AS_DOUBLES";
    public static final String CLOUDANT = "Cloudant";
    public static final String COUCHDB = "CouchDB";
    public static final String FACEBOOK = "Facebook";
    public static final String GOOGLE_ANALYTICS = "GoogleAnalytics";
    public static final String GOOGLE_PLACES = "GooglePlaces";
    public static final String GOOGLE_PLUS = "Google+";
    public static final String GEO_JSON = "GeoJSON";
    public static final String TWITTER = "Twitter";
    protected IDataSource dataSource;
    protected AuthenticationType authType = AuthenticationType.NONE;

    public IDataSource getDataSource() {
        return this.dataSource;
    }

    public AbstractConnection(IDataSource theDataSource) {
        this.dataSource = theDataSource;
    }

    public AuthenticationType getAuthenticationType() {
        return this.authType;
    }

    public void setAuthenticationType(String authTypeAsStr) {
        this.authType = AuthenticationType.getType(authTypeAsStr);
    }

    public void setDataSource(IDataSource theDataSource) {
        this.dataSource = theDataSource;
    }

    @Override
    public String getDatabaseType() {
        return this.dataSource.getType();
    }

    public IDataSourceCapabilities getCapabilities() {
        return this.dataSource.getCapabilities();
    }

    public abstract void connect(Locale var1) throws XQEException;

    public abstract String getDatabaseCollationSequence();

    public abstract String getConnectionCollationSequence();

    public abstract String getDatabaseCharset();

    public IProcedure getProcedure(String procName, IDataType[] argTypes) {
        throw new UnsupportedOperationException();
    }

    public SQLQueryItemList getMetaData(IExecutionEnvironment environment, IPooledConnection pooledConnection, String query) {
        throw new UnsupportedOperationException();
    }

    public QueryFormatter getQueryBuilder(boolean formatted) {
        throw new UnsupportedOperationException();
    }

    public QueryFormatter getQueryBuilder(String apiType, boolean formatted) {
        throw new UnsupportedOperationException();
    }

    public void augmentQuery(Map<String, Object> props, String apiType, String query) {
        throw new UnsupportedOperationException();
    }

    public String explain(String query) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public Connection getConnection() {
        return null;
    }

    @Override
    public String getDriverClassName() {
        return null;
    }

    @Override
    public String getUrl() {
        return null;
    }

    @Override
    public String getConnectionString() {
        return null;
    }

    @Override
    public String getUserId() {
        return null;
    }
}

