/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational;

import com.cognos.xqe.data.providers.relational.SQLCapabilities;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.TimeType;
import com.cognos.xqe.data.types.TimestampType;
import java.time.LocalDate;
import java.time.Year;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LOCALCastFormatter {
    private static LOCALCastFormatter instance = new LOCALCastFormatter();
    public static final String PLUS_SIGN_STR = "+";
    public static final String MINUS_SIGN_STR = "-";
    public static final String HYPHEN_STR = "-";
    public static final String COLON_STR = ":";
    public static final String DOT_STR = ".";
    public static final String SPACE_STR = " ";
    public static final String EMPTY_STR = "";
    public static final char LEFT_PARENTHESIS = '(';
    public static final char RIGHT_PARENTHESIS = ')';
    public static final String M_STR = "M";
    public static final String K_STR = "K";
    public static final String T_STR = "T";
    public static final String Z_STR = "Z";
    public static final String TWELVE_STR = "12";
    public static final String TWENTY_FOUR_STR = "24";
    public static final String FOUR_DIGITS_PADDED_FORMAT_STR = "%04d";
    public static final String TWO_DIGITS_PADDED_FORMAT_STR = "%02d";
    public static final String NINE_DIGITS_PADDED_FORMAT_STR = "%09d";
    public static final String TZ_HOUR_MINUTE_SEQ = "TZH:TZM";
    public static final String TZ_HOUR_SEQ = "TZH";
    public static final int THREE = 3;
    public static final int FIVE = 5;
    public static final int NINE = 9;
    public static final long HOUR_IN_SECONDS = 3600L;
    public static final long MINUTE_IN_SECONDS = 60L;
    public static final int HOURS_TO_NOON = 12;
    public static final String TIME_TYPE_STR = "time";
    public static final String TIMESTAMP_TYPE_STR = "timestamp";
    public static final String FORMATTERS_KEY = "formatters";
    public static final String AM_STR = "AM";
    public static final String PM_STR = "PM";
    private static final String[] AM_POSSIBLE_VALUES = new String[]{"A.M.", "a.m.", "A.m.", "a.M.", "am", "Am", "aM"};
    private static final String[] PM_POSSIBLE_VALUES = new String[]{"P.M.", "p.m.", "P.m.", "p.M.", "pm", "Pm", "pM"};
    private static final ChronoField[] DATE_PERMITTED_CHRONO_ACCESSORS = new ChronoField[]{ChronoField.YEAR_OF_ERA, ChronoField.MONTH_OF_YEAR, ChronoField.DAY_OF_MONTH, ChronoField.DAY_OF_YEAR};
    private static final ChronoField[] TIME_PERMITTED_CHRONO_ACCESSORS = new ChronoField[]{ChronoField.HOUR_OF_DAY, ChronoField.HOUR_OF_AMPM, ChronoField.MINUTE_OF_HOUR, ChronoField.SECOND_OF_MINUTE, ChronoField.NANO_OF_SECOND, ChronoField.AMPM_OF_DAY, ChronoField.MILLI_OF_DAY};
    private final HashMap<String, String> buildingBlocks = new HashMap();
    private final HashMap<String, Pattern> formattingPatterns = new HashMap();

    private LOCALCastFormatter() {
        this.initialize();
    }

    private void initialize() {
        SQLCapabilities sqlCapabilities = SQLCapabilities.getInstance();
        for (FormatterAccessorKeys formatAK : FormatterAccessorKeys.FORMATTING_BUILDING_BLOCKS) {
            this.buildingBlocks.put(formatAK.getValue(), sqlCapabilities.getStringValue("formatters." + formatAK.getValue(), EMPTY_STR));
        }
        for (FormatterAccessorKeys formatAK : FormatterAccessorKeys.FORMATTING_PATTERN_BLOCKS) {
            String patternValue = sqlCapabilities.getStringValue("formatters." + formatAK.getValue(), EMPTY_STR);
            patternValue = patternValue.replaceAll(SPACE_STR, EMPTY_STR);
            TreeSet<String> constructs = new TreeSet<String>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    if (o1.length() > o2.length()) {
                        return -1;
                    }
                    if (o1.length() == o2.length()) {
                        return o1.compareTo(o2);
                    }
                    return 1;
                }
            });
            int offset = 0;
            while (offset < patternValue.length()) {
                boolean startIndxChanged;
                int startIndx = patternValue.indexOf(40, offset);
                int endIndx = patternValue.indexOf(41, startIndx + 1);
                if (startIndx == -1 || endIndx == -1) break;
                do {
                    startIndxChanged = false;
                    int nextLeftParenthesisIndx = patternValue.indexOf(40, startIndx + 1);
                    if (nextLeftParenthesisIndx == -1 || nextLeftParenthesisIndx >= endIndx) continue;
                    startIndx = nextLeftParenthesisIndx;
                    startIndxChanged = true;
                } while (startIndxChanged);
                String construct = patternValue.substring(startIndx + 1, endIndx);
                constructs.add(construct);
                offset = endIndx + 1;
            }
            for (String construct : constructs) {
                String constructReplacement = this.buildingBlocks.get(construct);
                if (constructReplacement == null) continue;
                patternValue = patternValue.replaceAll(construct, constructReplacement);
            }
            Pattern p = Pattern.compile(patternValue);
            this.buildingBlocks.put(formatAK.getValue(), patternValue);
            this.formattingPatterns.put(formatAK.getValue(), p);
        }
    }

    public static LOCALCastFormatter getInstance() {
        return instance;
    }

    public boolean validatePattern(String inputPattern) {
        boolean success = false;
        for (Pattern patternFormatValidator : this.formattingPatterns.values()) {
            Matcher matcher = patternFormatValidator.matcher(inputPattern);
            try {
                success = matcher.matches();
                if (!success) continue;
                return success;
            }
            catch (IllegalStateException e) {
                success = false;
            }
        }
        return success;
    }

    public DateTimeFormatter getJavaPatternFromSQLPattern(String sqlPattern, List<ChronoField> accessors) {
        if (!this.validatePattern(sqlPattern = sqlPattern.trim())) {
            throw new IllegalArgumentException("Invalid sql pattern detected: \"" + sqlPattern + "\"");
        }
        if (accessors == null || !accessors.isEmpty()) {
            throw new IllegalArgumentException("Accessors array should be empty.");
        }
        DateTimeFormatterBuilder dtfBuilder = new DateTimeFormatterBuilder();
        for (int offset = 0; offset < sqlPattern.length(); ++offset) {
            int numOfParsedChars = 1;
            char currentChar = sqlPattern.charAt(offset);
            switch (currentChar) {
                case 'R': 
                case 'Y': {
                    while (offset + numOfParsedChars < sqlPattern.length() && sqlPattern.charAt(offset + numOfParsedChars) == currentChar) {
                        ++numOfParsedChars;
                    }
                    dtfBuilder.appendPattern("y");
                    accessors.add(ChronoField.YEAR_OF_ERA);
                    break;
                }
                case 'M': {
                    if (offset + numOfParsedChars < sqlPattern.length() && sqlPattern.charAt(offset + numOfParsedChars) == 'M') {
                        dtfBuilder.appendPattern(M_STR);
                        accessors.add(ChronoField.MONTH_OF_YEAR);
                        ++numOfParsedChars;
                        break;
                    }
                    if (offset + numOfParsedChars < sqlPattern.length() && sqlPattern.charAt(offset + numOfParsedChars) == 'I') {
                        dtfBuilder.appendPattern("m");
                        accessors.add(ChronoField.MINUTE_OF_HOUR);
                        ++numOfParsedChars;
                        break;
                    }
                    dtfBuilder.appendPattern(M_STR);
                    accessors.add(ChronoField.MONTH_OF_YEAR);
                    break;
                }
                case 'D': {
                    while (offset + numOfParsedChars < sqlPattern.length() && sqlPattern.charAt(offset + numOfParsedChars) == currentChar) {
                        ++numOfParsedChars;
                    }
                    if (numOfParsedChars == 3) {
                        dtfBuilder.appendPattern("D");
                        accessors.add(ChronoField.DAY_OF_YEAR);
                        break;
                    }
                    dtfBuilder.appendPattern("d");
                    accessors.add(ChronoField.DAY_OF_MONTH);
                    break;
                }
                case 'H': {
                    while (offset + numOfParsedChars < sqlPattern.length() && sqlPattern.charAt(offset + numOfParsedChars) == 'H') {
                        ++numOfParsedChars;
                    }
                    if (offset + numOfParsedChars + 1 < sqlPattern.length()) {
                        if (sqlPattern.substring(offset + numOfParsedChars, offset + numOfParsedChars + 2).equals(TWELVE_STR)) {
                            dtfBuilder.appendPattern(K_STR);
                            accessors.add(ChronoField.HOUR_OF_AMPM);
                            numOfParsedChars += 2;
                            break;
                        }
                        if (sqlPattern.substring(offset + numOfParsedChars, offset + numOfParsedChars + 2).equals(TWENTY_FOUR_STR)) {
                            dtfBuilder.appendPattern("H");
                            accessors.add(ChronoField.HOUR_OF_DAY);
                            numOfParsedChars += 2;
                            break;
                        }
                        dtfBuilder.appendPattern(K_STR);
                        accessors.add(ChronoField.HOUR_OF_AMPM);
                        break;
                    }
                    dtfBuilder.appendPattern(K_STR);
                    accessors.add(ChronoField.HOUR_OF_AMPM);
                    break;
                }
                case 'A': 
                case 'P': 
                case 'a': 
                case 'p': {
                    while (offset + numOfParsedChars < sqlPattern.length() && (sqlPattern.charAt(offset + numOfParsedChars) == '.' || sqlPattern.charAt(offset + numOfParsedChars) == 'M' || sqlPattern.charAt(offset + numOfParsedChars) == 'm')) {
                        ++numOfParsedChars;
                    }
                    dtfBuilder.appendPattern("a");
                    accessors.add(ChronoField.AMPM_OF_DAY);
                    break;
                }
                case 'S': {
                    while (offset + numOfParsedChars < sqlPattern.length() && sqlPattern.charAt(offset + numOfParsedChars) == currentChar) {
                        ++numOfParsedChars;
                    }
                    if (numOfParsedChars == 5) {
                        dtfBuilder.appendPattern("A");
                        accessors.add(ChronoField.MILLI_OF_DAY);
                        break;
                    }
                    dtfBuilder.appendPattern("s");
                    accessors.add(ChronoField.SECOND_OF_MINUTE);
                    break;
                }
                case 'F': {
                    numOfParsedChars += 2;
                    dtfBuilder.appendFraction(ChronoField.NANO_OF_SECOND, 1, 9, false);
                    accessors.add(ChronoField.NANO_OF_SECOND);
                    break;
                }
                case 'T': {
                    String str;
                    boolean noMatch = true;
                    if (noMatch && offset + TZ_HOUR_MINUTE_SEQ.length() - 1 < sqlPattern.length() && (str = sqlPattern.substring(offset, offset + TZ_HOUR_MINUTE_SEQ.length())).equals(TZ_HOUR_MINUTE_SEQ)) {
                        dtfBuilder.appendOffset("+HH:MM", EMPTY_STR);
                        accessors.add(ChronoField.OFFSET_SECONDS);
                        numOfParsedChars = TZ_HOUR_MINUTE_SEQ.length();
                        noMatch = false;
                    }
                    if (noMatch && offset + TZ_HOUR_SEQ.length() - 1 < sqlPattern.length() && (str = sqlPattern.substring(offset, offset + TZ_HOUR_SEQ.length())).equals(TZ_HOUR_SEQ)) {
                        dtfBuilder.appendOffset("+HH", EMPTY_STR);
                        accessors.add(ChronoField.OFFSET_SECONDS);
                        numOfParsedChars = TZ_HOUR_SEQ.length();
                        noMatch = false;
                    }
                    if (!noMatch) break;
                    dtfBuilder.appendLiteral(currentChar);
                    break;
                }
                default: {
                    dtfBuilder.appendLiteral(currentChar);
                }
            }
            offset += numOfParsedChars - 1;
        }
        return dtfBuilder.toFormatter(Locale.US);
    }

    public String convertToISOStandardFormat(String inputValue, IDataType targetType, List<ChronoField> accessors, DateTimeFormatter dtf) {
        int i;
        if (!targetType.isDatetime()) {
            throw new IllegalArgumentException("Only the following target types are allowed: date, time, time_tz, timestamp, timestamp_tz");
        }
        boolean cleansed = false;
        inputValue = inputValue.trim();
        for (i = 0; !cleansed && i < AM_POSSIBLE_VALUES.length; ++i) {
            if (!inputValue.contains(AM_POSSIBLE_VALUES[i])) continue;
            inputValue = inputValue.replace(AM_POSSIBLE_VALUES[i], AM_STR);
            cleansed = true;
        }
        for (i = 0; !cleansed && i < PM_POSSIBLE_VALUES.length; ++i) {
            if (!inputValue.contains(PM_POSSIBLE_VALUES[i])) continue;
            inputValue = inputValue.replace(PM_POSSIBLE_VALUES[i], PM_STR);
            cleansed = true;
        }
        TemporalAccessor ta = dtf.parse(inputValue);
        String result = targetType.isDate() ? this.getISOStandardDateRepresentation(ta, accessors) : (targetType.isTime() ? (((TimeType)targetType).getTypeName().equals(TIME_TYPE_STR) ? this.getISOStandardTimeRepresentation(ta, accessors) : this.getISOStandardTimeTZRepresentation(ta, accessors)) : (((TimestampType)targetType).getTypeName().equals(TIMESTAMP_TYPE_STR) ? this.getISOStandardTimestampRepresentation(ta, accessors) : this.getISOStandardTimestampTZRepresentation(ta, accessors)));
        return result;
    }

    private String getISOStandardDateRepresentation(TemporalAccessor ta, List<ChronoField> accessors) {
        StringBuilder sb = new StringBuilder();
        LocalDate localDate = LocalDate.now();
        if (accessors.contains(ChronoField.DAY_OF_YEAR)) {
            int dayOfYear = ta.get(ChronoField.DAY_OF_YEAR);
            sb.append(Year.of(localDate.getYear()).atDay(dayOfYear).toString());
        } else {
            block7: for (int i = 0; i < DATE_PERMITTED_CHRONO_ACCESSORS.length; ++i) {
                switch (DATE_PERMITTED_CHRONO_ACCESSORS[i]) {
                    case YEAR_OF_ERA: {
                        int yearOfEra = localDate.getYear();
                        if (accessors.contains(ChronoField.YEAR_OF_ERA)) {
                            try {
                                yearOfEra = ta.get(ChronoField.YEAR_OF_ERA);
                            }
                            catch (UnsupportedTemporalTypeException e) {
                                yearOfEra = ta.get(ChronoField.YEAR);
                            }
                        }
                        sb.append(String.format(FOUR_DIGITS_PADDED_FORMAT_STR, yearOfEra));
                        sb.append("-");
                        continue block7;
                    }
                    case MONTH_OF_YEAR: {
                        int monthOfYear = 1;
                        if (accessors.contains(ChronoField.MONTH_OF_YEAR)) {
                            monthOfYear = ta.get(ChronoField.MONTH_OF_YEAR);
                        }
                        sb.append(String.format(TWO_DIGITS_PADDED_FORMAT_STR, monthOfYear));
                        sb.append("-");
                        continue block7;
                    }
                    case DAY_OF_MONTH: {
                        int dayOfMonth = 1;
                        if (accessors.contains(ChronoField.DAY_OF_MONTH)) {
                            dayOfMonth = ta.get(ChronoField.DAY_OF_MONTH);
                        }
                        sb.append(String.format(TWO_DIGITS_PADDED_FORMAT_STR, dayOfMonth));
                        continue block7;
                    }
                }
            }
        }
        return sb.toString();
    }

    private String getISOStandardTimeRepresentation(TemporalAccessor ta, List<ChronoField> accessors) {
        StringBuilder sb = new StringBuilder();
        if (accessors.contains(ChronoField.MILLI_OF_DAY)) {
            long offset = ta.get(ChronoField.MILLI_OF_DAY);
            long hourOfDay = TimeUnit.HOURS.convert(offset, TimeUnit.SECONDS);
            long minuteOfHour = TimeUnit.MINUTES.convert(offset -= hourOfDay * 3600L, TimeUnit.SECONDS);
            long secondOfMinute = offset -= minuteOfHour * 60L;
            sb.append(String.format(TWO_DIGITS_PADDED_FORMAT_STR, hourOfDay));
            sb.append(COLON_STR);
            sb.append(String.format(TWO_DIGITS_PADDED_FORMAT_STR, minuteOfHour));
            sb.append(COLON_STR);
            sb.append(String.format(TWO_DIGITS_PADDED_FORMAT_STR, secondOfMinute));
        } else {
            block7: for (int i = 0; i < TIME_PERMITTED_CHRONO_ACCESSORS.length; ++i) {
                switch (TIME_PERMITTED_CHRONO_ACCESSORS[i]) {
                    case HOUR_OF_AMPM: {
                        if (!accessors.contains(ChronoField.HOUR_OF_AMPM) && accessors.contains(ChronoField.HOUR_OF_DAY)) continue block7;
                        int hourOfDay = 0;
                        if (accessors.contains(ChronoField.HOUR_OF_AMPM)) {
                            hourOfDay = ta.get(ChronoField.HOUR_OF_AMPM);
                        }
                        int ampmOfDay = 0;
                        if (accessors.contains(ChronoField.AMPM_OF_DAY) && (ampmOfDay = ta.get(ChronoField.AMPM_OF_DAY)) == 1) {
                            hourOfDay += 12;
                        }
                        sb.append(String.format(TWO_DIGITS_PADDED_FORMAT_STR, hourOfDay));
                        sb.append(COLON_STR);
                        continue block7;
                    }
                    case HOUR_OF_DAY: {
                        if (!accessors.contains(ChronoField.HOUR_OF_DAY)) continue block7;
                        int hourOfDay = ta.get(ChronoField.HOUR_OF_DAY);
                        sb.append(String.format(TWO_DIGITS_PADDED_FORMAT_STR, hourOfDay));
                        sb.append(COLON_STR);
                        continue block7;
                    }
                    case MINUTE_OF_HOUR: {
                        int minuteOfHour = 0;
                        if (accessors.contains(ChronoField.MINUTE_OF_HOUR)) {
                            minuteOfHour = ta.get(ChronoField.MINUTE_OF_HOUR);
                        }
                        sb.append(String.format(TWO_DIGITS_PADDED_FORMAT_STR, minuteOfHour));
                        sb.append(COLON_STR);
                        continue block7;
                    }
                    case SECOND_OF_MINUTE: {
                        int secondOfMinute = 0;
                        if (accessors.contains(ChronoField.SECOND_OF_MINUTE)) {
                            secondOfMinute = ta.get(ChronoField.SECOND_OF_MINUTE);
                        }
                        sb.append(String.format(TWO_DIGITS_PADDED_FORMAT_STR, secondOfMinute));
                        continue block7;
                    }
                    case NANO_OF_SECOND: {
                        sb.append(DOT_STR);
                        long nanoOfSecond = 0L;
                        if (accessors.contains(ChronoField.NANO_OF_SECOND)) {
                            nanoOfSecond = ta.get(ChronoField.NANO_OF_SECOND);
                        }
                        sb.append(String.format(NINE_DIGITS_PADDED_FORMAT_STR, nanoOfSecond));
                        continue block7;
                    }
                }
            }
        }
        return sb.toString();
    }

    private String getISOStandardTimeTZRepresentation(TemporalAccessor ta, List<ChronoField> accessors) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getISOStandardTimeRepresentation(ta, accessors));
        long tzOffset = 0L;
        if (accessors.contains(ChronoField.OFFSET_SECONDS)) {
            tzOffset = ta.get(ChronoField.OFFSET_SECONDS);
        }
        if (tzOffset >= 0L) {
            sb.append(PLUS_SIGN_STR);
        } else {
            sb.append("-");
            tzOffset = -tzOffset;
        }
        long hourOfDay = TimeUnit.HOURS.convert(tzOffset, TimeUnit.SECONDS);
        long minuteOfHour = TimeUnit.MINUTES.convert(tzOffset -= hourOfDay * 3600L, TimeUnit.SECONDS);
        sb.append(String.format(TWO_DIGITS_PADDED_FORMAT_STR, hourOfDay));
        sb.append(COLON_STR);
        sb.append(String.format(TWO_DIGITS_PADDED_FORMAT_STR, minuteOfHour));
        return sb.toString();
    }

    private String getISOStandardTimestampRepresentation(TemporalAccessor ta, List<ChronoField> accessors) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getISOStandardDateRepresentation(ta, accessors));
        sb.append(T_STR);
        sb.append(this.getISOStandardTimeRepresentation(ta, accessors));
        return sb.toString();
    }

    private String getISOStandardTimestampTZRepresentation(TemporalAccessor ta, List<ChronoField> accessors) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getISOStandardDateRepresentation(ta, accessors));
        sb.append(T_STR);
        sb.append(this.getISOStandardTimeTZRepresentation(ta, accessors));
        return sb.toString();
    }

    public static enum FormatterAccessorKeys {
        DELIMITER_KEY("delimiter"),
        YEAR_KEY("year"),
        MONTH_NUMBER_OF_YEAR_KEY("month_number_of_year"),
        DAY_NUMBER_OF_MONTH_KEY("day_number_of_month"),
        DAY_NUMBER_OF_YEAR_KEY("day_number_of_year"),
        TWELVE_HOUR_CLOCK_KEY("twelve_hour_clock"),
        TWENTY_FOUR_HOUR_CLOCK_KEY("twenty_four_hour_clock"),
        AM_PM_KEY("am_pm"),
        MINUTES_OF_HOUR_KEY("minutes_of_hour"),
        SECONDS_OF_MINUTE_KEY("seconds_of_minute"),
        SECONDS_PAST_MIDNIGHT_KEY("seconds_past_midnight"),
        FRACTIONAL_SECONDS_KEY("fractional_seconds"),
        TIME_ZONE_HOUR_KEY("time_zone_hour"),
        TIME_ZONE_MINUTE_KEY("time_zone_minute"),
        STRING_TO_DATE_KEY("string_to_date"),
        STRING_TO_TIME_KEY("string_to_time"),
        STRING_TO_TIME_WITH_TIME_ZONE_KEY("string_to_time_with_time_zone"),
        STRING_TO_TIMESTAMP_KEY("string_to_timestamp"),
        STRING_TO_TIMESTAMP_WITH_TIME_ZONE_KEY("string_to_timestamp_with_time_zone");

        private String value;
        private static final FormatterAccessorKeys[] FORMATTING_BUILDING_BLOCKS;
        private static final FormatterAccessorKeys[] FORMATTING_PATTERN_BLOCKS;

        private FormatterAccessorKeys(String stringValue) {
            this.value = stringValue;
        }

        public String getValue() {
            return this.value;
        }

        static {
            FORMATTING_BUILDING_BLOCKS = new FormatterAccessorKeys[]{DELIMITER_KEY, YEAR_KEY, MONTH_NUMBER_OF_YEAR_KEY, DAY_NUMBER_OF_MONTH_KEY, DAY_NUMBER_OF_YEAR_KEY, TWELVE_HOUR_CLOCK_KEY, TWENTY_FOUR_HOUR_CLOCK_KEY, AM_PM_KEY, MINUTES_OF_HOUR_KEY, SECONDS_OF_MINUTE_KEY, SECONDS_PAST_MIDNIGHT_KEY, FRACTIONAL_SECONDS_KEY, TIME_ZONE_HOUR_KEY, TIME_ZONE_MINUTE_KEY};
            FORMATTING_PATTERN_BLOCKS = new FormatterAccessorKeys[]{STRING_TO_DATE_KEY, STRING_TO_TIME_KEY, STRING_TO_TIME_WITH_TIME_ZONE_KEY, STRING_TO_TIMESTAMP_KEY, STRING_TO_TIMESTAMP_WITH_TIME_ZONE_KEY};
        }
    }
}

