/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.jdbc;

import com.cognos.xqe.data.providers.relational.jdbc.JDBCLog;
import com.cognos.xqe.data.providers.relational.jdbc.XQECallableStatementWrapper;
import com.cognos.xqe.data.providers.relational.jdbc.XQEPreparedStatementWrapper;
import com.cognos.xqe.data.providers.relational.jdbc.XQEStatementWrapper;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.Timer;
import com.cognos.xqe.util.usage.UsageTrackingService;
import com.ibm.cognos.jdbc.adaptor.IAdaptorConnection;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Handler;

public class XQEConnectionWrapper
implements Connection,
IAdaptorConnection {
    private static final String CONNECTION_CREATE_STATEMENT = "[%1$d] Connection.createStatement() -> [%2$d] (%3$dns)";
    private static final String CONNECTION_GET_METADATA = "[%1$d] Connection.getMetaData() (%2$dns)";
    private static final String CONNECTION_SWITCH_USER_SESSION_START = "[%1$d] Connection switch user - session start -> [%2$s] (%3$dns)";
    private static final String CONNECTION_SWITCH_USER_WITH_REGISTRY_SESSION_START = "[%1$d] Connection switch user with registry [%3$s] - session start -> [%2$s] (%4$dns)";
    private static final String CONNECTION_SWITCH_USER_SESSION_END = "[%1$d] Connection switch user - session end -> [%2$s] (%3$dns)";
    protected static final String PREPARE_STATEMENT_LOG_STR = "[%1$d] Connection.prepareStatement(%2$s) -> [%3$d] (%4$dns)";
    protected static final String PREPARE_CALL_LOG_STR = "[%1$d] Connection.prepareCall(%2$s) -> [%3$d] (%4$dn)";
    private static final String CONNECTION_SET_ATTRIBUTES = "[%1$d] Connection set attributes -> (%2$dns)";
    private static final String CONNECTION_QUALIFIER_LIST = "Connection set qualifier list -> %s";
    public static final String METHOD_NOT_SUPPORTED = "Method not supported";
    private IAdaptorConnection connection;
    private static AtomicInteger counter = new AtomicInteger(0);
    private int id = counter.incrementAndGet();

    public XQEConnectionWrapper(IAdaptorConnection theConnection) {
        this.connection = theConnection;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.connection.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        this.connection.close();
    }

    @Override
    public void commit() throws SQLException {
        this.connection.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement createStatement() throws SQLException {
        XQEStatementWrapper statement;
        block5: {
            block4: {
                int statementID;
                long time;
                block3: {
                    statement = null;
                    if (!JDBCLog.isOn()) break block4;
                    Timer timer = new Timer();
                    try {
                        timer.start();
                        statement = new XQEStatementWrapper((Connection)this.connection, this.connection.createStatement());
                        time = timer.stop();
                        statementID = 0;
                        if (statement == null) break block3;
                        statementID = statement.getID();
                    }
                    catch (Throwable throwable) {
                        long time2 = timer.stop();
                        int statementID2 = 0;
                        if (statement != null) {
                            statementID2 = statement.getID();
                        }
                        JDBCLog.getLogger(LogLevel.INFO).log(String.format(CONNECTION_CREATE_STATEMENT, this.id, statementID2, time2));
                        throw throwable;
                    }
                }
                JDBCLog.getLogger(LogLevel.INFO).log(String.format(CONNECTION_CREATE_STATEMENT, this.id, statementID, time));
                break block5;
            }
            statement = new XQEStatementWrapper((Connection)this.connection, this.connection.createStatement());
        }
        return statement;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.connection.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.connection.getCatalog();
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.connection.getHoldability();
    }

    public int getID() {
        return this.id;
    }

    public Connection getJDBCConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        DatabaseMetaData metaData;
        if (JDBCLog.isOn()) {
            long time;
            Timer timer = new Timer();
            try {
                timer.start();
                metaData = this.connection.getMetaData();
            }
            finally {
                time = timer.stop();
            }
            JDBCLog.getLogger(LogLevel.INFO).log(String.format(CONNECTION_GET_METADATA, this.id, time));
        } else {
            metaData = this.connection.getMetaData();
        }
        return metaData;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.connection.getTransactionIsolation();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.connection.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.connection.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.connection.nativeSQL(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        XQECallableStatementWrapper statement;
        if (JDBCLog.isOn() || UsageTrackingService.isOn()) {
            long time;
            Timer timer = new Timer();
            try {
                timer.start();
                statement = new XQECallableStatementWrapper((Connection)this, this.connection.prepareCall(sql));
            }
            finally {
                time = timer.stop();
            }
            if (JDBCLog.isOn()) {
                JDBCLog.log(String.format(PREPARE_CALL_LOG_STR, this.id, sql.trim(), statement.getID(), time));
            }
            JDBCLog.incrementTimeSpentInJDBC(timer.getElapsedTimeInMilliseconds());
        } else {
            statement = new XQECallableStatementWrapper((Connection)this, this.connection.prepareCall(sql));
        }
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.connection.prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.connection.prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.connection.prepareStatement(sql, columnNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        XQEPreparedStatementWrapper statement;
        if (JDBCLog.isOn() || UsageTrackingService.isOn()) {
            long time;
            Timer timer = new Timer();
            try {
                timer.start();
                statement = new XQEPreparedStatementWrapper(this, this.connection.prepareStatement(sql));
            }
            finally {
                time = timer.stop();
            }
            if (JDBCLog.isOn()) {
                JDBCLog.log(String.format(PREPARE_STATEMENT_LOG_STR, this.id, sql.trim(), statement.getID(), time));
            }
            JDBCLog.incrementTimeSpentInJDBC(timer.getElapsedTimeInMilliseconds());
        } else {
            statement = new XQEPreparedStatementWrapper(this, this.connection.prepareStatement(sql));
        }
        return statement;
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.connection.releaseSavepoint(savepoint);
    }

    @Override
    public void rollback() throws SQLException {
        this.connection.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.connection.rollback(savepoint);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.connection.setAutoCommit(autoCommit);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.connection.setCatalog(catalog);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.connection.setHoldability(holdability);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.connection.setReadOnly(readOnly);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.connection.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.connection.setSavepoint(name);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.connection.setTransactionIsolation(level);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.connection.setTypeMap(map);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.connection.createArrayOf(typeName, elements);
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.connection.createBlob();
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.connection.createClob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.connection.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.connection.createSQLXML();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.connection.createStruct(typeName, attributes);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.connection.getClientInfo();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.connection.getClientInfo(name);
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.connection.isValid(timeout);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.connection.setClientInfo(properties);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.connection.setClientInfo(name, value);
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return this.connection.isWrapperFor(arg0);
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        return (T)this.connection.unwrap(arg0);
    }

    public String getQueryPlan(String query) throws SQLException {
        return this.connection.getQueryPlan(query);
    }

    public String getSubType() {
        return this.connection.getSubType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchUser(Boolean isSessionStart, String userID, String passWD, String registryName) throws SQLException {
        if (JDBCLog.isOn() || UsageTrackingService.isOn()) {
            long time;
            Timer timer = new Timer();
            try {
                timer.start();
                this.connection.switchUser(isSessionStart, userID, passWD, registryName);
            }
            finally {
                time = timer.stop();
            }
            if (JDBCLog.isOn()) {
                if (isSessionStart.booleanValue()) {
                    if (registryName == null) {
                        JDBCLog.log(String.format(CONNECTION_SWITCH_USER_SESSION_START, this.id, userID, time));
                    } else {
                        JDBCLog.log(String.format(CONNECTION_SWITCH_USER_WITH_REGISTRY_SESSION_START, this.id, userID, registryName, time));
                    }
                } else {
                    JDBCLog.log(String.format(CONNECTION_SWITCH_USER_SESSION_END, this.id, userID, time));
                }
            }
            JDBCLog.incrementTimeSpentInJDBC(timer.getElapsedTimeInMilliseconds());
        } else {
            this.connection.switchUser(isSessionStart, userID, passWD, registryName);
        }
    }

    public Map<String, Object> getExtraInformation() {
        return this.connection.getExtraInformation();
    }

    public void setConnectionAttributes(Properties attributes) throws SQLException {
        if (JDBCLog.isOn()) {
            JDBCLog.log(String.format(CONNECTION_SET_ATTRIBUTES, this.id, System.currentTimeMillis()));
        }
        this.connection.setConnectionAttributes(attributes);
    }

    public SQLException processSQLException(SQLException t) {
        return this.connection.processSQLException(t);
    }

    public void startTrace(Handler handler, boolean identify, String interfaceFilterRegex) {
    }

    public void stopTrace() {
    }

    public boolean isTracing() {
        return false;
    }

    public List<String> getQualifierList() {
        return this.connection.getQualifierList();
    }

    public void setQualifierList(List<String> qList) {
        if (JDBCLog.isOn()) {
            JDBCLog.getLogger(LogLevel.INFO).log(String.format(CONNECTION_QUALIFIER_LIST, qList.toString()));
        }
        this.connection.setQualifierList(qList);
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public String getSchema() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }
}

