/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.jdbc;

import com.cognos.xqe.data.providers.relational.jdbc.JDBCLog;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.Timer;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class XQEDriverWrapper
implements Driver {
    private static final String LOADED_JDBC_DRIVER = "Loaded JDBC driver [%1$s] -> [%2$x] (%3$dns)";
    private static final String DRIVER_CONNECT = "[%1$x] Driver.connect('%2$s') successful - connection established -> [%3$x] (%4$dns)";
    private Driver driver;
    private static AtomicInteger counter = new AtomicInteger(0);
    private int id = counter.incrementAndGet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XQEDriverWrapper(String driverName) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (JDBCLog.isOn()) {
            long time;
            Timer timer = new Timer();
            try {
                timer.start();
                this.driver = (Driver)Class.forName(driverName).newInstance();
            }
            finally {
                time = timer.stop();
            }
            JDBCLog.getLogger(LogLevel.INFO).log(String.format(LOADED_JDBC_DRIVER, driverName, this.id, time));
        } else {
            this.driver = (Driver)Class.forName(driverName).newInstance();
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return this.driver.acceptsURL(url);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        JDBCLog.getLogger(LogLevel.INFO).log(String.format(DRIVER_CONNECT, this.id, url, "", 0));
        return null;
    }

    @Override
    public int getMajorVersion() {
        return this.driver.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return this.driver.getMinorVersion();
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return this.driver.getPropertyInfo(url, info);
    }

    @Override
    public boolean jdbcCompliant() {
        return this.driver.jdbcCompliant();
    }

    public Driver getRawDriver() {
        return this.driver;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("getParentLogger() is not supported.");
    }
}

