/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.jdbc.util;

import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.relational.jdbc.util.JDBCDB2ConnectionStringConverter;
import com.cognos.xqe.data.providers.relational.jdbc.util.JDBCODConnectionStringConverter;
import com.cognos.xqe.data.providers.relational.jdbc.util.JDBCORConnectionStringConverter;
import com.cognos.xqe.data.providers.relational.jdbc.util.JDBCSSConnectionStringConverter;
import com.cognos.xqe.data.providers.relational.jdbc.util.JDBCTDConnectionStringConverter;

public final class JDBCConnectionUtil {
    public static String buildJDBCConnectionString(IDataSource dataSource, String connectionString) throws Exception {
        if (connectionString.startsWith("jdbc:")) {
            return connectionString;
        }
        StringBuilder buffer = new StringBuilder();
        String dataSourceType = dataSource.getType();
        try {
            if (DataSourceTypeEnum.isDB2(dataSourceType)) {
                return JDBCDB2ConnectionStringConverter.convertConnectionString(connectionString);
            }
            if (DataSourceTypeEnum.isSQLServer(dataSourceType)) {
                return JDBCSSConnectionStringConverter.convertConnectionString(connectionString);
            }
            if (DataSourceTypeEnum.isOracle(dataSourceType)) {
                return JDBCORConnectionStringConverter.convertConnectionString(connectionString);
            }
            if (DataSourceTypeEnum.isTeradata(dataSourceType)) {
                return JDBCTDConnectionStringConverter.convertConnectionString(connectionString);
            }
            if (DataSourceTypeEnum.isNetezza(dataSourceType)) {
                return JDBCODConnectionStringConverter.convertConnectionString(connectionString);
            }
            if (dataSourceType.equals("OD")) {
                return JDBCODConnectionStringConverter.convertConnectionString(connectionString);
            }
        }
        catch (LogonFailureException ex) {
            ex.setDataSource(dataSource);
            throw ex;
        }
        catch (Exception e) {
            throw e;
        }
        return buffer.toString();
    }
}

