/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.rscache;

import com.cognos.xqe.data.providers.rscache.IncompleteCacheException;
import com.cognos.xqe.data.providers.rscache.RSCacheLog;
import com.cognos.xqe.data.providers.rscache.RSCacheMetrics;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.md.Tuple;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class EdgeData {
    public static final int DEFAULT_TUPLES_PER_BLOCK = 128;
    private final int edgeNumber;
    private final IDimension[] dimensions;
    private final int tuplesPerBlock;
    private final int membersPerBlock;
    private final List<IMember[]> blocks = new ArrayList<IMember[]>();
    private volatile long tupleCount = 0L;
    private volatile long tupleCapacity = 0L;
    private volatile boolean edgeComplete = false;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();

    public EdgeData(int theEdgeNumber, IDimension[] dims) {
        this(theEdgeNumber, dims, 128);
    }

    public EdgeData(int theEdgeNumber, IDimension[] dims, int nTuplesPerBlock) {
        this.edgeNumber = theEdgeNumber;
        this.dimensions = dims;
        this.tuplesPerBlock = nTuplesPerBlock;
        this.membersPerBlock = this.dimensions.length * this.tuplesPerBlock;
    }

    public IDimension[] getDimensions() {
        return this.dimensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTuple(long tupleIndex, ITuple t) throws IllegalStateException {
        XQELogger tupleDataLogger;
        if (this.edgeComplete) {
            return;
        }
        int cardinality = t.size();
        if (cardinality != this.dimensions.length) {
            throw new IllegalArgumentException("Tuple size is not consistent with edge size.");
        }
        boolean wasStored = false;
        this.rwLock.writeLock().lock();
        try {
            if (tupleIndex >= this.tupleCount) {
                this.ensureCapacity(tupleIndex + 1L);
                IMember[] block = this.blocks.get((int)(tupleIndex / (long)this.tuplesPerBlock));
                int offsetInBlock = (int)(tupleIndex % (long)this.tuplesPerBlock) * cardinality;
                for (int i = 0; i < cardinality; ++i) {
                    block[offsetInBlock + i] = t.getMember(i);
                }
                this.tupleCount = tupleIndex + 1L;
                wasStored = true;
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        if (wasStored && (tupleDataLogger = RSCacheLog.getTupleDataLogger()).isOn(LogLevel.TRACE)) {
            tupleDataLogger.log(LogLevel.TRACE, String.format("Stored tuple in EdgeData.setTuple(long, ITuple) for edge %d and index %d: %s", tupleIndex, this.edgeNumber, t.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public ITuple getTuple(long tupleIndex) {
        block16: {
            cacheHit = false;
            this.rwLock.readLock().lock();
            if (tupleIndex < this.tupleCount) ** GOTO lbl22
            if (!this.edgeComplete) break block16;
            cacheHit = true;
            var4_3 = null;
            this.rwLock.readLock().unlock();
            tupleDataLogger = RSCacheLog.getTupleDataLogger();
            if (cacheHit) {
                if (tupleDataLogger.isOn(LogLevel.TRACE)) {
                    tupleDataLogger.log(LogLevel.TRACE, String.format("Cache hit in EdgeData.getTuple(long) for edge %d and tuple index %d.", new Object[]{this.edgeNumber, tupleIndex}));
                }
                RSCacheMetrics.getTupleHitCount().increment();
            } else {
                if (tupleDataLogger.isOn(LogLevel.TRACE)) {
                    tupleDataLogger.log(LogLevel.TRACE, String.format("Cache miss in EdgeData.getTuple(long) for edge %d and tuple index %d.", new Object[]{this.edgeNumber, tupleIndex}));
                }
                RSCacheMetrics.getTupleMissCount().increment();
            }
            return var4_3;
        }
        try {
            throw new IncompleteCacheException(tupleIndex);
lbl22:
            // 1 sources

            cardinality = this.dimensions.length;
            block = this.blocks.get((int)(tupleIndex / (long)this.tuplesPerBlock));
            offsetInBlock = (int)(tupleIndex % (long)this.tuplesPerBlock) * cardinality;
            members = new IMember[cardinality];
            for (i = 0; i < cardinality; ++i) {
                members[i] = block[offsetInBlock + i];
            }
            cacheHit = true;
            var8_10 = new Tuple(members);
            this.rwLock.readLock().unlock();
        }
        catch (Throwable var10_12) {
            this.rwLock.readLock().unlock();
            tupleDataLogger = RSCacheLog.getTupleDataLogger();
            if (cacheHit) {
                if (tupleDataLogger.isOn(LogLevel.TRACE)) {
                    tupleDataLogger.log(LogLevel.TRACE, String.format("Cache hit in EdgeData.getTuple(long) for edge %d and tuple index %d.", new Object[]{this.edgeNumber, tupleIndex}));
                }
                RSCacheMetrics.getTupleHitCount().increment();
            } else {
                if (tupleDataLogger.isOn(LogLevel.TRACE)) {
                    tupleDataLogger.log(LogLevel.TRACE, String.format("Cache miss in EdgeData.getTuple(long) for edge %d and tuple index %d.", new Object[]{this.edgeNumber, tupleIndex}));
                }
                RSCacheMetrics.getTupleMissCount().increment();
            }
            throw var10_12;
        }
        tupleDataLogger = RSCacheLog.getTupleDataLogger();
        if (cacheHit) {
            if (tupleDataLogger.isOn(LogLevel.TRACE)) {
                tupleDataLogger.log(LogLevel.TRACE, String.format("Cache hit in EdgeData.getTuple(long) for edge %d and tuple index %d.", new Object[]{this.edgeNumber, tupleIndex}));
            }
            RSCacheMetrics.getTupleHitCount().increment();
        } else {
            if (tupleDataLogger.isOn(LogLevel.TRACE)) {
                tupleDataLogger.log(LogLevel.TRACE, String.format("Cache miss in EdgeData.getTuple(long) for edge %d and tuple index %d.", new Object[]{this.edgeNumber, tupleIndex}));
            }
            RSCacheMetrics.getTupleMissCount().increment();
        }
        return var8_10;
    }

    private void ensureCapacity(long capacity) {
        while (this.tupleCapacity < capacity) {
            this.addTupleBlock();
        }
    }

    private void addTupleBlock() {
        this.blocks.add(new IMember[this.membersPerBlock]);
        this.tupleCapacity += (long)this.tuplesPerBlock;
    }

    public boolean isEdgeComplete() {
        return this.edgeComplete;
    }

    public void setEdgeComplete() {
        this.edgeComplete = true;
    }

    public long getNumTuples() {
        return this.tupleCount;
    }

    public long getRetainedSize() {
        return (long)(ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.DEFAULT) + ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.OBJECTREFERENCE) + ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.PRIMITIVEBOOLEAN) + 3 * ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.PRIMITIVEINT) + 2 * ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.PRIMITIVELONG) + ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.ARRAYLIST)) + (long)this.dimensions.length * this.tupleCapacity * (long)ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.OBJECTREFERENCE);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (long tupleIndex = 0L; tupleIndex < this.tupleCount; ++tupleIndex) {
            ITuple tuple = this.getTuple(tupleIndex);
            sb.append(tuple.toString()).append("\n");
        }
        return sb.toString();
    }
}

