/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.rscache;

import com.cognos.xqe.data.providers.rscache.ResultSetData;
import com.cognos.xqe.data.providers.rscache.pool.DefaultRSCacheConfigLoader;
import com.cognos.xqe.data.providers.rscache.pool.IRSCacheConfigLoader;
import com.cognos.xqe.data.providers.rscache.pool.RSCacheFactory;
import com.cognos.xqe.data.providers.rscache.pool.RSCachePoolFactory;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionPool;
import com.cognos.xqe.pool.connection.IConnectionSelector;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.pool.connection.poolfactory.ConnectionPoolFactory;
import com.cognos.xqe.pool.connection.poolfactory.IProviderConnectionPool;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.util.SingletonHelper;

public final class ResultSetCacheManager {
    private IConnectionPool mGlobalRSCachePool;
    private RSCacheFactory mRSDataFactory;
    private RSCachePoolFactory mRSCachePoolFactory;
    private static SingletonHelper<ResultSetCacheManager> singletonHelper = new SingletonHelper<ResultSetCacheManager>(){

        @Override
        protected ResultSetCacheManager newInstance() {
            return new ResultSetCacheManager();
        }

        @Override
        protected void releaseImpl(ResultSetCacheManager theInstance) {
            theInstance.release();
        }

        @Override
        protected void initializeImpl(ResultSetCacheManager theInstance) {
        }
    };

    private ResultSetCacheManager() {
        ConnectionPoolFactory factory = new ConnectionPoolFactory();
        this.mRSCachePoolFactory = new RSCachePoolFactory(new DefaultRSCacheConfigLoader(), QueryEngine.getInstance().getTimer());
        this.mGlobalRSCachePool = factory.createPool(this.mRSCachePoolFactory);
        this.mRSDataFactory = new RSCacheFactory();
    }

    public static ResultSetCacheManager getInstance() {
        return singletonHelper.getInstance();
    }

    public static void releaseInstance() {
        singletonHelper.releaseInstance();
    }

    protected void release() {
        this.mGlobalRSCachePool.release();
    }

    public ResultSetData borrowResultSetData(String adapterName, ConnectionParameters connectionParameters, IConnectionSelector selector) {
        IPooledConnection connection = this.mGlobalRSCachePool.borrowConnection(adapterName, connectionParameters, selector, this.mRSDataFactory);
        ResultSetData rsData = (ResultSetData)connection.getConnection();
        rsData.setPooledConnection(connection);
        return rsData;
    }

    public void setConfigLoader(IRSCacheConfigLoader newLoader) {
        this.mRSCachePoolFactory.setConfigLoader(newLoader);
    }

    public void clearCache(String providerName) {
        IProviderConnectionPool pool = this.mGlobalRSCachePool.getOrCreateProviderConnectionPool(providerName);
        pool.returnAllBorrowedConnections();
        pool.release();
    }

    public int getIdleConnections(String providerName) {
        IProviderConnectionPool pool = this.mGlobalRSCachePool.getOrCreateProviderConnectionPool(providerName);
        return pool.getNumberOfIdleConnections();
    }

    public int getBorrowedConnections(String providerName) {
        IProviderConnectionPool pool = this.mGlobalRSCachePool.getOrCreateProviderConnectionPool(providerName);
        return pool.getNumberOfBorrowedConnections();
    }
}

