/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.rscache;

import com.cognos.xqe.data.providers.IProviderContextContainer;
import com.cognos.xqe.data.providers.connection.parameters.UserClassIDsParameter;
import com.cognos.xqe.data.providers.olap.DefaultConnection;
import com.cognos.xqe.data.providers.olap.MDXQueryArguments;
import com.cognos.xqe.data.providers.rscache.CachingProvider;
import com.cognos.xqe.data.providers.rscache.EdgeData;
import com.cognos.xqe.data.providers.rscache.IncompleteCacheException;
import com.cognos.xqe.data.providers.rscache.RSCacheLog;
import com.cognos.xqe.data.providers.rscache.RSCacheMetrics;
import com.cognos.xqe.data.providers.rscache.accessors.IResultSetAccessor;
import com.cognos.xqe.data.providers.rscache.accessors.inmemory.InMemoryResultSetAccessor;
import com.cognos.xqe.data.providers.rscache.accessors.real.RealResultSetAccessor;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.ISizable;
import com.cognos.xqe.util.StringBuilderWriter;
import com.cognos.xqe.util.concurrent.Gate;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ResultSetData
extends DefaultConnection
implements ISizable {
    private static final String ERRMSG_INDEX_WAS_NEGATIVE = "Index was negative: ";
    private static final String ERRMSG_INDEX_WAS_TOO_BIG = "Index was too big: ";
    private static final ITuple NO_SLICER = new Tuple();
    private final Map<Integer, EdgeData> edges = new HashMap<Integer, EdgeData>();
    private final Map<Integer, Long> edgeSizes = new HashMap<Integer, Long>();
    private final Map<Integer, ICell> cells = new HashMap<Integer, ICell>();
    private final BitSet nullCellMap = new BitSet();
    private final BitSet nonNullCellMap = new BitSet();
    private volatile int maxCellOrdinal = -1;
    private volatile boolean lastCellSeen = false;
    private volatile ITuple slicer = NO_SLICER;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final AtomicBoolean setupStarted = new AtomicBoolean(false);
    private final Gate setupCompleted = new Gate();
    private volatile RuntimeException setupError = null;
    private final AtomicLong nonNullCellsRetainedSize = new AtomicLong(0L);
    private Boolean hasData = null;

    public ResultSetData(ConnectionParameters params) {
        super(null);
        this.setConnectionParameters(params);
    }

    IResultSetAccessor createResultSetAccessor(CachingProvider provider, XDataContext dataContext, MDXQueryArguments args) {
        XQELogger dataLogger = RSCacheLog.getDataLogger();
        IResultSetAccessor acc = null;
        if (this.setupStarted.compareAndSet(false, true)) {
            RSCacheMetrics.getQueryMissCount().increment();
            try {
                ICubeResultSet rs = provider.queryRealProvider(dataContext, args);
                if (rs instanceof IProviderContextContainer) {
                    Object[] contexts = ((IProviderContextContainer)((Object)rs)).getContext();
                    this.setContext(contexts);
                }
                int numAxes = rs.getNumAxes();
                for (int edgeNo = 0; edgeNo < numAxes; ++edgeNo) {
                    this.addEdge(edgeNo, rs.getDimensions(edgeNo));
                    try {
                        this.setAxisSize(edgeNo, rs.getAxisSize(edgeNo));
                        continue;
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                }
                String userGroups = args.getDataSource().getDataSourceConnection().getUserGroups();
                if (userGroups != null && userGroups.length() > 0) {
                    this.getConnectionParameters().put(new UserClassIDsParameter(userGroups));
                }
                acc = new RealResultSetAccessor(this, rs);
            }
            catch (RuntimeException ex) {
                this.invalidate();
                this.setupError = ex;
                throw ex;
            }
            finally {
                this.setupCompleted.open();
            }
            if (dataLogger.isOn(LogLevel.INFO)) {
                dataLogger.log(LogLevel.INFO, "Creating RealResultSetAccessor for arguments " + args.toString());
            }
        } else {
            RSCacheMetrics.getQueryHitCount().increment();
            try {
                this.setupCompleted.await();
            }
            catch (InterruptedException e) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, e.getLocalizedMessage());
            }
            if (null != this.setupError) {
                throw this.setupError;
            }
            acc = new InMemoryResultSetAccessor(this);
            if (dataLogger.isOn(LogLevel.INFO)) {
                dataLogger.log(LogLevel.INFO, "Creating InMemoryResultSetAccessor for arguments " + args.toString());
            }
        }
        return acc;
    }

    public long getNumCells() {
        this.rwLock.readLock().lock();
        try {
            long l = this.cells.size();
            return l;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public long getCellsRetainedSize() {
        return this.nonNullCellsRetainedSize.get() + (long)(this.nonNullCellMap.size() / 8) + (long)(this.nullCellMap.size() / 8);
    }

    public long getNumTuples() {
        long count = 0L;
        for (EdgeData data : this.edges.values()) {
            count += data.getNumTuples();
        }
        return count;
    }

    public long getTuplesRetainedSize() {
        long size = 0L;
        for (EdgeData data : this.edges.values()) {
            size += data.getRetainedSize();
        }
        return size;
    }

    @Override
    public long getSize() {
        return this.getTuplesRetainedSize() + this.getCellsRetainedSize();
    }

    public boolean wasLastCellSeen() {
        return this.lastCellSeen;
    }

    public void setLastCellSeen() {
        this.lastCellSeen = true;
    }

    public ICell getCell(int ordinal, boolean executeLoggingAndMetrics) {
        block23: {
            ICell iCell;
            block24: {
                boolean cacheHit;
                block21: {
                    ICell iCell2;
                    block22: {
                        if (ordinal < 0) {
                            throw new IndexOutOfBoundsException(ERRMSG_INDEX_WAS_NEGATIVE + ordinal);
                        }
                        cacheHit = false;
                        this.rwLock.readLock().lock();
                        try {
                            if (ordinal > this.maxCellOrdinal) {
                                if (this.lastCellSeen) {
                                    throw new IndexOutOfBoundsException(ERRMSG_INDEX_WAS_TOO_BIG + ordinal);
                                }
                                throw new IncompleteCacheException(ordinal);
                            }
                            if (!this.nullCellMap.get(ordinal)) break block21;
                            cacheHit = true;
                            iCell2 = null;
                            this.rwLock.readLock().unlock();
                            if (!executeLoggingAndMetrics) break block22;
                        }
                        catch (Throwable throwable) {
                            this.rwLock.readLock().unlock();
                            if (executeLoggingAndMetrics) {
                                XQELogger cellDataLogger = RSCacheLog.getCellDataLogger();
                                if (cacheHit) {
                                    if (cellDataLogger.isOn(LogLevel.TRACE)) {
                                        cellDataLogger.log(LogLevel.TRACE, String.format("Cache hit in ResultSetData.getCell(int) for ordinal %d.", ordinal));
                                    }
                                    RSCacheMetrics.getCellHitCount().increment();
                                } else {
                                    if (cellDataLogger.isOn(LogLevel.TRACE)) {
                                        cellDataLogger.log(LogLevel.TRACE, String.format("Cache miss in ResultSetData.getCell(int) for ordinal %d.", ordinal));
                                    }
                                    RSCacheMetrics.getCellMissCount().increment();
                                }
                            }
                            throw throwable;
                        }
                        XQELogger cellDataLogger = RSCacheLog.getCellDataLogger();
                        if (cacheHit) {
                            if (cellDataLogger.isOn(LogLevel.TRACE)) {
                                cellDataLogger.log(LogLevel.TRACE, String.format("Cache hit in ResultSetData.getCell(int) for ordinal %d.", ordinal));
                            }
                            RSCacheMetrics.getCellHitCount().increment();
                        } else {
                            if (cellDataLogger.isOn(LogLevel.TRACE)) {
                                cellDataLogger.log(LogLevel.TRACE, String.format("Cache miss in ResultSetData.getCell(int) for ordinal %d.", ordinal));
                            }
                            RSCacheMetrics.getCellMissCount().increment();
                        }
                    }
                    return iCell2;
                }
                if (!this.nonNullCellMap.get(ordinal)) break block23;
                ICell cell = this.cells.get(ordinal);
                if (null == cell) {
                    throw new IllegalStateException("Cell data was missing for oridinal " + ordinal);
                }
                cacheHit = true;
                iCell = cell;
                this.rwLock.readLock().unlock();
                if (!executeLoggingAndMetrics) break block24;
                XQELogger cellDataLogger = RSCacheLog.getCellDataLogger();
                if (cacheHit) {
                    if (cellDataLogger.isOn(LogLevel.TRACE)) {
                        cellDataLogger.log(LogLevel.TRACE, String.format("Cache hit in ResultSetData.getCell(int) for ordinal %d.", ordinal));
                    }
                    RSCacheMetrics.getCellHitCount().increment();
                } else {
                    if (cellDataLogger.isOn(LogLevel.TRACE)) {
                        cellDataLogger.log(LogLevel.TRACE, String.format("Cache miss in ResultSetData.getCell(int) for ordinal %d.", ordinal));
                    }
                    RSCacheMetrics.getCellMissCount().increment();
                }
            }
            return iCell;
        }
        throw new IncompleteCacheException(ordinal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int getNextNonNullCellPos(int start, boolean executeLoggingAndMetrics) {
        block27: {
            block25: {
                block26: {
                    block23: {
                        block24: {
                            if (start < 0) {
                                throw new IndexOutOfBoundsException("Index was negative: " + start);
                            }
                            cacheHit = false;
                            this.rwLock.readLock().lock();
                            try {
                                if (start <= this.maxCellOrdinal) ** GOTO lbl39
                                if (!this.lastCellSeen) break block23;
                                cacheHit = true;
                                var4_4 = -1;
                                this.rwLock.readLock().unlock();
                                if (!executeLoggingAndMetrics) break block24;
                            }
                            catch (Throwable var7_11) {
                                this.rwLock.readLock().unlock();
                                if (executeLoggingAndMetrics) {
                                    cellDataLogger = RSCacheLog.getCellDataLogger();
                                    if (cacheHit) {
                                        if (cellDataLogger.isOn(LogLevel.TRACE)) {
                                            cellDataLogger.log(LogLevel.TRACE, String.format("Cache hit in ResultSetData.getNextNonNullCellPos(int) for start ordinal %d.", new Object[]{start}));
                                        }
                                        RSCacheMetrics.getCellHitCount().increment();
                                    } else {
                                        if (cellDataLogger.isOn(LogLevel.TRACE)) {
                                            cellDataLogger.log(LogLevel.TRACE, String.format("Cache miss in ResultSetData.getNextNonNullCellPos(int) for start ordinal %d.", new Object[]{start}));
                                        }
                                        RSCacheMetrics.getCellMissCount().increment();
                                    }
                                }
                                throw var7_11;
                            }
                            cellDataLogger = RSCacheLog.getCellDataLogger();
                            if (cacheHit) {
                                if (cellDataLogger.isOn(LogLevel.TRACE)) {
                                    cellDataLogger.log(LogLevel.TRACE, String.format("Cache hit in ResultSetData.getNextNonNullCellPos(int) for start ordinal %d.", new Object[]{start}));
                                }
                                RSCacheMetrics.getCellHitCount().increment();
                            } else {
                                if (cellDataLogger.isOn(LogLevel.TRACE)) {
                                    cellDataLogger.log(LogLevel.TRACE, String.format("Cache miss in ResultSetData.getNextNonNullCellPos(int) for start ordinal %d.", new Object[]{start}));
                                }
                                RSCacheMetrics.getCellMissCount().increment();
                            }
                        }
                        return var4_4;
                    }
                    throw new IncompleteCacheException(start);
lbl39:
                    // 1 sources

                    nextNonNullPos = this.nullCellMap.nextClearBit(start);
                    if (nextNonNullPos == -1 || nextNonNullPos > this.maxCellOrdinal) ** GOTO lbl60
                    if (!this.nonNullCellMap.get(nextNonNullPos)) break block25;
                    cacheHit = true;
                    var5_7 = nextNonNullPos;
                    this.rwLock.readLock().unlock();
                    if (!executeLoggingAndMetrics) break block26;
                    cellDataLogger = RSCacheLog.getCellDataLogger();
                    if (cacheHit) {
                        if (cellDataLogger.isOn(LogLevel.TRACE)) {
                            cellDataLogger.log(LogLevel.TRACE, String.format("Cache hit in ResultSetData.getNextNonNullCellPos(int) for start ordinal %d.", new Object[]{start}));
                        }
                        RSCacheMetrics.getCellHitCount().increment();
                    } else {
                        if (cellDataLogger.isOn(LogLevel.TRACE)) {
                            cellDataLogger.log(LogLevel.TRACE, String.format("Cache miss in ResultSetData.getNextNonNullCellPos(int) for start ordinal %d.", new Object[]{start}));
                        }
                        RSCacheMetrics.getCellMissCount().increment();
                    }
                }
                return var5_7;
            }
            throw new IncompleteCacheException(start);
lbl60:
            // 1 sources

            if (!this.lastCellSeen) {
                throw new IncompleteCacheException(start);
            }
            cacheHit = true;
            var5_8 = -1;
            this.rwLock.readLock().unlock();
            if (!executeLoggingAndMetrics) break block27;
            cellDataLogger = RSCacheLog.getCellDataLogger();
            if (cacheHit) {
                if (cellDataLogger.isOn(LogLevel.TRACE)) {
                    cellDataLogger.log(LogLevel.TRACE, String.format("Cache hit in ResultSetData.getNextNonNullCellPos(int) for start ordinal %d.", new Object[]{start}));
                }
                RSCacheMetrics.getCellHitCount().increment();
            } else {
                if (cellDataLogger.isOn(LogLevel.TRACE)) {
                    cellDataLogger.log(LogLevel.TRACE, String.format("Cache miss in ResultSetData.getNextNonNullCellPos(int) for start ordinal %d.", new Object[]{start}));
                }
                RSCacheMetrics.getCellMissCount().increment();
            }
        }
        return var5_8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCell(int idx, ICell theCell) {
        if (null == theCell) {
            throw new IllegalArgumentException("theCell was null.");
        }
        this.rwLock.readLock().lock();
        try {
            if (this.nonNullCellMap.get(idx)) {
                return;
            }
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        ICell cellCopy = (ICell)theCell.copy();
        this.rwLock.writeLock().lock();
        try {
            if (idx > this.maxCellOrdinal) {
                this.maxCellOrdinal = idx;
            }
            this.nonNullCellMap.set(idx);
            this.cells.put(idx, cellCopy);
            this.nonNullCellsRetainedSize.addAndGet(cellCopy.sizeOf());
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        XQELogger cellDataLogger = RSCacheLog.getCellDataLogger();
        if (cellDataLogger.isOn(LogLevel.TRACE)) {
            cellDataLogger.log(LogLevel.TRACE, String.format("Stored cell in ResultSetData.addCell(int, ICell) with ordinal %d and value %s.", theCell.getOrdinal(), theCell.getValue().toString()));
        }
    }

    public void addCellNulls(int from, int to) {
        this.rwLock.writeLock().lock();
        try {
            if (to - 1 > this.maxCellOrdinal) {
                this.maxCellOrdinal = to - 1;
            }
            this.nullCellMap.set(from, to);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        XQELogger cellDataLogger = RSCacheLog.getCellDataLogger();
        if (cellDataLogger.isOn(LogLevel.TRACE)) {
            cellDataLogger.log(LogLevel.TRACE, String.format("Stored null cell(s) in ResultSetData.addCellNulls(int, int) from %d (inclusive) to %d (exclusive).", from, to));
        }
    }

    public Boolean hasData() {
        if (null != this.hasData) {
            return this.hasData;
        }
        this.rwLock.readLock().lock();
        try {
            if (!this.nonNullCellMap.isEmpty()) {
                Boolean bl = this.hasData = Boolean.valueOf(true);
                return bl;
            }
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean hasData(int from, int to) {
        if (null != this.hasData && !this.hasData.booleanValue()) {
            return false;
        }
        this.rwLock.readLock().lock();
        try {
            int nextCellOrdinal = this.nonNullCellMap.nextSetBit(from);
            if (nextCellOrdinal >= 0 && nextCellOrdinal <= to) {
                Boolean bl = true;
                return bl;
            }
            if (this.nullCellMap.nextClearBit(from) > to) {
                Boolean bl = false;
                return bl;
            }
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        return null;
    }

    public ITuple getSlicer() {
        if (this.slicer == NO_SLICER) {
            throw new IncompleteCacheException(-1L);
        }
        return this.slicer;
    }

    public IDimension[] getDimensions(int edgeNo) {
        EdgeData data = this.edges.get(edgeNo);
        return data.getDimensions();
    }

    public int getNumEdges() {
        return this.edges.size();
    }

    public void setSlicer(ITuple tuple) {
        this.slicer = tuple;
    }

    public EdgeData addEdge(int edgeNo, IDimension[] dimensions) {
        if (this.setupCompleted.isOpen()) {
            throw new IllegalStateException("Edges may not be defined after setup is complete.");
        }
        EdgeData data = new EdgeData(edgeNo, dimensions);
        this.edges.put(edgeNo, data);
        return data;
    }

    public EdgeData getEdge(int edgeNo) {
        return this.edges.get(edgeNo);
    }

    @Override
    public String toString() {
        return this.getConnectionParameters().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAxisSize(int edgeNo) {
        this.rwLock.readLock().lock();
        try {
            Long size = this.edgeSizes.get(edgeNo);
            if (size == null) {
                throw new IllegalStateException("Edge sizes not initialized for edge " + edgeNo);
            }
            long l = size;
            return l;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAxisSize(int edgeNo, long size) {
        this.rwLock.writeLock().lock();
        try {
            this.edgeSizes.put(edgeNo, size);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public int getMaxCellOrdinal() {
        this.rwLock.readLock().lock();
        try {
            int n = this.maxCellOrdinal;
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public void debugPrint(StringBuilder buffer) {
        this.debugPrint(new StringBuilderWriter(buffer));
    }

    public void debugPrint(Writer writer) {
        this.debugPrint(new PrintWriter(writer));
    }

    public void debugPrint(PrintWriter writer) {
        writer.println(">> Parameters:");
        writer.println(this.getConnectionParameters());
        writer.println();
        writer.println(">> Cells:");
        for (int i = 0; i < this.maxCellOrdinal; ++i) {
            boolean isNull = this.nullCellMap.get(i);
            ICell cell = this.cells.get(i);
            if (isNull) {
                writer.printf("%d  NULL\n", i);
                continue;
            }
            if (null != cell) {
                writer.printf("%d  [ordinal=%d, value=%s]\n", i, cell.getOrdinal(), cell.getValue().toString());
                continue;
            }
            writer.printf("%d  ?\n", i);
        }
        writer.println();
        for (Map.Entry<Integer, EdgeData> e : this.edges.entrySet()) {
            int edgeNo = e.getKey();
            EdgeData data = e.getValue();
            writer.println(">> Edge " + edgeNo);
            for (long i = 0L; i < data.getNumTuples(); ++i) {
                writer.println(data.getTuple(i).toString());
            }
        }
        writer.println();
        writer.println(">> Slicer:");
        writer.println(this.slicer.toString());
    }
}

