/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.rscache.accessors.real;

import com.cognos.xqe.data.providers.rscache.RSCacheLog;
import com.cognos.xqe.data.providers.rscache.ResultSetData;
import com.cognos.xqe.data.providers.rscache.accessors.ICellIteratorAccessor;
import com.cognos.xqe.data.providers.rscache.accessors.IEdgeIteratorAccessor;
import com.cognos.xqe.data.providers.rscache.accessors.IResultSetAccessor;
import com.cognos.xqe.data.providers.rscache.accessors.real.RealCellIteratorAccessor;
import com.cognos.xqe.data.providers.rscache.accessors.real.RealEdgeIteratorAccessor;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;

public class RealResultSetAccessor
implements IResultSetAccessor {
    private final ResultSetData data;
    private ICubeResultSet resultSet;

    public RealResultSetAccessor(ResultSetData theData, ICubeResultSet theResultSet) {
        this.data = theData;
        this.resultSet = theResultSet;
    }

    @Override
    public IDimension[] getDimensions(int edgeNo) {
        IDimension[] dim;
        try {
            dim = this.resultSet.getDimensions(edgeNo);
        }
        catch (RuntimeException e) {
            this.data.invalidate();
            throw e;
        }
        return dim;
    }

    @Override
    public int getNumEdges() {
        int num;
        try {
            num = this.resultSet.getNumAxes();
        }
        catch (RuntimeException e) {
            this.data.invalidate();
            throw e;
        }
        return num;
    }

    @Override
    public ITuple getSlicer() {
        ITuple slicer;
        try {
            slicer = this.resultSet.getSlicer();
        }
        catch (RuntimeException e) {
            this.data.invalidate();
            throw e;
        }
        this.data.setSlicer(slicer);
        return slicer;
    }

    @Override
    public ICellIteratorAccessor getCellIterator(boolean scrollable) {
        XCellIterator iter;
        try {
            iter = scrollable ? this.resultSet.getScrollableCellIterator() : this.resultSet.getCellIterator();
        }
        catch (RuntimeException e) {
            this.data.invalidate();
            throw e;
        }
        return new RealCellIteratorAccessor(this.data, iter);
    }

    @Override
    public IEdgeIteratorAccessor getEdgeIterator(int edgeNo) {
        XIterator it;
        try {
            it = this.resultSet.getAxisIterator(edgeNo);
        }
        catch (RuntimeException e) {
            this.data.invalidate();
            throw e;
        }
        return new RealEdgeIteratorAccessor(this.data, edgeNo, it);
    }

    @Override
    public long getAxisSize(int edgeNo) {
        long size;
        try {
            size = this.resultSet.getAxisSize(edgeNo);
        }
        catch (RuntimeException e) {
            this.data.invalidate();
            throw e;
        }
        this.data.setAxisSize(edgeNo, size);
        return size;
    }

    @Override
    public void release() {
        XQELogger dataLogger;
        if (null != this.resultSet) {
            this.resultSet.release();
            this.resultSet = null;
        }
        if ((dataLogger = RSCacheLog.getDataLogger()).isOn(LogLevel.TRACE)) {
            StringBuilder buffer = new StringBuilder("Releasing RealResultSetAccessor with cached data:\n");
            this.data.debugPrint(buffer);
            dataLogger.log(LogLevel.TRACE, buffer.toString());
        }
    }

    @Override
    public ResultSetData getCachedData() {
        return this.data;
    }
}

