/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.types;

import com.cognos.xqe.ast.sql.parser.ParseException;
import com.cognos.xqe.ast.sql.parser.SQLProcessor;
import com.cognos.xqe.data.DataType;
import com.cognos.xqe.data.types.AnyType;
import com.cognos.xqe.data.types.ArrayType;
import com.cognos.xqe.data.types.BinaryType;
import com.cognos.xqe.data.types.BlobType;
import com.cognos.xqe.data.types.BooleanType;
import com.cognos.xqe.data.types.BusinessKeyType;
import com.cognos.xqe.data.types.CharType;
import com.cognos.xqe.data.types.ClobType;
import com.cognos.xqe.data.types.ContextValueType;
import com.cognos.xqe.data.types.CurrencyCodeType;
import com.cognos.xqe.data.types.DataLinkType;
import com.cognos.xqe.data.types.DateType;
import com.cognos.xqe.data.types.DecimalType;
import com.cognos.xqe.data.types.DimensionUniqueNameType;
import com.cognos.xqe.data.types.DoubleType;
import com.cognos.xqe.data.types.FloatType;
import com.cognos.xqe.data.types.HierarchyUniqueNameType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.data.types.IntervalDayTimeType;
import com.cognos.xqe.data.types.IntervalQualifier;
import com.cognos.xqe.data.types.IntervalType;
import com.cognos.xqe.data.types.IntervalYearMonthType;
import com.cognos.xqe.data.types.JSONType;
import com.cognos.xqe.data.types.LevelLabelType;
import com.cognos.xqe.data.types.LevelNumberType;
import com.cognos.xqe.data.types.LevelType;
import com.cognos.xqe.data.types.LevelUniqueNameType;
import com.cognos.xqe.data.types.LongType;
import com.cognos.xqe.data.types.MapType;
import com.cognos.xqe.data.types.MeasureType;
import com.cognos.xqe.data.types.MemberCaptionType;
import com.cognos.xqe.data.types.MemberDescriptionType;
import com.cognos.xqe.data.types.MemberRollupType;
import com.cognos.xqe.data.types.MemberType;
import com.cognos.xqe.data.types.MemberUniqueNameType;
import com.cognos.xqe.data.types.MultiPartBusinessKeyType;
import com.cognos.xqe.data.types.MultisetType;
import com.cognos.xqe.data.types.NCharType;
import com.cognos.xqe.data.types.NVarcharType;
import com.cognos.xqe.data.types.NullArgType;
import com.cognos.xqe.data.types.NullType;
import com.cognos.xqe.data.types.NumericType;
import com.cognos.xqe.data.types.ObjectType;
import com.cognos.xqe.data.types.PPDSCodeType;
import com.cognos.xqe.data.types.ParentLevelNumberType;
import com.cognos.xqe.data.types.ParentUniqueNameType;
import com.cognos.xqe.data.types.PeriodType;
import com.cognos.xqe.data.types.QueryItemModelIDType;
import com.cognos.xqe.data.types.RefType;
import com.cognos.xqe.data.types.RowType;
import com.cognos.xqe.data.types.SmallintType;
import com.cognos.xqe.data.types.StringType;
import com.cognos.xqe.data.types.StructType;
import com.cognos.xqe.data.types.TextType;
import com.cognos.xqe.data.types.TimeType;
import com.cognos.xqe.data.types.TimeWithTZType;
import com.cognos.xqe.data.types.TimestampType;
import com.cognos.xqe.data.types.TimestampWithTZType;
import com.cognos.xqe.data.types.TinyintType;
import com.cognos.xqe.data.types.UnknownType;
import com.cognos.xqe.data.types.VarBinaryType;
import com.cognos.xqe.data.types.VarcharType;
import com.cognos.xqe.data.types.VariantType;
import com.cognos.xqe.data.types.XmlType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class DataTypeFactory {
    private static Map<Long, SmallintType> smallintTypePool = new ConcurrentHashMap<Long, SmallintType>();
    private static Map<Long, IntegerType> integerTypePool = new ConcurrentHashMap<Long, IntegerType>();
    private static Map<Long, LongType> longTypePool = new ConcurrentHashMap<Long, LongType>();
    private static Map<Long, DecimalType> decimalTypePool = new ConcurrentHashMap<Long, DecimalType>();

    private DataTypeFactory() {
    }

    public static TinyintType getTinyintType() {
        return TinyintType.TINYINTTYPE;
    }

    public static SmallintType getSmallintType() {
        return SmallintType.SMALLINTTYPE;
    }

    public static SmallintType getSmallintType(int scale) {
        return DataTypeFactory.getSmallintType(5, scale);
    }

    public static SmallintType getSmallintType(int precision, int scale) {
        long key = (long)precision << 32 | (long)scale;
        SmallintType type = smallintTypePool.get(key);
        if (type == null) {
            type = new SmallintType(precision, scale);
            smallintTypePool.put(key, type);
        }
        return type;
    }

    public static IntegerType getIntegerType() {
        return IntegerType.INTEGERTYPE;
    }

    public static IntegerType getIntegerType(int scale) {
        return DataTypeFactory.getIntegerType(10, scale);
    }

    public static IntegerType getIntegerType(int precision, int scale) {
        long key = (long)precision << 32 | (long)scale;
        IntegerType type = integerTypePool.get(key);
        if (type == null) {
            type = new IntegerType(precision, scale);
            integerTypePool.put(key, type);
        }
        return type;
    }

    public static LongType getLongType() {
        return LongType.LONGTYPE;
    }

    public static LongType getLongType(int scale) {
        return DataTypeFactory.getLongType(19, scale);
    }

    public static VariantType getVariantType() {
        return VariantType.VARIANT;
    }

    public static LongType getLongType(int precision, int scale) {
        long key = (long)precision << 32 | (long)scale;
        LongType type = longTypePool.get(key);
        if (type == null) {
            type = new LongType(precision, scale);
            longTypePool.put(key, type);
        }
        return type;
    }

    public static FloatType getFloatType() {
        return FloatType.FLOATTYPE;
    }

    public static DoubleType getDoubleType() {
        return DoubleType.DOUBLETYPE;
    }

    public static DecimalType getDecimalType() {
        return DecimalType.DEFAULT_DECIMALTYPE;
    }

    public static DecimalType getDecimalType(int precision, int scale) {
        long key = (long)precision << 32 | (long)scale;
        DecimalType type = decimalTypePool.get(key);
        if (type == null) {
            type = new DecimalType(precision, scale);
            decimalTypePool.put(key, type);
        }
        return type;
    }

    public static DecimalType getDecimalType(int precision) {
        return DataTypeFactory.getDecimalType(precision, 0);
    }

    public static BooleanType getBooleanType() {
        return BooleanType.BOOLEANTYPE;
    }

    public static DateType getDateType() {
        return DateType.DATETYPE;
    }

    public static TimeType getTimeType() {
        return TimeType.TIMETYPE;
    }

    public static TimeType getTimeType(int fSecondsPrecision) {
        return new TimeType(fSecondsPrecision);
    }

    public static TimeWithTZType getTimeWithTZType() {
        return TimeWithTZType.TIMEWITHTZTYPE;
    }

    public static TimeWithTZType getTimeWithTZType(int fSecondsPrecision) {
        return new TimeWithTZType(fSecondsPrecision);
    }

    public static TimestampType getTimestampType() {
        return TimestampType.TIMESTAMPTYPE;
    }

    public static TimestampType getTimestampType(int fSecondsPrecision) {
        return new TimestampType(fSecondsPrecision);
    }

    public static TimestampWithTZType getTimestampWithTZType() {
        return TimestampWithTZType.TIMESTAMPWITHTZTYPE;
    }

    public static TimestampWithTZType getTimestampWithTZType(int fSecondsPrecision) {
        return new TimestampWithTZType(fSecondsPrecision);
    }

    public static IntervalYearMonthType getIntervalYearMonthType() {
        return IntervalYearMonthType.DEFAULT_INTERVALYEARMONTHTYPE;
    }

    public static IntervalYearMonthType getIntervalYearMonthType(IntervalQualifier pQualifier) {
        return new IntervalYearMonthType(pQualifier);
    }

    public static IntervalYearMonthType getIntervalYearMonthType(IntervalQualifier pQualifier, int leadPrecision) {
        return new IntervalYearMonthType(pQualifier, leadPrecision);
    }

    public static IntervalDayTimeType getIntervalDayTimeType() {
        return IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE;
    }

    public static IntervalDayTimeType getIntervalDayTimeType(IntervalQualifier pQualifier) {
        return new IntervalDayTimeType(pQualifier);
    }

    public static IntervalDayTimeType getIntervalDayTimeType(IntervalQualifier pQualifier, int leadPrecision) {
        return new IntervalDayTimeType(pQualifier, leadPrecision);
    }

    public static IntervalDayTimeType getIntervalDayTimeType(IntervalQualifier pQualifier, int leadPrecision, int fractionalSecondsValue) {
        return new IntervalDayTimeType(pQualifier, leadPrecision, fractionalSecondsValue);
    }

    public static IntervalType getIntervalType(IntervalQualifier fromType, IntervalQualifier toType, int leadPrecision, int fSecondsPrecision) {
        IntervalType dType;
        IntervalQualifier qualifier = IntervalQualifier.INTERVAL_UNKNOWN;
        if (toType == IntervalQualifier.INTERVAL_UNKNOWN) {
            dType = fromType == IntervalQualifier.INTERVAL_YEAR || fromType == IntervalQualifier.INTERVAL_MONTH ? DataTypeFactory.getIntervalYearMonthType(fromType, leadPrecision) : DataTypeFactory.getIntervalDayTimeType(fromType, leadPrecision, fSecondsPrecision);
        } else if (fromType == IntervalQualifier.INTERVAL_YEAR) {
            dType = DataTypeFactory.getIntervalYearMonthType(IntervalQualifier.INTERVAL_YEAR_TO_MONTH, leadPrecision);
        } else {
            block0 : switch (fromType) {
                case INTERVAL_DAY: {
                    switch (toType) {
                        case INTERVAL_HOUR: {
                            qualifier = IntervalQualifier.INTERVAL_DAY_TO_HOUR;
                            break block0;
                        }
                        case INTERVAL_MINUTE: {
                            qualifier = IntervalQualifier.INTERVAL_DAY_TO_MINUTE;
                            break block0;
                        }
                        case INTERVAL_SECOND: {
                            qualifier = IntervalQualifier.INTERVAL_DAY_TO_SECOND;
                            break block0;
                        }
                    }
                    break;
                }
                case INTERVAL_HOUR: {
                    switch (toType) {
                        case INTERVAL_MINUTE: {
                            qualifier = IntervalQualifier.INTERVAL_HOUR_TO_MINUTE;
                            break block0;
                        }
                        case INTERVAL_SECOND: {
                            qualifier = IntervalQualifier.INTERVAL_HOUR_TO_SECOND;
                            break block0;
                        }
                    }
                    break;
                }
                case INTERVAL_MINUTE: {
                    switch (toType) {
                        case INTERVAL_SECOND: {
                            qualifier = IntervalQualifier.INTERVAL_MINUTE_TO_SECOND;
                            break block0;
                        }
                    }
                    break;
                }
            }
            dType = DataTypeFactory.getIntervalDayTimeType(qualifier, leadPrecision, fSecondsPrecision);
        }
        return dType;
    }

    public static IntervalType getIntervalType(String start, String end, int leadPrecision, int fSecondsPrecision) {
        IntervalQualifier toType = IntervalQualifier.INTERVAL_UNKNOWN;
        if (end != null) {
            toType = IntervalQualifier.get(end);
        }
        return DataTypeFactory.getIntervalType(IntervalQualifier.get(start), toType, leadPrecision, fSecondsPrecision);
    }

    public static PeriodType getPeriodType(IDataType baseType) {
        byte cclDType;
        if (baseType == null) {
            baseType = DataTypeFactory.getTimestampWithTZType();
        }
        int dType = (cclDType = baseType.getCCLTypeCode()) == 57 ? 108 : (cclDType == 58 ? 109 : (cclDType == 52 ? 110 : (cclDType == 59 ? 111 : 112)));
        return new PeriodType((byte)dType, baseType);
    }

    public static StringType getStringType() {
        return StringType.DEFAULTSTRINGTYPE;
    }

    public static CharType getCharType(int length) {
        return new CharType(length);
    }

    public static CharType getCharType() {
        return CharType.DEFAULTCHARTYPE;
    }

    public static NCharType getNCharType(int length) {
        return new NCharType(length);
    }

    public static NCharType getNCharType() {
        return NCharType.DEFAULTNCHARTYPE;
    }

    public static VarcharType getVarcharType(int length) {
        return new VarcharType(length);
    }

    public static VarcharType getVarcharType() {
        return VarcharType.DEFAULTVARCHARTYPE;
    }

    public static NVarcharType getNVarcharType(int length) {
        return new NVarcharType(length);
    }

    public static NVarcharType getNVarcharType() {
        return NVarcharType.DEFAULTNVARCHARTYPE;
    }

    public static BlobType getBlobType() {
        return BlobType.BLOBTYPE;
    }

    public static ClobType getClobType() {
        return ClobType.CLOBTYPE;
    }

    public static XmlType getXmlType() {
        return XmlType.XMLTYPE;
    }

    public static JSONType getJSONType() {
        return JSONType.JSONTYPE;
    }

    public static RowType getRowType() {
        return new RowType();
    }

    public static ObjectType getObjectType() {
        return ObjectType.OBJECTTYPE;
    }

    public static RefType getRefType() {
        return RefType.REFTYPE;
    }

    public static NullType getNullType() {
        return NullType.NULLTYPE;
    }

    public static UnknownType getUnknownType() {
        return UnknownType.UNKNOWNTYPE;
    }

    public static NullArgType getNullArgType() {
        return NullArgType.NULLARGTYPE;
    }

    public static DataLinkType getDataLinkType() {
        return DataLinkType.DATALINKTYPE;
    }

    public static RowType getRowType(IDataType[] columnTypes) {
        return new RowType(columnTypes);
    }

    public static RowType getRowType(String[] names, IDataType[] columnTypes) {
        RowType dType = new RowType();
        for (int i = 0; i < names.length; ++i) {
            dType.addField(names[i], columnTypes[i]);
        }
        return dType;
    }

    public static IDataType getDataType(byte cclDType) {
        DataType dType = null;
        switch (cclDType) {
            case 1: {
                dType = DataTypeFactory.getStringType();
                break;
            }
            case 45: {
                dType = DataTypeFactory.getVarcharType();
                break;
            }
            case 55: {
                dType = DataTypeFactory.getNCharType();
                break;
            }
            case 56: {
                dType = DataTypeFactory.getNVarcharType();
                break;
            }
            case 51: {
                dType = DataTypeFactory.getBooleanType();
                break;
            }
            case 23: {
                dType = DataTypeFactory.getBinaryType();
                break;
            }
            case 24: {
                dType = DataTypeFactory.getVarBinaryType();
                break;
            }
            case 2: {
                dType = DataTypeFactory.getTinyintType();
                break;
            }
            case 4: {
                dType = DataTypeFactory.getSmallintType();
                break;
            }
            case 6: {
                dType = DataTypeFactory.getIntegerType();
                break;
            }
            case 8: {
                dType = DataTypeFactory.getLongType();
                break;
            }
            case 10: {
                dType = DataTypeFactory.getFloatType();
                break;
            }
            case 11: {
                dType = DataTypeFactory.getDoubleType();
                break;
            }
            case 12: 
            case 54: {
                dType = DataTypeFactory.getDecimalType();
                break;
            }
            case 57: {
                dType = DataTypeFactory.getDateType();
                break;
            }
            case 58: {
                dType = DataTypeFactory.getTimeType();
                break;
            }
            case 59: {
                dType = DataTypeFactory.getTimestampType();
                break;
            }
            case 52: {
                dType = DataTypeFactory.getTimeWithTZType();
                break;
            }
            case 53: {
                dType = DataTypeFactory.getTimestampWithTZType();
                break;
            }
            case 60: {
                dType = DataTypeFactory.getIntervalDayTimeType();
                break;
            }
            case 17: {
                dType = DataTypeFactory.getIntervalYearMonthType();
                break;
            }
            case 22: {
                dType = DataTypeFactory.getVariantType();
                break;
            }
            case 105: {
                dType = DataTypeFactory.getObjectType();
                break;
            }
            case 100: {
                dType = DataTypeFactory.getXmlType();
                break;
            }
            case 33: {
                dType = DataTypeFactory.getLevelNumberType();
                break;
            }
            case 18: {
                dType = DataTypeFactory.getBlobType();
                break;
            }
            case 46: {
                dType = DataTypeFactory.getClobType();
                break;
            }
            case 107: {
                dType = DataTypeFactory.getNullType();
                break;
            }
            case 48: {
                dType = DataTypeFactory.getDataLinkType();
                break;
            }
            case 102: {
                dType = DataTypeFactory.getArrayType();
                break;
            }
            case 103: {
                dType = DataTypeFactory.getMultisetType();
                break;
            }
            case 101: {
                dType = DataTypeFactory.getRowType();
                break;
            }
            case 104: {
                dType = DataTypeFactory.getStructType();
                break;
            }
            case 113: {
                dType = DataTypeFactory.getMapType(null, null);
                break;
            }
            case 114: {
                dType = DataTypeFactory.getJSONType();
                break;
            }
        }
        return dType;
    }

    public static IDataType getDataType(byte cclDType, int precision, int scale) {
        DataType dType = null;
        switch (cclDType) {
            case 1: {
                dType = DataTypeFactory.getStringType();
                break;
            }
            case 45: {
                dType = DataTypeFactory.getVarcharType(precision);
                break;
            }
            case 55: {
                dType = DataTypeFactory.getNCharType(precision);
                break;
            }
            case 56: {
                dType = DataTypeFactory.getNVarcharType(precision);
                break;
            }
            case 51: {
                dType = DataTypeFactory.getBooleanType();
                break;
            }
            case 23: {
                dType = DataTypeFactory.getBinaryType();
                break;
            }
            case 24: {
                dType = DataTypeFactory.getVarBinaryType();
                break;
            }
            case 2: {
                dType = DataTypeFactory.getTinyintType();
                break;
            }
            case 4: {
                dType = DataTypeFactory.getSmallintType(precision, scale);
                break;
            }
            case 6: {
                dType = DataTypeFactory.getIntegerType(precision, scale);
                break;
            }
            case 8: {
                dType = DataTypeFactory.getLongType(precision, scale);
                break;
            }
            case 10: {
                dType = DataTypeFactory.getFloatType();
                break;
            }
            case 11: {
                dType = DataTypeFactory.getDoubleType();
                break;
            }
            case 12: 
            case 54: {
                dType = DataTypeFactory.getDecimalType(precision, scale);
                break;
            }
            case 57: {
                dType = DataTypeFactory.getDateType();
                break;
            }
            case 58: {
                dType = DataTypeFactory.getTimeType();
                break;
            }
            case 59: {
                dType = DataTypeFactory.getTimestampType();
                break;
            }
            case 52: {
                dType = DataTypeFactory.getTimeWithTZType();
                break;
            }
            case 53: {
                dType = DataTypeFactory.getTimeWithTZType();
                break;
            }
            case 60: {
                dType = DataTypeFactory.getIntervalDayTimeType();
                break;
            }
            case 17: {
                dType = DataTypeFactory.getIntervalYearMonthType();
                break;
            }
            case 22: {
                dType = DataTypeFactory.getVariantType();
                break;
            }
            case 105: {
                dType = DataTypeFactory.getObjectType();
                break;
            }
            case 100: {
                dType = DataTypeFactory.getXmlType();
                break;
            }
            case 33: {
                dType = DataTypeFactory.getLevelNumberType();
                break;
            }
            case 18: {
                dType = DataTypeFactory.getBlobType();
                break;
            }
            case 46: {
                dType = DataTypeFactory.getClobType();
                break;
            }
            case 107: {
                dType = DataTypeFactory.getNullType();
                break;
            }
            case 48: {
                dType = DataTypeFactory.getDataLinkType();
                break;
            }
            case 102: {
                dType = DataTypeFactory.getArrayType();
                break;
            }
            case 103: {
                dType = DataTypeFactory.getMultisetType();
                break;
            }
            case 101: {
                dType = DataTypeFactory.getRowType();
                break;
            }
            case 104: {
                dType = DataTypeFactory.getStructType();
                break;
            }
            case 113: {
                dType = DataTypeFactory.getMapType(null, null);
                break;
            }
            case 114: {
                dType = DataTypeFactory.getJSONType();
                break;
            }
        }
        return dType;
    }

    public static int getJdbcDataType(byte cclDType) {
        int jdbcType;
        switch (cclDType) {
            case 1: 
            case 45: 
            case 55: 
            case 56: {
                jdbcType = 1;
                break;
            }
            case 2: {
                jdbcType = -6;
                break;
            }
            case 4: {
                jdbcType = 5;
                break;
            }
            case 6: {
                jdbcType = 4;
                break;
            }
            case 8: {
                jdbcType = -5;
                break;
            }
            case 10: {
                jdbcType = 6;
                break;
            }
            case 11: {
                jdbcType = 8;
                break;
            }
            case 12: {
                jdbcType = 3;
                break;
            }
            case 54: {
                jdbcType = 2;
                break;
            }
            case 57: {
                jdbcType = 91;
                break;
            }
            case 58: {
                jdbcType = 92;
                break;
            }
            case 59: {
                jdbcType = 93;
                break;
            }
            default: {
                jdbcType = 1;
            }
        }
        return jdbcType;
    }

    public static IDataType getType(String typeSpec) {
        IDataType result = null;
        if (typeSpec.equals("string")) {
            result = DataTypeFactory.getStringType();
        } else if (typeSpec.equals("long")) {
            result = DataTypeFactory.getLongType();
        } else if (typeSpec.equals("currencyCode")) {
            result = DataTypeFactory.getCurrencyCodeType();
        } else if (typeSpec.equals("dimensionUniqueName")) {
            result = DataTypeFactory.getDimensionUniqueNameType();
        } else if (typeSpec.equals("hierarchyUniqueName")) {
            result = DataTypeFactory.getHierarchyUniqueNameType();
        } else if (typeSpec.equals("levelLabel")) {
            result = DataTypeFactory.getLevelLabelType();
        } else if (typeSpec.equals("levelNumber")) {
            result = DataTypeFactory.getLevelNumberType();
        } else if (typeSpec.equals("levelUniqueName")) {
            result = DataTypeFactory.getLevelUniqueNameType();
        } else if (typeSpec.equals("memberCaption")) {
            result = DataTypeFactory.getMemberCaptionType();
        } else if (typeSpec.equals("memberDescription")) {
            result = DataTypeFactory.getMemberDescriptionType();
        } else if (typeSpec.equals("string")) {
            result = DataTypeFactory.getMemberType();
        } else if (typeSpec.equals("memberUniqueName")) {
            result = DataTypeFactory.getMemberUniqueNameType();
        } else if (typeSpec.equals("parentUniqueName")) {
            result = DataTypeFactory.getParentUniqueNameType();
        } else if (typeSpec.equals("parentLevelNumber")) {
            result = DataTypeFactory.getParentLevelNumberType();
        } else if (typeSpec.equals("queryItemModelID")) {
            result = DataTypeFactory.getQueryItemModelIDType();
        } else if (typeSpec.equals("rollupType")) {
            result = DataTypeFactory.getMemberRollupType();
        } else if (typeSpec.equals("businessKey")) {
            result = DataTypeFactory.getBusinessKeyType();
        } else if (typeSpec.equals("PPDSCode")) {
            result = DataTypeFactory.getPPDSCodeType();
        } else if (typeSpec.equals("MultiPartBusinessKey")) {
            result = DataTypeFactory.getMultiPartBusinessKeyType();
        } else {
            try {
                result = SQLProcessor.parseDataType(typeSpec);
            }
            catch (ParseException e) {
                result = null;
            }
        }
        return result;
    }

    public static IDataType createDataTypeFromStandardJDBCType(ResultSetMetaData metadata, int columnNo) {
        DataType dataType = null;
        try {
            String typeName = metadata.getColumnTypeName(columnNo);
            int type = metadata.getColumnType(columnNo);
            String name = metadata.getColumnName(columnNo);
            switch (type) {
                case -7: {
                    dataType = DataTypeFactory.getSmallintType(0);
                    break;
                }
                case 16: {
                    dataType = DataTypeFactory.getBooleanType();
                    break;
                }
                case 1: {
                    dataType = DataTypeFactory.getCharType(metadata.getColumnDisplaySize(columnNo));
                    break;
                }
                case 12: {
                    dataType = DataTypeFactory.getVarcharType(metadata.getColumnDisplaySize(columnNo));
                    break;
                }
                case -6: 
                case 5: {
                    int scale = metadata.getScale(columnNo);
                    dataType = DataTypeFactory.getSmallintType(scale);
                    break;
                }
                case 4: {
                    int scale = metadata.getScale(columnNo);
                    dataType = DataTypeFactory.getIntegerType(scale);
                    break;
                }
                case -5: {
                    int scale = metadata.getScale(columnNo);
                    dataType = DataTypeFactory.getLongType(scale);
                    break;
                }
                case 7: {
                    dataType = DataTypeFactory.getFloatType();
                    break;
                }
                case 6: {
                    int precision = metadata.getPrecision(columnNo);
                    if (precision <= 7) {
                        dataType = DataTypeFactory.getFloatType();
                        break;
                    }
                    dataType = DataTypeFactory.getDoubleType();
                    break;
                }
                case 8: {
                    dataType = DataTypeFactory.getDoubleType();
                    break;
                }
                case 2: 
                case 3: {
                    int precision = metadata.getPrecision(columnNo);
                    int scale = metadata.getScale(columnNo);
                    if (scale < 0 || precision < scale) {
                        dataType = DataTypeFactory.getDoubleType();
                        break;
                    }
                    dataType = DataTypeFactory.getDecimalType(precision, scale);
                    break;
                }
                case 92: {
                    dataType = DataTypeFactory.getTimeType();
                    break;
                }
                case 91: {
                    dataType = DataTypeFactory.getDateType();
                    break;
                }
                case 93: {
                    dataType = DataTypeFactory.getTimestampType();
                    break;
                }
                case 2004: {
                    dataType = DataTypeFactory.getBlobType();
                    break;
                }
                case 2005: 
                case 2011: {
                    dataType = DataTypeFactory.getClobType();
                    break;
                }
                case -16: 
                case -1: {
                    if ("xml".equalsIgnoreCase(typeName)) {
                        dataType = DataTypeFactory.getXmlType();
                        break;
                    }
                    if (type == -1) {
                        dataType = DataTypeFactory.getVarcharType(metadata.getColumnDisplaySize(columnNo));
                        break;
                    }
                    dataType = DataTypeFactory.getNVarcharType(metadata.getColumnDisplaySize(columnNo));
                    break;
                }
                case -2: {
                    dataType = BinaryType.DEFAULTBINARYTYPE;
                    break;
                }
                case -4: 
                case -3: {
                    dataType = VarBinaryType.DEFAULTVARBINARYTYPE;
                    break;
                }
                case 2009: {
                    dataType = DataTypeFactory.getXmlType();
                    break;
                }
                case -15: {
                    dataType = DataTypeFactory.getNCharType(metadata.getColumnDisplaySize(columnNo));
                    break;
                }
                case -9: {
                    dataType = DataTypeFactory.getNVarcharType(metadata.getColumnDisplaySize(columnNo));
                    break;
                }
                case 1111: {
                    if (typeName.equals("XML")) {
                        dataType = DataTypeFactory.getXmlType();
                        break;
                    }
                    dataType = DataTypeFactory.getStringType();
                    break;
                }
                case 2003: {
                    dataType = DataTypeFactory.getArrayType(ObjectType.OBJECTTYPE);
                    break;
                }
                case 2002: {
                    dataType = DataTypeFactory.getStringType();
                    break;
                }
                case -8: {
                    dataType = DataTypeFactory.getStringType();
                    break;
                }
                case 2000: 
                case 2001: {
                    dataType = DataTypeFactory.getObjectType();
                    break;
                }
                case 2006: {
                    dataType = DataTypeFactory.getRefType();
                    break;
                }
                case 70: {
                    dataType = DataTypeFactory.getDataLinkType();
                    break;
                }
                case 2012: {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_UnsupportedColumnDataType, "refcursor", name);
                }
                default: {
                    return null;
                }
            }
        }
        catch (SQLException e) {
            throw new XQERuntimeException(XQEMessageKeys.DAT_RSMDDataSourceAdapterError, e.toString());
        }
        return dataType;
    }

    public static ArrayType getArrayType() {
        return new ArrayType();
    }

    public static ArrayType getArrayType(IDataType dType) {
        return new ArrayType(dType);
    }

    public static ArrayType getArrayType(IDataType dType, int length) {
        return new ArrayType(dType, length);
    }

    public static ContextValueType getContextValueType(IDataType valueType) {
        return new ContextValueType(valueType);
    }

    public static BinaryType getBinaryType() {
        return BinaryType.DEFAULTBINARYTYPE;
    }

    public static BinaryType getBinaryType(int length) {
        return new BinaryType(length);
    }

    public static VarBinaryType getVarBinaryType() {
        return VarBinaryType.DEFAULTVARBINARYTYPE;
    }

    public static VarBinaryType getVarBinaryType(int length) {
        return new VarBinaryType(length);
    }

    public static MultisetType getMultisetType() {
        return new MultisetType();
    }

    public static MultisetType getMultisetType(IDataType dType) {
        return new MultisetType(dType);
    }

    public static StructType getStructType() {
        return new StructType();
    }

    public static MapType getMapType(IDataType keyDataType, IDataType valueDataType) {
        return new MapType(keyDataType, valueDataType);
    }

    public static CurrencyCodeType getCurrencyCodeType() {
        return CurrencyCodeType.DEFAULTCURRENCYCODETYPE;
    }

    public static DimensionUniqueNameType getDimensionUniqueNameType() {
        return DimensionUniqueNameType.DEFAULTDIMENSIONUNIQUENAMETYPE;
    }

    public static HierarchyUniqueNameType getHierarchyUniqueNameType() {
        return HierarchyUniqueNameType.DEFAULTHIERARCHYUNIQUENAMETYPE;
    }

    public static LevelType getLevelType() {
        return LevelType.LEVELTYPE;
    }

    public static LevelLabelType getLevelLabelType() {
        return LevelLabelType.DEFAULTLEVELLABELTYPE;
    }

    public static LevelNumberType getLevelNumberType() {
        return LevelNumberType.LEVELNUMBERTYPE;
    }

    public static LevelUniqueNameType getLevelUniqueNameType() {
        return LevelUniqueNameType.DEFAULTLEVELUNIQUENAMETYPE;
    }

    public static MemberCaptionType getMemberCaptionType() {
        return MemberCaptionType.DEFAULTMEMBERCAPTIONTYPE;
    }

    public static MemberDescriptionType getMemberDescriptionType() {
        return MemberDescriptionType.DEFAULTMEMBERDESCRIPTIONTYPE;
    }

    public static MemberUniqueNameType getMemberUniqueNameType() {
        return MemberUniqueNameType.DEFAULTMEMBERUNIQUENAMETYPE;
    }

    public static ParentUniqueNameType getParentUniqueNameType() {
        return ParentUniqueNameType.DEFAULTPARENTUNIQUENAMETYPE;
    }

    public static ParentLevelNumberType getParentLevelNumberType() {
        return ParentLevelNumberType.DEFAULTPARENTLEVELNUMBERTYPE;
    }

    public static QueryItemModelIDType getQueryItemModelIDType() {
        return QueryItemModelIDType.DEFAULTQUERYITEMMODELIDTYPE;
    }

    public static MemberType getMemberType() {
        return MemberType.MEMBERTYPE;
    }

    public static MeasureType getMeasureType() {
        return MeasureType.MEASURETYPE;
    }

    public static MemberRollupType getMemberRollupType() {
        return MemberRollupType.DEFAULTMEMBERROLLUPTYPE;
    }

    public static BusinessKeyType getBusinessKeyType() {
        return BusinessKeyType.DEFAULTBUSINESSKEYTYPE;
    }

    public static PPDSCodeType getPPDSCodeType() {
        return PPDSCodeType.PPDSCODETYPE;
    }

    public static MultiPartBusinessKeyType getMultiPartBusinessKeyType() {
        return MultiPartBusinessKeyType.DEFAULTMULTIPARTBUSINESSKEYTYPE;
    }

    public static TextType getTextType() {
        return TextType.TEXTTYPE;
    }

    public static NumericType getNumericType() {
        return NumericType.NUMERICTYPE;
    }

    public static AnyType getAnyType() {
        return AnyType.ANYTYPE;
    }
}

