/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.types;

import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.DataType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IRowType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultsets.tabular.ColumnInfo;
import com.cognos.xqe.resultsets.tabular.RowsetInfo;
import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.List;

public class RowType
extends DataType
implements IRowType {
    static final long serialVersionUID = -3247238578237432L;
    protected List<Field> fieldList = new ArrayList<Field>();
    public static final String TYPE_NAME = "row";
    public static final RowType ROWTYPE = new RowType();

    RowType() {
        super((byte)101, DataSubType.ROWTYPE);
    }

    RowType(byte dType) {
        super(dType, DataSubType.ROWTYPE);
    }

    RowType(IDataType[] theColumnTypes) {
        super((byte)101, DataSubType.ROWTYPE);
        for (int i = 0; i < theColumnTypes.length; ++i) {
            this.fieldList.add(new Field(theColumnTypes[i]));
        }
    }

    public void addField(String name, IDataType dType) {
        this.fieldList.add(new Field(name, dType));
    }

    @Override
    public IValue createValue() {
        return DataValueFactory.createRowValue(this);
    }

    @Override
    public IValue createValue(Collator collator) {
        return DataValueFactory.createRowValue(collator, this);
    }

    @Override
    public int getEncodedValueSize() {
        int size = 0;
        for (Field field : this.fieldList) {
            size += field.getDataType().getEncodedValueSize();
        }
        return size;
    }

    public int getNumberColumns() {
        return this.fieldList.size();
    }

    @Override
    public String getFieldName(int index) {
        return this.fieldList.get(index).getName();
    }

    @Override
    public IDataType getFieldDataType(int index) {
        return this.fieldList.get(index).getDataType();
    }

    public IDataType getFieldDataType(String name) {
        for (Field field : this.fieldList) {
            if (!field.getName().equals(name)) continue;
            return field.getDataType();
        }
        return null;
    }

    public IDataType[] getDataTypes() {
        IDataType[] dTypes = new IDataType[this.fieldList.size()];
        int i = 0;
        for (Field field : this.fieldList) {
            dTypes[i++] = field.getDataType();
        }
        return dTypes;
    }

    public IRowsetInfo getRowsetInfo() {
        RowsetInfo rowsetInfo = new RowsetInfo();
        for (Field field : this.fieldList) {
            rowsetInfo.addColumnInfo(new ColumnInfo(field.getName(), field.getDataType()));
        }
        return rowsetInfo;
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public int getLength() {
        int length = 0;
        for (Field field : this.fieldList) {
            length += field.getDataType().getLength();
        }
        return length;
    }

    @Override
    public String getSQLText() {
        return this.toString();
    }

    @Override
    public boolean exactlyEquivalent(Object obj) {
        if (!(obj instanceof RowType)) {
            return false;
        }
        RowType dt = (RowType)obj;
        if (!this.equals(dt)) {
            return false;
        }
        for (int i = 0; i < this.fieldList.size(); ++i) {
            if (this.getFieldDataType(i).exactlyEquivalent(dt.getFieldDataType(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getTypeName().toUpperCase());
        buffer.append("(");
        for (int i = 0; i < this.fieldList.size(); ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.fieldList.get(i).toString());
        }
        buffer.append(")");
        return buffer.toString();
    }

    protected class Field {
        private static final String DOUBLE_QUOTE = "\"";
        private String name;
        private IDataType dataType;

        public Field(IDataType theDataType) {
            this.dataType = theDataType;
        }

        public Field(String theName, IDataType theDataType) {
            this.name = theName;
            this.dataType = theDataType;
        }

        public String getName() {
            return this.name;
        }

        public IDataType getDataType() {
            return this.dataType;
        }

        public String toString() {
            if (this.dataType == null) {
                return "";
            }
            StringBuilder buffer = new StringBuilder();
            if (this.name != null && this.name.length() != 0) {
                buffer.append(DOUBLE_QUOTE);
                buffer.append(this.name);
                buffer.append(DOUBLE_QUOTE);
                buffer.append(" ");
            }
            buffer.append(this.dataType.getSQLText());
            return buffer.toString();
        }
    }
}

