/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.types;

import com.cognos.xqe.data.types.ExternalBufferType;
import com.cognos.xqe.data.types.TypeInvalidArgumentException;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.VarcharValue;
import com.ibm.icu.text.Collator;

public class VarcharType
extends ExternalBufferType {
    static final long serialVersionUID = -5117305801160082662L;
    public static final String TYPE_NAME = "varchar";
    public static final VarcharType DEFAULTVARCHARTYPE = new VarcharType(-1);

    VarcharType(int maxStrLength) {
        super(maxStrLength);
    }

    protected VarcharType(byte dType, int maxStrLength) throws TypeInvalidArgumentException {
        super(dType, maxStrLength);
    }

    @Override
    public IValue createValue(Collator collator) {
        VarcharValue v = DataValueFactory.createVarcharValue(this, collator);
        return v;
    }

    @Override
    public IValue createValue() {
        return DataValueFactory.createVarcharValue(this);
    }

    @Override
    public int getEncodedValueSize() {
        return VarcharValue.getEncodedSize();
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean exactlyEquivalent(Object obj) {
        boolean status = super.exactlyEquivalent(obj);
        if (status) {
            status = obj instanceof VarcharType;
        }
        return status;
    }

    @Override
    public boolean hasPrecision() {
        return this.getLength() != -1;
    }

    @Override
    public String toModelType() {
        return "characterLength32";
    }

    @Override
    public int getJDBCType() {
        return 12;
    }

    @Override
    public String toString() {
        return this.getSQLText().toLowerCase();
    }

    @Override
    public String getSQLText() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getSQLTypeName());
        if (this.maximumLength >= 0) {
            buffer.append(String.format("(%1$d)", this.maximumLength));
        } else {
            buffer.append("(MAX)");
        }
        return buffer.toString();
    }
}

