/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.types.ArrayType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IAppendable;
import com.cognos.xqe.data.values.ICollection;
import com.cognos.xqe.data.values.IElementRef;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.XDataContext;
import com.ibm.icu.text.Collator;
import com.ibm.json.java.JSONArray;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.dom4j.Element;

public class ArrayValue
extends Value
implements IElementRef,
IAppendable,
ICollection {
    private static final String COMMA_SPACE = ", ";
    private static final String CLOSE_BRACKET = "]";
    private static final String OPEN_BRACKET = "[";
    static final long serialVersionUID = 1L;
    private IValue[] values;

    ArrayValue(ArrayType dType) {
        super(dType);
    }

    public IValue createValue(Collator collator) {
        return DataValueFactory.createArrayValue(this.dataType);
    }

    @Override
    public void set(Object arr) {
        Object[] contents = (Object[])arr;
        IDataType elementType = ((ArrayType)this.dataType).getElementType();
        Value[] tmpValues = new Value[contents.length];
        for (int i = 0; i < contents.length; ++i) {
            tmpValues[i] = (Value)elementType.createValue();
            tmpValues[i].set(contents[i]);
        }
        this.values = tmpValues;
        this.setNotNull();
    }

    public void set(Value v) throws XQERuntimeException {
        this.set(((ArrayValue)v).getValues());
    }

    public void set(IValue[] vArray) {
        this.values = new Value[vArray.length];
        for (int i = 0; i < vArray.length; ++i) {
            this.values[i] = (Value)vArray[i].copy();
        }
        this.setNotNull();
    }

    public void set(Value[] vArray) {
        if (vArray == null) {
            this.setNull();
            return;
        }
        this.values = vArray;
        this.setNotNull();
    }

    public Value[] getValues() {
        Value[] result = new Value[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            result[i] = (Value)this.values[i].copy();
        }
        return result;
    }

    public void setValue(int index, IValue aValue) {
        if (this.values == null) {
            this.values = new Value[this.dataType.getMaxLength()];
        }
        if (index < 0 || index >= this.values.length) {
            throw new IllegalArgumentException();
        }
        this.values[index] = (Value)aValue;
        this.setNotNull();
    }

    @Override
    public IValue get(Object key) {
        int index = ((Value)key).getInteger() - 1;
        if (index < 0 || index >= this.values.length) {
            throw new IllegalArgumentException();
        }
        return this.values[index];
    }

    public IValue getElement(int index) {
        if (index < 0 || index >= this.values.length) {
            throw new IllegalArgumentException();
        }
        return this.values[index];
    }

    @Override
    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        Object[] arr = new Object[this.values.length];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = ((Value)this.values[i]).getObject();
        }
        return arr;
    }

    @Override
    public Object getObject(Class<?> componentType) {
        if (this.isNull()) {
            return null;
        }
        Object[] arr = (Object[])Array.newInstance(componentType, this.values.length);
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = ((Value)this.values[i]).getObject(componentType);
        }
        return arr;
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(OPEN_BRACKET);
        for (int i = 0; i < this.values.length; ++i) {
            if (i > 0) {
                builder.append(COMMA_SPACE);
            }
            builder.append(((Value)this.values[i]).getString());
        }
        builder.append(CLOSE_BRACKET);
        return builder.toString();
    }

    @Override
    public void set(Collection<IValue> aCollection) {
        this.values = new Value[aCollection.size()];
        Iterator<IValue> it = aCollection.iterator();
        int i = 0;
        while (it.hasNext()) {
            this.values[i++] = (Value)it.next();
        }
        this.setNotNull();
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public boolean containsKey(Object iValue) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!this.values[i].equals(iValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.values.length == 0;
    }

    public BooleanValue sqlCompareTo(Object pObject) {
        ArrayValue v = (ArrayValue)pObject;
        if (this.isNull() || v.isNull()) {
            return BooleanValue.UNKNOWN;
        }
        if (this.compareTo(v) == 0) {
            return BooleanValue.TRUE;
        }
        return BooleanValue.FALSE;
    }

    @Override
    public int compareTo(Object pObject) {
        ArrayValue b = (ArrayValue)pObject;
        if (this.isNull() && b.isNull()) {
            return 0;
        }
        if (!this.isNull() && b.isNull()) {
            return 1;
        }
        if (this.isNull() && !b.isNull()) {
            return -1;
        }
        int result = 0;
        int minLength = Math.min(this.values.length, b.getValues().length);
        for (int i = 0; i < minLength; ++i) {
            result = this.values[i].compareTo(b.getElement(i));
            if (result == 0) continue;
            return result;
        }
        if (this.values.length == b.getValues().length) {
            return 0;
        }
        if (this.values.length == minLength) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object pObject) {
        return this.compareTo(pObject) == 0;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public Object copy() {
        ArrayValue v = new ArrayValue((ArrayType)this.dataType);
        v.setState(this.getState());
        if (!v.isNull()) {
            v.set(this.getValues());
        }
        return v;
    }

    @Override
    public void copyFrom(IValue iValue) throws XQERuntimeException {
        ArrayValue pValue = (ArrayValue)iValue;
        this.setState(pValue.getState());
        if (pValue.isNull()) {
            return;
        }
        this.set(pValue.getValues());
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        super.decode(context, iStream);
        if (this.isNull()) {
            return;
        }
        IDataType dType = ((ArrayType)this.dataType).getElementType();
        int length = iStream.readInt();
        Value[] tmpValues = new Value[length];
        for (int i = 0; i < length; ++i) {
            tmpValues[i] = (Value)dType.createValue();
            tmpValues[i].decode(context, iStream);
        }
        this.values = tmpValues;
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        super.encode(context, oStream);
        if (this.isNull()) {
            return;
        }
        oStream.writeInt(this.values.length);
        for (int i = 0; i < this.values.length; ++i) {
            ((Value)this.values[i]).encode(context, oStream);
        }
    }

    @Override
    public boolean exactlyEquivalent(Value otherValue) {
        boolean result = super.exactlyEquivalent(otherValue);
        if (result && this.isOK()) {
            ArrayValue otherArray = (ArrayValue)otherValue;
            for (int i = 0; i < this.values.length; ++i) {
                if (((Value)this.values[i]).exactlyEquivalent((Value)otherArray.getElement(i))) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    @Override
    public void append(IValue otherValue) {
        IValue[] otherValues = ((ArrayValue)otherValue).values;
        int size = this.values.length + otherValues.length;
        if (this.dataType.getMaxLength() > 0) {
            size = Math.min(this.dataType.getMaxLength(), size);
        }
        Value[] tmpValue = new Value[size];
        System.arraycopy(this.values, 0, tmpValue, 0, this.values.length);
        System.arraycopy(otherValues, 0, tmpValue, this.values.length, otherValues.length);
        this.values = tmpValue;
    }

    @Override
    public void set(IValue otherValue) {
        IValue[] otherValues = ((ArrayValue)otherValue).values;
        int size = otherValues.length;
        if (this.dataType.getMaxLength() > 0) {
            size = Math.min(this.dataType.getMaxLength(), size);
        }
        this.values = new Value[size];
        System.arraycopy(otherValues, 0, this.values, 0, size);
        this.setNotNull();
    }

    public void set(ArrayValue otherValue, int nElements) {
        this.values = new Value[nElements];
        System.arraycopy(otherValue.values, 0, this.values, 0, nElements);
        this.setNotNull();
    }

    @Override
    public Iterator<IValue> iterator() {
        return Arrays.asList(this.values).iterator();
    }

    @Override
    public Object toJSON() {
        if (this.isNull()) {
            return null;
        }
        JSONArray jArray = new JSONArray();
        for (int i = 0; i < this.values.length; ++i) {
            Value currentValue = (Value)this.values[i];
            jArray.add((Object)currentValue.getJSONLiteral());
        }
        return jArray;
    }

    @Override
    public void persistAttributes(XQEPersistContext ctx) {
        super.persistAttributes(ctx);
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
    }
}

