/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.data.types.DateType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntervalDayTimeType;
import com.cognos.xqe.data.types.IntervalQualifier;
import com.cognos.xqe.data.types.IntervalYearMonthType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.IntervalDayTimeValue;
import com.cognos.xqe.data.values.IntervalYearMonthValue;
import com.cognos.xqe.data.values.LongValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.TimestampValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.runtree.XDataContext;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class DateValue
extends DateTimeValue {
    static final long serialVersionUID = 1L;
    private static final int C_100 = 100;
    private static final int C_10000 = 10000;
    public static final String SAP_DATE_FORMAT = "yyyyMMdd";
    private static final String[] DATE_PATTERNS = new String[]{"yyyy-MM-dd", "yyyyMMdd"};
    private String formatString = "yyyy-MM-dd";

    DateValue() {
        super(DateType.DATETYPE);
    }

    @Override
    public void set(String sValue) throws ValueConversionException {
        if (sValue == null || sValue.length() == 0) {
            this.setNull();
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(this.formatString);
        ParsePosition pp = new ParsePosition(0);
        for (String pattern : DATE_PATTERNS) {
            pp.setErrorIndex(-1);
            pp.setIndex(0);
            this.setFormat(pattern);
            sdf.applyPattern(pattern);
            sdf.parse(sValue, pp);
            if (pp.getErrorIndex() != -1 || pp.getIndex() != pattern.length()) continue;
            java.util.Date d = sdf.getCalendar().getTime();
            this.set(d);
            this.setNotNull();
            return;
        }
        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "string", sValue, "date");
    }

    @Override
    public void set(long lValue) {
        super.set(lValue);
        this.clearTimeFromValue();
    }

    @Override
    public void set(Object o) {
        if (o == null) {
            this.setNull();
            return;
        }
        if (o instanceof Long) {
            this.set((Long)o);
        } else if (o instanceof java.util.Date) {
            this.set((java.util.Date)o);
        } else if (o instanceof IValue) {
            this.set((IValue)o);
        } else if (o instanceof String) {
            this.set((String)o);
        } else if (o instanceof LocalDate) {
            this.set((LocalDate)o);
        } else if (o instanceof OffsetDateTime) {
            this.set((OffsetDateTime)o);
        }
    }

    @Override
    public void set(LocalDate date) {
        if (null == date) {
            this.setNull();
            return;
        }
        this.setDate(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
    }

    @Override
    public void set(LocalDateTime dateTime) {
        if (null == dateTime) {
            this.setNull();
            return;
        }
        this.set(dateTime.toLocalDate());
    }

    @Override
    public void set(OffsetDateTime dateTime) {
        if (null == dateTime) {
            this.setNull();
            return;
        }
        this.set(dateTime.toLocalDate());
    }

    @Override
    public long getLong() {
        return this.getMilliseconds();
    }

    @Override
    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        return new java.util.Date(this.getMilliseconds());
    }

    @Override
    public Object getObject(Class<?> componentType) {
        if (this.isNull()) {
            return null;
        }
        if (componentType == java.util.Date.class) {
            return new java.util.Date(this.getMilliseconds());
        }
        return new Date(this.getMilliseconds());
    }

    @Override
    public int getInteger() {
        return this.getYear() * 10000 + this.getMonth() * 100 + this.getDay();
    }

    @Override
    public void set(IValue v) {
        if (v == null || v.isNull()) {
            this.setNull();
            return;
        }
        DateTimeValue dValue = (DateTimeValue)v;
        this.setDate(dValue.getYear(), dValue.getMonth(), dValue.getDay());
        this.copyFormatIdFrom(dValue);
    }

    public Calendar getCalendarWithUTCTimeZone() {
        GregorianCalendar c = new GregorianCalendar(UTC);
        c.set(1, this.getYear());
        c.set(2, this.getMonth() - 1);
        c.set(5, this.getDay());
        c.set(10, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        c.setLenient(false);
        return c;
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        SimpleDateFormat f = new SimpleDateFormat();
        f.applyPattern("yyyy-MM-dd");
        String result = f.format(this.getDate());
        return result;
    }

    @Override
    public String getSQLLiteral() {
        if (this.isNull()) {
            return null;
        }
        return "DATE '" + this.getString() + "'";
    }

    @Override
    public String getV5Literal() {
        return this.getString();
    }

    @Override
    public String getJDBCLiteral() {
        if (this.isNull()) {
            return null;
        }
        return "{d '" + this.getString() + "'}";
    }

    @Override
    public String getSPARQLLiteral() {
        if (this.isNull()) {
            return null;
        }
        return String.format("'%s'^^xsd:date", this.getString());
    }

    @Override
    public String getFormattedLiteral(String formatSpec) {
        if (this.isNull()) {
            return null;
        }
        return String.format(formatSpec, this.getYear(), this.getMonth(), this.getDay());
    }

    @Override
    public String getXSDLiteral() {
        return this.getString();
    }

    @Override
    public int getHour() {
        return 0;
    }

    @Override
    public int getMinute() {
        return 0;
    }

    @Override
    public int getSecond() {
        return 0;
    }

    @Override
    public Timestamp getTimestamp() {
        if (this.isNull()) {
            return null;
        }
        TimestampValue t = DataValueFactory.createTimestampValue();
        t.set(this.getYear(), this.getMonth(), this.getDay(), 0, 0, 0, 0);
        return t.getTimestamp();
    }

    @Override
    public void add(IValue pValue) {
        if (this.isNull()) {
            return;
        }
        IDataType dataType = pValue.getDataType();
        if (dataType instanceof IntervalYearMonthType) {
            IntervalYearMonthValue i = (IntervalYearMonthValue)pValue;
            this.addYears(i.getSign() * i.getYear());
            this.addMonths(i.getSign() * i.getMonth());
        } else if (dataType instanceof IntervalDayTimeType) {
            IntervalDayTimeValue i = (IntervalDayTimeValue)pValue;
            this.addDays(i.getSign() * i.getDay());
        }
    }

    @Override
    public void subtract(IValue pValue) {
        if (this.isNull()) {
            return;
        }
        IDataType dataType = pValue.getDataType();
        if (dataType instanceof IntervalYearMonthType) {
            IntervalYearMonthValue i = (IntervalYearMonthValue)pValue;
            this.subtractYears(i.getSign() * i.getYear());
            this.subtractMonths(i.getSign() * i.getMonth());
        } else if (dataType instanceof IntervalDayTimeType) {
            IntervalDayTimeValue i = (IntervalDayTimeValue)pValue;
            if (((IntervalDayTimeType)dataType).getQualifier() == IntervalQualifier.INTERVAL_DAY) {
                this.subtractDays(i.getSign() * i.getDay());
            }
        }
    }

    @Override
    public DateTimeValue next() throws SQLException {
        DateValue result = (DateValue)this.copy();
        result.add(ONE_DAY);
        return result;
    }

    @Override
    public DateTimeValue prior() throws SQLException {
        DateValue result = (DateValue)this.copy();
        result.subtract(ONE_DAY);
        return result;
    }

    @Override
    public int compareTo(Object object) {
        Value val = (Value)object;
        if (this.isNull() && val.isNull()) {
            return 0;
        }
        if (!this.isNull() && val.isNull()) {
            return 1;
        }
        if (this.isNull() && !val.isNull()) {
            return -1;
        }
        DateTimeValue a = null;
        if (object instanceof TextValue) {
            a = DataValueFactory.createDateValue();
            ((DateValue)a).setFormat(this.getFormat());
            a.set(((TextValue)object).getDate());
        } else {
            a = (DateTimeValue)object;
        }
        int result = 0;
        result = this.getMilliseconds() > a.getMilliseconds() ? 1 : (this.getMilliseconds() < a.getMilliseconds() ? -1 : (this.getNanoseconds() == a.getNanoseconds() ? 0 : (this.getNanoseconds() > a.getNanoseconds() ? 1 : -1)));
        return result;
    }

    @Override
    public Object copy() {
        DateValue v = new DateValue();
        v.set(this);
        return v;
    }

    @Override
    public void copyFrom(IValue iValue) {
        Value pValue = (Value)iValue;
        if (pValue.isNull()) {
            this.setNull();
            return;
        }
        byte dType = iValue.getDataType().getCCLTypeCode();
        if (dType == 57) {
            this.set(iValue);
        } else if (dType == 59 || dType == 53) {
            this.set(((DateTimeValue)pValue).getDate());
            this.clearTimeFromValue();
            this.setNanoseconds(0);
        } else if (dType == 8) {
            this.set(((LongValue)pValue).value);
        } else {
            this.set(pValue.getString());
        }
        this.copyFormatIdFrom(pValue);
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        super.decode(context, iStream);
        if (this.isOK()) {
            this.set(iStream.readLong());
        }
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        super.encode(context, oStream);
        if (this.isOK()) {
            oStream.writeLong(this.getMilliseconds());
        }
    }

    public static int getEncodedSize() {
        return Value.getEncodedSize() + 8;
    }

    @Override
    public int sizeOf() {
        return ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.DATE);
    }

    public void setFormat(String dateFormat) {
        this.formatString = dateFormat;
    }

    public String getFormat() {
        return this.formatString;
    }

    @Override
    public boolean exactlyEquivalent(Value otherValue) {
        boolean result = super.exactlyEquivalent(otherValue);
        if (result && this.isOK()) {
            result = this.formatString.equals(((DateValue)otherValue).formatString);
        }
        return result;
    }

    @Override
    public Object toJSON() {
        if (this.isNull()) {
            return null;
        }
        return this.getXSDLiteral();
    }
}

