/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.data.types.DecimalType;
import com.cognos.xqe.data.values.BigDecimalValue;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.DecimalValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.exception.XQEMessageKeys;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class Decfloat128DecimalValue
extends BigDecimalValue {
    static final long serialVersionUID = 1L;
    private static MathContext mc = MathContext.DECIMAL128;

    protected Decfloat128DecimalValue(DecimalType aDataType) {
        super(aDataType);
    }

    @Override
    public int getPrecision() {
        return this.value.precision();
    }

    @Override
    public int getScale() {
        return this.value.scale();
    }

    @Override
    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public void abs() {
        if (this.isOK()) {
            this.value = this.value.abs(mc);
        }
    }

    @Override
    public void add(IValue aValue) throws ValueConversionException {
        if (!this.validateStates(aValue)) {
            return;
        }
        BigDecimal a = ((Value)aValue).getBigDecimal();
        this.value = this.value.add(a, mc);
    }

    @Override
    public void subtract(IValue aValue) {
        if (!this.validateStates(aValue)) {
            return;
        }
        BigDecimal a = ((Value)aValue).getBigDecimal();
        this.value = this.value.subtract(a, mc);
    }

    @Override
    public void multiply(IValue aValue) {
        if (!this.validateStates(aValue)) {
            return;
        }
        BigDecimal a = ((Value)aValue).getBigDecimal();
        this.value = this.value.multiply(a, mc);
    }

    @Override
    public void divide(IValue aValue) {
        if (!this.validateStates(aValue)) {
            return;
        }
        BigDecimal a = ((Value)aValue).getBigDecimal();
        if (a.compareTo(ZERO) == 0) {
            throw new ValueConversionException(XQEMessageKeys.DAT_DivisionByZero);
        }
        this.value = this.value.divide(a, mc);
    }

    @Override
    public void mod(IValue aValue) {
        if (!this.validateStates(aValue)) {
            return;
        }
        double dValue = ((Value)aValue).getDouble();
        if (dValue == 0.0) {
            return;
        }
        double d = this.value.doubleValue() % dValue;
        this.value = new BigDecimal(d, mc);
        this.setNotNull();
    }

    @Override
    public boolean exactlyEquivalent(Value otherValue) {
        boolean result = super.exactlyEquivalent(otherValue);
        if (result && this.isOK()) {
            result = this.value == null ? ((Decfloat128DecimalValue)otherValue).value == null : this.value.equals(((Decfloat128DecimalValue)otherValue).value);
        }
        return result;
    }

    @Override
    public BooleanValue sqlCompareTo(Object pObject) {
        DecimalValue a = (DecimalValue)pObject;
        if (!this.isOK() || !a.isOK()) {
            return BooleanValue.UNKNOWN;
        }
        BigDecimal b = a.getBigDecimal();
        if (this.value.compareTo(b) == 0) {
            return BooleanValue.TRUE;
        }
        return BooleanValue.FALSE;
    }

    @Override
    public Object copy() {
        Decfloat128DecimalValue v = new Decfloat128DecimalValue((DecimalType)this.dataType);
        v.copyFrom(this);
        return v;
    }

    @Override
    public void trunc(int n) {
        if (!this.isOK()) {
            return;
        }
        BigDecimal tmp = this.value;
        int scale = tmp.scale();
        if (n != 0) {
            tmp = tmp.movePointRight(n);
        }
        tmp = tmp.setScale(0, 1);
        if (n != 0) {
            tmp = tmp.movePointLeft(n);
        }
        this.value = tmp.setScale(scale);
    }

    @Override
    public void set(short aValue) {
        BigDecimal b;
        this.value = b = new BigDecimal(Short.toString(aValue));
        this.setNotNull();
    }

    @Override
    public void set(int aValue) {
        BigDecimal b;
        this.value = b = new BigDecimal(Integer.toString(aValue));
        this.setNotNull();
    }

    @Override
    public void set(long aValue) {
        BigDecimal b;
        this.value = b = new BigDecimal(Long.toString(aValue));
        this.setNotNull();
    }

    @Override
    public void set(BigDecimal aValue) {
        if (aValue == null) {
            this.setNull();
            return;
        }
        this.value = aValue;
        this.setNotNull();
    }

    @Override
    public void set(double aValue) {
        BigDecimal b;
        this.value = b = BigDecimal.valueOf(aValue);
        this.setNotNull();
    }

    @Override
    public void set(float aValue) {
        BigDecimal b;
        this.value = b = BigDecimal.valueOf(aValue);
        this.setNotNull();
    }

    @Override
    public void set(String aValue) throws ValueConversionException {
        BigDecimal b;
        if (aValue == null || aValue.compareTo("") == 0) {
            this.setNull();
            return;
        }
        DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        df.setParseBigDecimal(true);
        aValue = aValue.trim();
        if (aValue.charAt(0) == '+') {
            aValue = aValue.substring(1);
        }
        try {
            b = (BigDecimal)df.parse(aValue);
        }
        catch (Exception e) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, (Throwable)e, "string", aValue, "decimal");
        }
        this.value = b;
        this.setNotNull();
    }

    @Override
    public void set(IValue v) throws ValueConversionException {
        if (v == null || v.isNull()) {
            this.setNull();
            this.copyValidFormatIdFrom(v);
            return;
        }
        Value theValue = (Value)v;
        if (theValue.isOK()) {
            BigDecimal b = theValue.getBigDecimal();
            this.set(b);
            this.copyStateFrom(theValue);
            this.copyFormatIdFrom(theValue);
        }
    }
}

